/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsService;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsServiceImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.SizeDetails;
import org.alfresco.rest.framework.core.exceptions.InvalidNodeTypeException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

public class SizeDetailsImpl
implements SizeDetails,
InitializingBean {
    private final Nodes nodes;
    private final NodeSizeDetailsService nodeSizeDetailsService;

    public SizeDetailsImpl(Nodes nodes, NodeSizeDetailsService nodeSizeDetailsService) {
        this.nodes = nodes;
        this.nodeSizeDetailsService = nodeSizeDetailsService;
    }

    @Override
    public NodeSizeDetailsServiceImpl.NodeSizeDetails generateNodeSizeDetailsRequest(String nodeId) {
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        this.validateType(nodeRef);
        Optional nodeSizeDetails = this.nodeSizeDetailsService.getSizeDetails(nodeId);
        String actionId = nodeSizeDetails.map(NodeSizeDetailsServiceImpl.NodeSizeDetails::getJobId).orElseGet(() -> this.executeSizeDetails(nodeRef));
        return new NodeSizeDetailsServiceImpl.NodeSizeDetails(actionId);
    }

    @Override
    public NodeSizeDetailsServiceImpl.NodeSizeDetails getNodeSizeDetails(String nodeId, String jobId) {
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        this.validateType(nodeRef);
        Optional optionalDetails = this.nodeSizeDetailsService.getSizeDetails(nodeId);
        return optionalDetails.map(details -> {
            String cachedJobId = details.getJobId();
            if (cachedJobId != null && !jobId.equalsIgnoreCase(cachedJobId)) {
                throw new NotFoundException("jobId does not exist");
            }
            return details;
        }).orElseGet(() -> new NodeSizeDetailsServiceImpl.NodeSizeDetails(nodeId, NodeSizeDetailsServiceImpl.NodeSizeDetails.STATUS.NOT_INITIATED));
    }

    private String executeSizeDetails(NodeRef nodeRef) {
        String jobId = GUID.generate();
        NodeSizeDetailsServiceImpl.NodeSizeDetails nodeSizeDetails = new NodeSizeDetailsServiceImpl.NodeSizeDetails(nodeRef.getId(), jobId, NodeSizeDetailsServiceImpl.NodeSizeDetails.STATUS.PENDING);
        this.nodeSizeDetailsService.putSizeDetails(nodeRef.getId(), nodeSizeDetails);
        this.nodeSizeDetailsService.invokeSizeDetailsExecutor(nodeRef, jobId);
        return jobId;
    }

    private void validateType(NodeRef nodeRef) throws InvalidNodeTypeException {
        if (!this.nodes.isSubClass(nodeRef, ContentModel.TYPE_FOLDER, false)) {
            throw new InvalidNodeTypeException("Node id " + nodeRef.getId() + " does not represent a folder.");
        }
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
        ParameterCheck.mandatory((String)"nodeSizeDetailsServiceImpl", (Object)this.nodeSizeDetailsService);
    }
}

