/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

class CommentsLibJs {
    private static final String COMMENTS_TOPIC_NAME = "Comments";

    CommentsLibJs() {
    }

    public static int getCommentsCount(NodeRef node, ServiceRegistry services) {
        return CommentsLibJs.getComments(node, services).size();
    }

    public static List<ChildAssociationRef> getComments(NodeRef node, ServiceRegistry services) {
        List children;
        List<Object> result = new ArrayList<ChildAssociationRef>();
        NodeRef commentsFolder = CommentsLibJs.getCommentsFolder(node, services);
        if (commentsFolder != null && !(children = services.getNodeService().getChildAssocs(commentsFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).isEmpty()) {
            result = children;
        }
        return result;
    }

    public static NodeRef getCommentsFolder(NodeRef node, ServiceRegistry services) {
        NodeRef result = null;
        if (services.getNodeService().hasAspect(node, ForumModel.ASPECT_DISCUSSABLE)) {
            List forumFolders = services.getNodeService().getChildAssocs(node, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
            NodeRef forumFolder = ((ChildAssociationRef)forumFolders.get(0)).getChildRef();
            List topicFolder = services.getNodeService().getChildAssocs(forumFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)COMMENTS_TOPIC_NAME));
            result = topicFolder.isEmpty() ? null : ((ChildAssociationRef)topicFolder.get(0)).getChildRef();
        }
        return result;
    }
}

