/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model.rules;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.api.model.rules.CompositeCondition;
import org.alfresco.rest.api.model.rules.RuleTrigger;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.Experimental;

@Experimental
public class Rule {
    private String id;
    private String name;
    private String description;
    private boolean isEnabled;
    private boolean isInheritable;
    private boolean isAsynchronous;
    private Boolean isShared;
    private String errorScript;
    private List<RuleTrigger> triggers = List.of(RuleTrigger.INBOUND);
    private CompositeCondition conditions;
    private List<Action> actions;

    @UniqueId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean getIsInheritable() {
        return this.isInheritable;
    }

    public void setIsInheritable(boolean isInheritable) {
        this.isInheritable = isInheritable;
    }

    public boolean getIsAsynchronous() {
        return this.isAsynchronous;
    }

    public void setIsAsynchronous(boolean isAsynchronous) {
        this.isAsynchronous = isAsynchronous;
    }

    public String getErrorScript() {
        return this.errorScript;
    }

    public void setErrorScript(String errorScript) {
        this.errorScript = errorScript;
    }

    public Boolean isIsShared() {
        return this.isShared;
    }

    public void setIsShared(Boolean shared) {
        this.isShared = shared;
    }

    public List<String> getTriggers() {
        if (this.triggers == null) {
            return null;
        }
        return this.triggers.stream().map(RuleTrigger::getValue).collect(Collectors.toList());
    }

    public void setTriggers(List<String> triggers) {
        if (triggers != null) {
            this.triggers = triggers.stream().map(RuleTrigger::of).collect(Collectors.toList());
        }
    }

    public void setRuleTriggers(List<RuleTrigger> triggers) {
        this.triggers = triggers;
    }

    public CompositeCondition getConditions() {
        return this.conditions;
    }

    public void setConditions(CompositeCondition conditions) {
        this.conditions = conditions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public String toString() {
        return "Rule{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', isEnabled=" + this.isEnabled + ", isInheritable=" + this.isInheritable + ", isAsynchronous=" + this.isAsynchronous + ", isShared=" + this.isShared + ", errorScript='" + this.errorScript + "', triggers=" + String.valueOf(this.triggers) + ", conditions=" + String.valueOf(this.conditions) + ", actions=" + String.valueOf(this.actions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.isEnabled == rule.isEnabled && this.isInheritable == rule.isInheritable && this.isAsynchronous == rule.isAsynchronous && Objects.equals(this.isShared, rule.isShared) && Objects.equals(this.id, rule.id) && Objects.equals(this.name, rule.name) && Objects.equals(this.description, rule.description) && Objects.equals(this.errorScript, rule.errorScript) && Objects.equals(this.triggers, rule.triggers) && Objects.equals(this.conditions, rule.conditions) && Objects.equals(this.actions, rule.actions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.isEnabled, this.isInheritable, this.isAsynchronous, this.isShared, this.errorScript, this.triggers, this.conditions, this.actions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String name;
        private String description;
        private boolean isEnabled;
        private boolean isInheritable;
        private boolean isAsynchronous;
        private Boolean isShared;
        private String errorScript;
        private List<RuleTrigger> triggers = List.of(RuleTrigger.INBOUND);
        private CompositeCondition conditions;
        private List<Action> actions;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder isInheritable(boolean isInheritable) {
            this.isInheritable = isInheritable;
            return this;
        }

        public Builder isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder errorScript(String errorScript) {
            this.errorScript = errorScript;
            return this;
        }

        public Builder triggers(List<RuleTrigger> triggers) {
            this.triggers = triggers;
            return this;
        }

        public Builder conditions(CompositeCondition conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public Rule create() {
            Rule rule = new Rule();
            rule.setId(this.id);
            rule.setName(this.name);
            rule.setDescription(this.description);
            rule.setIsEnabled(this.isEnabled);
            rule.setIsInheritable(this.isInheritable);
            rule.setIsAsynchronous(this.isAsynchronous);
            rule.setIsShared(this.isShared);
            rule.setErrorScript(this.errorScript);
            rule.setRuleTriggers(this.triggers);
            rule.setConditions(this.conditions);
            rule.setActions(this.actions);
            return rule;
        }
    }
}

