/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueriesSitesApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_QUERIES_LSS = "queries/sites";
    private SiteService siteService;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
    }

    private void checkApiCall(String term, String orderBy, PublicApiClient.Paging paging, int expectedStatus, String[] expectedIds, String ... ids) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("term", "\"" + term + "\"");
        if (orderBy != null) {
            params.put("orderBy", orderBy);
        }
        this.dummySearchServiceQueryNodeRefs.clear();
        for (String id : ids) {
            NodeRef nodeRef = this.getNodeRef(id);
            this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        }
        expectedIds = expectedIds != null ? expectedIds : ids;
        HttpResponse response = this.getAll(URL_QUERIES_LSS, paging, params, 200);
        if (expectedStatus == 200) {
            String termWithEscapedAsterisks = term.replaceAll("\\*", "\\\\*");
            String expectedQuery = "TYPE:\"{http://www.alfresco.org/model/site/1.0}site\" AND (\"*" + termWithEscapedAsterisks + "*\")";
            ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
            ((SearchService)Mockito.verify((Object)this.mockSearchService, (VerificationMode)Mockito.times((int)(++this.callCountToMockSearchService)))).query((SearchParameters)searchParametersCaptor.capture());
            SearchParameters parameters = (SearchParameters)searchParametersCaptor.getValue();
            Assert.assertEquals((String)"Query", (Object)expectedQuery, (Object)parameters.getQuery());
            List<Site> sites = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Site.class);
            Assert.assertEquals((long)expectedIds.length, (long)sites.size());
            if (orderBy != null) {
                for (int i = 0; i < expectedIds.length; ++i) {
                    String id = expectedIds[i];
                    String actualId = sites.get(i).getId();
                    Assert.assertEquals((String)("Order " + i + ":"), (Object)id, (Object)actualId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveSearchSites() throws Exception {
        this.setRequestContext(user1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        int sCount = 5;
        Assert.assertTrue((sCount > 4 ? 1 : 0) != 0);
        ArrayList<String> siteIds = new ArrayList<String>(sCount);
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            Object siteI = "a";
            String siteT = "siteT";
            String siteD = "siteD";
            int charValue = ((String)siteI).charAt(0);
            for (int i = 1; i <= sCount; ++i) {
                String num = String.format("%05d", i);
                siteI = (String)siteI + String.valueOf((char)(++charValue));
                String siteId = (String)siteI + num + this.RUNID;
                String siteTitle = siteT + num + siteT;
                String siteDescrip = siteD + num + siteD;
                String createdSiteId = this.createSite(siteId, siteTitle, siteDescrip, SiteVisibility.PRIVATE, 201).getId();
                siteIds.add(createdSiteId);
            }
            String ab = (String)siteIds.get(0);
            String abc = (String)siteIds.get(1);
            String abcd = (String)siteIds.get(2);
            String abcde = (String)siteIds.get(3);
            String abcdef = (String)siteIds.get(4);
            this.checkApiCall("ab", null, paging, 200, null, ab, abc, abcd, abcde, abcdef);
            this.checkApiCall("abc", null, paging, 200, null, abc, abcd, abcde, abcdef);
            this.checkApiCall("abcd", null, paging, 200, null, abcd, abcde, abcdef);
            this.checkApiCall("abcde", null, paging, 200, null, abcde, abcdef);
            this.checkApiCall("abcd00003", null, paging, 200, null, abcd);
            this.checkApiCall(siteT, null, paging, 200, null, ab, abc, abcd, abcde, abcdef);
            this.checkApiCall(siteT + String.format("%05d", 2) + siteT, null, paging, 200, null, abc);
            this.checkApiCall(siteD + "*", null, paging, 200, null, ab, abc, abcd, abcde, abcdef);
            this.checkApiCall(siteD + String.format("%05d", 3) + siteD, null, paging, 200, null, abcd);
            this.getAll(URL_QUERIES_LSS, paging, null, 400);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("term", "a");
            this.getAll(URL_QUERIES_LSS, paging, params, 400);
            params = new HashMap(1);
            params.put("term", "  \"a *\"  ");
            this.getAll(URL_QUERIES_LSS, paging, params, 400);
            this.setRequestContext(null);
            this.getAll(URL_QUERIES_LSS, paging, params, 401);
        }
        finally {
            this.setRequestContext(user1);
            for (String siteId : siteIds) {
                this.deleteSite(siteId, true, 204);
            }
        }
    }

    private NodeRef getNodeRef(String createdSiteId) {
        String userUnderTest = AuthenticationUtil.getFullyAuthenticatedUser();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
        NodeRef nodeRef = this.siteService.getSite(createdSiteId).getNodeRef();
        nodeRef = this.tenantService.getName(nodeRef);
        AuthenticationUtil.setFullyAuthenticatedUser((String)userUnderTest);
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveSearchSites_SortPage() throws Exception {
        this.setRequestContext(user1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        ArrayList siteIds = new ArrayList(5);
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            String s1 = this.createSite("siABCDEF" + this.RUNID, "ABCDEF DEF", "sdABCDEF", SiteVisibility.PRIVATE, 201).getId();
            String s2 = this.createSite("siABCD" + this.RUNID, "ABCD DEF", "sdABCD", SiteVisibility.PRIVATE, 201).getId();
            String s3 = this.createSite("siABCDE" + this.RUNID, "ABCDE DEF", "sdABCDE", SiteVisibility.PRIVATE, 201).getId();
            String s4 = this.createSite("siAB" + this.RUNID, "AB DEF", "sdAB", SiteVisibility.PRIVATE, 201).getId();
            String s5 = this.createSite("siABC" + this.RUNID, "ABC DEF", "sdABC", SiteVisibility.PRIVATE, 201).getId();
            this.checkApiCall("siAB", null, paging, 200, null, s4, s5, s2, s3, s1);
            this.checkApiCall("siAB", "title asc", paging, 200, null, s4, s5, s2, s3, s1);
            this.checkApiCall("siAB", "title desc", paging, 200, null, s1, s3, s2, s5, s4);
            this.checkApiCall("siAB", "title desc", this.getPaging(0, 2), 200, new String[]{s1, s3}, s1, s3, s2, s5, s4);
            this.checkApiCall("siAB", "title desc", this.getPaging(2, 2), 200, new String[]{s2, s5}, s1, s3, s2, s5, s4);
            this.checkApiCall("siAB", "title desc", this.getPaging(4, 2), 200, new String[]{s4}, s1, s3, s2, s5, s4);
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("term", "siAB");
            params.put("orderBy", "invalid asc");
            this.getAll(URL_QUERIES_LSS, paging, params, 400);
            this.setRequestContext(null);
            this.getAll(URL_QUERIES_LSS, paging, params, 401);
        }
        finally {
            this.setRequestContext(user1);
            for (String siteId : siteIds) {
                this.deleteSite(siteId, true, 204);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveSearchExcludesPrivateSites() throws Exception {
        String publicSiteId = null;
        String privateSiteId = null;
        try {
            this.setRequestContext(null, "admin", "admin");
            this.createUser("bartender");
            publicSiteId = this.createSite("samePrefixPublicSite", "samePrefixPublicSite", "Visible to all users", SiteVisibility.PUBLIC, 201).getId();
            privateSiteId = this.createSite("samePrefixPrivateSite", "samePrefixPrivateSite", "Hidden from bartender", SiteVisibility.PRIVATE, 201).getId();
            String[] searchResults = new String[]{publicSiteId, privateSiteId};
            String[] expectedSites = new String[]{publicSiteId};
            this.setRequestContext(null, "bartender", "password");
            AuthenticationUtil.setFullyAuthenticatedUser((String)"bartender");
            this.checkApiCall("samePrefix", null, this.getPaging(0, 100), 200, expectedSites, searchResults);
        }
        catch (Throwable throwable) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
            this.setRequestContext(null, "admin", "admin");
            if (publicSiteId != null) {
                this.deleteSite(publicSiteId, true, 204);
            }
            if (privateSiteId != null) {
                this.deleteSite(privateSiteId, true, 204);
            }
            this.deleteUser("bartender", null);
            throw throwable;
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
        this.setRequestContext(null, "admin", "admin");
        if (publicSiteId != null) {
            this.deleteSite(publicSiteId, true, 204);
        }
        if (privateSiteId != null) {
            this.deleteSite(privateSiteId, true, 204);
        }
        this.deleteUser("bartender", null);
    }

    @Override
    public String getScope() {
        return "public";
    }
}

