/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tasks;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.workflow.api.Tasks;
import org.alfresco.rest.workflow.api.model.Item;
import org.alfresco.rest.workflow.api.tasks.TasksRestEntityResource;

@RelationshipResource(name="items", entityResource=TasksRestEntityResource.class, title="The items attached to a task")
public class TaskItemsRelation
implements RelationshipResourceAction.ReadById<Item>,
RelationshipResourceAction.Read<Item>,
RelationshipResourceAction.Create<Item>,
RelationshipResourceAction.Delete {
    private Tasks tasks;

    public void setTasks(Tasks tasks) {
        this.tasks = tasks;
    }

    @Override
    public Item readById(String taskId, String itemId, Parameters parameters) throws RelationshipResourceNotFoundException {
        return this.tasks.getItem(taskId, itemId);
    }

    @Override
    @WebApiDescription(title="Get the attached items of a Task", description="Get a paged list of all the items")
    public CollectionWithPagingInfo<Item> readAll(String taskId, Parameters parameters) {
        return this.tasks.getItems(taskId, parameters.getPaging());
    }

    @Override
    public List<Item> create(String taskId, List<Item> entity, Parameters parameters) {
        ArrayList<Item> result = new ArrayList<Item>(entity.size());
        for (Item item : entity) {
            result.add(this.tasks.createItem(taskId, item));
        }
        return result;
    }

    @Override
    public void delete(String taskId, String itemId, Parameters parameters) {
        this.tasks.deleteItem(taskId, itemId);
    }
}

