/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NodeApiVersioningJsonParameterizedTest
extends AbstractSingleNetworkSiteTest {
    private static final String TYPE_CM_CONTENT = "cm:content";
    private static final String TYPE_CUSTOM_DOCUMENT = "custom:document";
    private static final String VERSIONING_ENABLED_TRUE = "true";
    private static final String VERSIONING_ENABLED_FALSE = "false";
    private static final String VERSIONING_ENABLED_UNSET = null;
    private static final Boolean MAJOR_VERSION_ENABLED_TRUE = true;
    private static final Boolean MAJOR_VERSION_ENABLED_FALSE = false;
    private static final Boolean MAJOR_VERSION_ENABLED_UNSET = null;
    private static final String VERSION_NOT_EXPECTED = null;
    private static final String EXPECTED_VERSION_0_1 = "0.1";
    private static final String EXPECTED_VERSION_1_0 = "1.0";
    private static final String EXPECTED_ASPECT_VERSIONABLE = "cm:versionable";
    private static final String EXPECTED_ASPECT_NONE = null;
    protected PermissionService permissionService;
    protected AuthorityService authorityService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    @Parameterized.Parameter(value=0)
    public String type;
    @Parameterized.Parameter(value=1)
    public String versioningEnabled;
    @Parameterized.Parameter(value=2)
    public Boolean majorVersion;
    @Parameterized.Parameter(value=3)
    public String expectedVersion;
    @Parameterized.Parameter(value=4)
    public String expectedAspect;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_UNSET, VERSION_NOT_EXPECTED, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_TRUE, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_FALSE, EXPECTED_VERSION_0_1, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_UNSET, VERSION_NOT_EXPECTED, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_TRUE, VERSION_NOT_EXPECTED, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_FALSE, VERSION_NOT_EXPECTED, EXPECTED_ASPECT_NONE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_UNSET, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_TRUE, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CM_CONTENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_FALSE, EXPECTED_VERSION_0_1, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_UNSET, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_TRUE, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_UNSET, MAJOR_VERSION_ENABLED_FALSE, EXPECTED_VERSION_0_1, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_UNSET, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_TRUE, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_TRUE, MAJOR_VERSION_ENABLED_FALSE, EXPECTED_VERSION_0_1, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_UNSET, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_TRUE, EXPECTED_VERSION_1_0, EXPECTED_ASPECT_VERSIONABLE});
        params.add(new Object[]{TYPE_CUSTOM_DOCUMENT, VERSIONING_ENABLED_FALSE, MAJOR_VERSION_ENABLED_FALSE, EXPECTED_VERSION_0_1, EXPECTED_ASPECT_VERSIONABLE});
        return params;
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService", PermissionService.class);
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService", NodeService.class);
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void versionableDocumentJsonNodeCreationTest() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        Document d1 = new Document();
        HashMap<String, String> params = new HashMap<String, String>();
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        d1.setNodeType(this.type);
        if (this.versioningEnabled != null) {
            params.put("versioningEnabled", this.versioningEnabled);
        }
        if (this.majorVersion != null) {
            params.put("majorVersion", this.majorVersion.toString());
        }
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), params, null, null, 201);
        Document documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        this.assertExpectedVersion(this.expectedVersion, documentResponse.getProperties());
        this.assertContainsAspect(this.expectedAspect, documentResponse);
    }

    private void assertExpectedVersion(String expectedVersion, Map<String, Object> documentProperties) {
        if (documentProperties != null) {
            Assert.assertEquals((Object)expectedVersion, (Object)documentProperties.get("cm:versionLabel"));
        }
    }

    private void assertContainsAspect(String expectedAspect, Document documentResponse) {
        if (expectedAspect != null) {
            Assert.assertTrue((!documentResponse.getAspectNames().isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)documentResponse.getAspectNames().contains(expectedAspect));
        }
    }
}

