/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.util.Map;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CalendarEntryDelete
extends AbstractCalendarWebScript {
    @Override
    protected boolean useJSONErrors() {
        return false;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        CalendarEntry entry = this.calendarService.getCalendarEntry(site.getShortName(), eventName);
        if (entry == null) {
            status.setCode(404);
            return null;
        }
        if (req.getParameter("date") != null && entry.getRecurrenceRule() != null) {
            this.createIgnoreEvent(req, entry);
            status.setCode(204, "Recurring entry ignored");
            return null;
        }
        this.calendarService.deleteCalendarEntry(entry);
        this.addActivityEntry("deleted", entry, site, req, json);
        status.setCode(204, "Entry deleted");
        return null;
    }
}

