/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.discovery;

import org.alfresco.rest.api.discovery.DiscoveryApiWebscript;
import org.alfresco.rest.api.impl.directurl.RestApiDirectUrlConfig;
import org.alfresco.service.cmr.repository.ContentService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DiscoveryApiWebscriptUnitTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final Boolean DISABLED = Boolean.FALSE;
    private DiscoveryApiWebscript discoveryApiWebscript = (DiscoveryApiWebscript)Mockito.mock(DiscoveryApiWebscript.class);
    private RestApiDirectUrlConfig restApiDirectUrlConfig = (RestApiDirectUrlConfig)Mockito.mock(RestApiDirectUrlConfig.class);
    private ContentService contentService = (ContentService)Mockito.mock(ContentService.class);

    public void mockedAsserts(boolean restEnabled, boolean systemwideEnabled) {
        Mockito.when((Object)this.contentService.isContentDirectUrlEnabled()).thenReturn((Object)systemwideEnabled);
        Mockito.when((Object)this.restApiDirectUrlConfig.isEnabled()).thenReturn((Object)restEnabled);
        Assert.assertEquals((Object)systemwideEnabled, (Object)this.contentService.isContentDirectUrlEnabled());
        Assert.assertEquals((Object)restEnabled, (Object)this.restApiDirectUrlConfig.isEnabled());
        Mockito.when((Object)this.discoveryApiWebscript.isContentDirectUrlEnabled()).thenReturn((Object)(restEnabled && systemwideEnabled ? 1 : 0));
    }

    @Test
    public void testEnabledConfig_RestEnabledAndSystemwideEnabled() {
        this.mockedAsserts(ENABLED, ENABLED);
        Assert.assertTrue((String)"Direct Acess URLs are enabled", (boolean)this.discoveryApiWebscript.isContentDirectUrlEnabled());
    }

    @Test
    public void testDisabledConfig_RestEnabledAndSystemwideDisabled() {
        this.mockedAsserts(ENABLED, DISABLED);
        Assert.assertFalse((String)"Direct Access URLs are disabled system-wide", (boolean)this.discoveryApiWebscript.isContentDirectUrlEnabled());
    }

    @Test
    public void testDisabledConfig_RestDisabledAndSystemwideDisabled() {
        this.mockedAsserts(DISABLED, DISABLED);
        Assert.assertFalse((String)"REST API Direct Access URLs are disabled and Direct Access URLs are disabled system-wide ", (boolean)this.discoveryApiWebscript.isContentDirectUrlEnabled());
    }

    @Test
    public void testDisabledConfig_RestDisabledAndSystemwideEnabled() {
        this.mockedAsserts(DISABLED, ENABLED);
        Assert.assertFalse((String)"REST API direct access URLs are disabled", (boolean)this.discoveryApiWebscript.isContentDirectUrlEnabled());
    }
}

