/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.person;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ChangePasswordPost
extends DeclarativeWebScript {
    private static final String PARAM_NEWPW = "newpw";
    private static final String PARAM_OLDPW = "oldpw";
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String userName = req.getExtensionPath();
        Content c = req.getContent();
        if (c == null) {
            throw new WebScriptException(500, "Missing POST body.");
        }
        try {
            JSONObject json = new JSONObject(c.getContent());
            String oldPassword = null;
            boolean isAdmin = this.authorityService.hasAdminAuthority();
            if (!isAdmin || userName.equalsIgnoreCase(this.authenticationService.getCurrentUserName())) {
                if (!json.has(PARAM_OLDPW) || json.getString(PARAM_OLDPW).length() == 0) {
                    throw new WebScriptException(400, "Old password 'oldpw' is a required POST parameter.");
                }
                oldPassword = json.getString(PARAM_OLDPW);
            }
            if (!json.has(PARAM_NEWPW) || json.getString(PARAM_NEWPW).length() == 0) {
                throw new WebScriptException(400, "New password 'newpw' is a required POST parameter.");
            }
            String newPassword = json.getString(PARAM_NEWPW);
            if (!isAdmin || userName.equalsIgnoreCase(this.authenticationService.getCurrentUserName())) {
                this.authenticationService.updateAuthentication(userName, oldPassword.toCharArray(), newPassword.toCharArray());
            } else {
                this.authenticationService.setAuthentication(userName, newPassword.toCharArray());
            }
        }
        catch (AuthenticationException err) {
            throw new WebScriptException(401, "Do not have appropriate auth or wrong auth details provided.");
        }
        catch (JSONException jErr) {
            throw new WebScriptException(500, "Unable to parse JSON POST body: " + jErr.getMessage());
        }
        catch (IOException ioErr) {
            throw new WebScriptException(500, "Unable to retrieve POST body: " + ioErr.getMessage());
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("success", Boolean.TRUE);
        return model;
    }
}

