/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;

@EntityResource(name="categories", title="Categories")
public class CategoriesEntityResource
implements EntityResourceAction.ReadById<Category>,
EntityResourceAction.Update<Category>,
EntityResourceAction.Delete {
    private final Categories categories;

    public CategoriesEntityResource(Categories categories) {
        this.categories = categories;
    }

    @Override
    @WebApiDescription(title="Get category by its ID", description="Retrieves a category given category node id", successStatus=200)
    public Category readById(String id, Parameters parameters) throws EntityNotFoundException {
        return this.categories.getCategoryById(id, parameters);
    }

    @Override
    @WebApiDescription(title="Update category", description="Update a single category by its ID", successStatus=200)
    public Category update(String id, Category categoryModel, Parameters parameters) {
        return this.categories.updateCategoryById(id, categoryModel, parameters);
    }

    @Override
    @WebApiDescription(title="Delete category", description="Delete a category given its node ID", successStatus=204)
    public void delete(String id, Parameters parameters) {
        this.categories.deleteCategoryById(id, parameters);
    }
}

