/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ObjectStorageProps;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.rest.api.Downloads;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Download;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadsImpl
implements Downloads {
    private static Logger logger = LoggerFactory.getLogger(Downloads.class);
    private DownloadService downloadService;
    private ModuleService moduleService;
    private NodeService nodeService;
    private ContentService contentService;
    private Nodes nodes;
    private PermissionService permissionService;
    private int archiveCheckLimit;
    public static final String DEFAULT_ARCHIVE_NAME = "archive.zip";
    public static final String DEFAULT_ARCHIVE_EXTENSION = ".zip";
    public static final String[] CLOUD_CONNECTOR_MODULES = new String[]{"org_alfresco_integrations_AzureConnector", "org_alfresco_integrations_S3Connector"};

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setArchiveCheckLimit(int checkLimit) {
        this.archiveCheckLimit = checkLimit;
    }

    @Override
    public Download createDownloadNode(Download download) {
        this.checkEmptyNodeIds(download);
        this.checkDuplicateNodeId(download);
        NodeRef[] zipContentNodeRefs = this.validateAndGetNodeRefs(download);
        this.checkNodeIdsReadPermission(zipContentNodeRefs);
        this.checkArchiveStatus(zipContentNodeRefs, this.archiveCheckLimit);
        NodeRef zipNodeRef = this.downloadService.createDownload(zipContentNodeRefs, true);
        String archiveName = zipContentNodeRefs.length > 1 ? DEFAULT_ARCHIVE_NAME : String.valueOf(this.nodeService.getProperty(zipContentNodeRefs[0], ContentModel.PROP_NAME)) + DEFAULT_ARCHIVE_EXTENSION;
        this.nodeService.setProperty(zipNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)archiveName));
        Download downloadInfo = this.getStatus(zipNodeRef);
        return downloadInfo;
    }

    @Override
    public Download getDownloadStatus(String downloadNodeId) {
        NodeRef downloadNodeRef = this.nodes.validateNode(downloadNodeId);
        this.checkIsDownloadNodeType(downloadNodeRef);
        Download downloadInfo = this.getStatus(downloadNodeRef);
        return downloadInfo;
    }

    @Override
    public void cancel(String downloadNodeId) {
        NodeRef downloadNodeRef = this.nodes.validateNode(downloadNodeId);
        this.checkIsDownloadNodeType(downloadNodeRef);
        this.downloadService.cancelDownload(downloadNodeRef);
    }

    protected NodeRef[] validateAndGetNodeRefs(Download download) {
        return (NodeRef[])download.getNodeIds().stream().map(nodeRef -> this.nodes.validateNode((String)nodeRef)).toArray(NodeRef[]::new);
    }

    protected void checkNodeIdsReadPermission(NodeRef[] zipContentNodeRefs) {
        for (NodeRef nodeRef : zipContentNodeRefs) {
            if (!this.permissionService.hasReadPermission(nodeRef).equals((Object)AccessStatus.DENIED)) continue;
            throw new PermissionDeniedException();
        }
    }

    protected void checkDuplicateNodeId(Download download) {
        if (download.getNodeIds().size() != new HashSet<String>(download.getNodeIds()).size()) {
            throw new InvalidArgumentException("Cannot specify the same nodeId twice");
        }
    }

    protected void checkEmptyNodeIds(Download download) {
        if (download.getNodeIds().size() == 0) {
            throw new InvalidArgumentException("Cannot create an archive with 0 entries.");
        }
    }

    protected void checkIsDownloadNodeType(NodeRef downloadNodeRef) {
        QName nodeIdType = this.nodeService.getType(downloadNodeRef);
        if (!nodeIdType.equals((Object)DownloadModel.TYPE_DOWNLOAD)) {
            throw new InvalidArgumentException("Please specify the nodeId of a download node.");
        }
    }

    private Download getStatus(NodeRef downloadNodeRef) {
        DownloadStatus status = this.downloadService.getDownloadStatus(downloadNodeRef);
        Download downloadInfo = new Download();
        downloadInfo.setId(downloadNodeRef.getId());
        downloadInfo.setBytesAdded(status.getDone());
        downloadInfo.setFilesAdded(status.getFilesAdded());
        downloadInfo.setStatus(status.getStatus());
        downloadInfo.setTotalFiles(status.getTotalFiles());
        downloadInfo.setTotalBytes(status.getTotal());
        return downloadInfo;
    }

    protected void checkArchiveStatus(NodeRef[] nodeRefs, int checkLimit) {
        if (this.canCheckArchived()) {
            this.checkArchiveStatus(nodeRefs, checkLimit, null);
        }
    }

    private void checkArchiveStatus(NodeRef[] nodeRefs, int checkLimit, Set<NodeRef> cache) {
        if (cache == null) {
            cache = new HashSet<NodeRef>();
        }
        HashSet<NodeRef> folders = new HashSet<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            Map props;
            if (cache.size() == checkLimit) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Maximum check of %d reached for archived content. No more checks will be performed and download will still be created.", checkLimit));
                }
                return;
            }
            if (cache.contains(nodeRef)) continue;
            QName qName = this.nodeService.getType(nodeRef);
            if (qName.equals((Object)ContentModel.TYPE_FOLDER)) {
                folders.add(nodeRef);
            } else if (qName.equals((Object)ContentModel.TYPE_CONTENT) && !(props = this.contentService.getStorageProperties(nodeRef, qName)).isEmpty() && Boolean.valueOf((String)props.get(ObjectStorageProps.X_ALF_ARCHIVED.getValue())).booleanValue()) {
                throw new ArchivedIOException("One or more nodes' content is archived and not accessible.");
            }
            cache.add(nodeRef);
        }
        for (NodeRef nodeRef : folders) {
            NodeRef[] childRefs = (NodeRef[])this.nodeService.getChildAssocs(nodeRef).stream().map(childAssoc -> childAssoc.getChildRef()).toArray(NodeRef[]::new);
            this.checkArchiveStatus(childRefs, checkLimit, cache);
        }
    }

    protected boolean canCheckArchived() {
        return Arrays.stream(CLOUD_CONNECTOR_MODULES).anyMatch(m -> this.moduleService.getModule(m) != null);
    }
}

