/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.node.ratings;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.impl.node.ratings.RatingScheme;
import org.alfresco.rest.api.model.DocumentRatingSummary;
import org.alfresco.rest.api.model.NodeRating;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.sync.repo.Client;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRatingScheme
implements RatingScheme,
InitializingBean {
    private static Log logger = LogFactory.getLog(RatingScheme.class);
    protected String ratingSchemeName;
    protected String ratingSchemeId;
    protected RatingService ratingService;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected ActivityService activityService;
    protected SiteService siteService;
    protected NamedObjectRegistry<RatingScheme> nodeRatingSchemeRegistry;

    public AbstractRatingScheme(String ratingSchemeId, String ratingSchemeName) {
        this.ratingSchemeName = ratingSchemeName;
        this.ratingSchemeId = ratingSchemeId;
    }

    public String getRatingSchemeId() {
        return this.ratingSchemeId;
    }

    public String getRatingServiceName() {
        return this.ratingSchemeName;
    }

    public void setNodeRatingSchemeRegistry(NamedObjectRegistry<RatingScheme> nodeRatingSchemeRegistry) {
        this.nodeRatingSchemeRegistry = nodeRatingSchemeRegistry;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRatingService(RatingService ratingService) {
        this.ratingService = ratingService;
    }

    protected org.alfresco.service.cmr.rating.RatingScheme getRepoRatingScheme() {
        return this.ratingService.getRatingScheme(this.ratingSchemeName);
    }

    protected abstract DocumentRatingSummary getDocumentRatingSummary(NodeRef var1);

    protected abstract Object getApiRating(Float var1);

    public void afterPropertiesSet() throws Exception {
        this.nodeRatingSchemeRegistry.register(this.ratingSchemeId, (Object)this);
        this.nodeRatingSchemeRegistry.register(this.ratingSchemeName, (Object)this);
    }

    public void validateRating(Float rating) {
        org.alfresco.service.cmr.rating.RatingScheme ratingScheme = this.getRepoRatingScheme();
        Float minRating = Float.valueOf(ratingScheme.getMinRating());
        Float maxRating = Float.valueOf(ratingScheme.getMaxRating());
        if (rating.floatValue() < minRating.floatValue() || rating.floatValue() > maxRating.floatValue()) {
            throw new InvalidArgumentException("Rating is out of bounds.");
        }
    }

    @Override
    public NodeRating getNodeRating(NodeRef nodeRef) {
        Rating ratingByCurrentUser = this.ratingService.getRatingByCurrentUser(nodeRef, this.ratingSchemeName);
        Float rating = null;
        Date appliedAt = null;
        if (ratingByCurrentUser != null) {
            rating = Float.valueOf(ratingByCurrentUser.getScore());
            appliedAt = ratingByCurrentUser.getAppliedAt();
        }
        Object myRating = null;
        if (rating != null) {
            this.validateRating(rating);
            myRating = this.getApiRating(rating);
        }
        DocumentRatingSummary documentRatingSummary = this.getDocumentRatingSummary(nodeRef);
        NodeRating nodeRating = new NodeRating(this.ratingSchemeId, myRating, appliedAt, documentRatingSummary);
        return nodeRating;
    }

    private String getSiteId(final NodeRef nodeRef) {
        String siteId = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                String siteId = null;
                SiteInfo siteInfo = AbstractRatingScheme.this.siteService.getSite(nodeRef);
                if (siteInfo != null) {
                    siteId = siteInfo.getShortName();
                }
                return siteId;
            }
        });
        return siteId;
    }

    private JSONObject getActivityData(final NodeRef nodeRef, String siteId) {
        JSONObject activityData = null;
        if (siteId != null) {
            activityData = (JSONObject)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<JSONObject>(){

                public JSONObject doWork() throws Exception {
                    JSONObject activityData = new JSONObject();
                    activityData.put((Object)"title", (Object)AbstractRatingScheme.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    try {
                        StringBuilder sb = new StringBuilder("document-details?nodeRef=");
                        sb.append(URLEncoder.encode(nodeRef.toString(), "UTF-8"));
                        activityData.put((Object)"page", (Object)sb.toString());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn((Object)"Unable to urlencode page for create nodeRating activity");
                    }
                    return activityData;
                }
            });
        }
        return activityData;
    }

    protected void postActivity(NodeRef nodeRef, String activityType) {
        String siteId = this.getSiteId(nodeRef);
        JSONObject activityData = this.getActivityData(nodeRef, siteId);
        if (activityData != null) {
            this.activityService.postActivity(activityType, siteId, "nodeRatings", activityData.toString(), Client.asType((Client.ClientType)Client.ClientType.restapi));
        }
    }
}

