/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsServiceImpl;
import org.alfresco.rest.api.SizeDetails;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.WebApiParameters;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="size-details", entityResource=NodesEntityResource.class, title="Node Size Details")
public class NodeSizeDetailsRelation
implements RelationshipResourceAction.ReadById<NodeSizeDetailsServiceImpl.NodeSizeDetails>,
RelationshipResourceAction.Create<NodeSizeDetailsServiceImpl.NodeSizeDetails>,
InitializingBean {
    private SizeDetails sizeDetails;

    public void setSizeDetails(SizeDetails sizeDetails) {
        this.sizeDetails = sizeDetails;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sizeDetails", (Object)this.sizeDetails);
    }

    @Override
    @WebApiDescription(title="Create node-size details request", successStatus=202)
    @WebApiParam(name="nodeSizeEntity", title="Node Size Details Request", description="Request for processing Node Size.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false)
    public List<NodeSizeDetailsServiceImpl.NodeSizeDetails> create(String nodeId, List<NodeSizeDetailsServiceImpl.NodeSizeDetails> nodeSizeEntity, Parameters parameters) {
        return List.of(this.sizeDetails.generateNodeSizeDetailsRequest(nodeId));
    }

    @Override
    @WebApiDescription(title="Get Node Size Details", description="Get the Node Size Details")
    @WebApiParameters(value={@WebApiParam(name="nodeId", title="The unique id of the Node being addressed", description="A single Node id"), @WebApiParam(name="jobId", title="Job Id to get the NodeSizeDetails", description="JobId")})
    public NodeSizeDetailsServiceImpl.NodeSizeDetails readById(String nodeId, String jobId, Parameters parameters) throws RelationshipResourceNotFoundException {
        return this.sizeDetails.getNodeSizeDetails(nodeId, jobId);
    }
}

