/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.NodeRating;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteContainer;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.json.simple.JSONArray;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeRatings
extends AbstractBaseApiTest {
    @Test
    public void testNodeRatings() throws Exception {
        NodeRating rating;
        NodeRating rating2;
        NodeRating rating3;
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network2 = networksIt.next();
        final ArrayList people = new ArrayList(3);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)network2.getId());
        RepoService.TestPerson person11 = (RepoService.TestPerson)people.get(0);
        RepoService.TestPerson person12 = (RepoService.TestPerson)people.get(1);
        RepoService.TestPerson person21 = (RepoService.TestPerson)people.get(2);
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        PublicApiClient.Nodes nodesProxy = this.publicApiClient.nodes();
        DateFormat format = PublicApiDateFormat.getDateFormat();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        String siteId = "TESTSITE" + GUID.generate();
        Site site = new SiteImpl(siteId, siteId, siteId, SiteVisibility.PRIVATE.toString());
        site = sitesProxy.createSite(site);
        SiteContainer sc = sitesProxy.getSingleSiteContainer(site.getSiteId(), "documentLibrary");
        String node1Id = this.createTextFile(sc.getId(), "Test Doc 1.txt", "Test Content").getId();
        NodeRef nodeRef1 = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, node1Id);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            Comment comment = new Comment("Test Comment", "Test Comment");
            Comment newComment = commentsProxy.createNodeComment(node1Id, comment);
            rating3 = new NodeRating("likes", true);
            nodesProxy.createNodeRating(newComment.getId(), rating3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            rating2 = new NodeRating("likes", true);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.createNodeRating(GUID.generate(), rating2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            Tag tag = new Tag("testTag");
            Tag newTag = nodesProxy.createNodeTag(node1Id, tag);
            rating3 = new NodeRating("likes", true);
            nodesProxy.createNodeRating(newTag.getId(), rating3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.createNodeRating(node1Id, new NodeRating("missingRatingScheme", 1.0));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.createNodeRating(node1Id, new NodeRating("likes", 2.0));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.createNodeRating(node1Id, new NodeRating("fiveStar", true));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.createNodeRating(node1Id, new NodeRating("fiveStar", 5));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        rating2 = new NodeRating("likes", true);
        Date time = new Date();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        NodeRating ret = nodesProxy.createNodeRating(node1Id, rating2);
        Assert.assertEquals((Object)rating2.getMyRating(), (Object)ret.getMyRating());
        Assert.assertTrue((boolean)format.parse(ret.getRatedAt()).after(time));
        Assert.assertEquals((Object)rating2.getId(), (Object)ret.getId());
        Assert.assertEquals((Object)new NodeRating.Aggregate(1, null), (Object)ret.getAggregate());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        ret = nodesProxy.createNodeRating(node1Id, rating2);
        Assert.assertEquals((Object)rating2.getMyRating(), (Object)ret.getMyRating());
        Assert.assertTrue((boolean)format.parse(ret.getRatedAt()).after(time));
        Assert.assertEquals((Object)rating2.getId(), (Object)ret.getId());
        Assert.assertEquals((Object)new NodeRating.Aggregate(2, null), (Object)ret.getAggregate());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        ret = nodesProxy.createNodeRating(node1Id, rating2);
        Assert.assertEquals((Object)rating2.getMyRating(), (Object)ret.getMyRating());
        Assert.assertTrue((boolean)format.parse(ret.getRatedAt()).after(time));
        Assert.assertEquals((Object)rating2.getId(), (Object)ret.getId());
        Assert.assertEquals((Object)new NodeRating.Aggregate(2, null), (Object)ret.getAggregate());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person21.getId()));
            nodesProxy.createNodeRating(node1Id, rating2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        List<NodeRating> expectedRatings = this.repoService.getNodeRatings(person11.getId(), network1.getId(), nodeRef1);
        int skipCount = 0;
        int maxItems = 1;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        PublicApiClient.ListResponse<NodeRating> resp = nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
        this.checkList(expectedRatings.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 1;
        maxItems = Integer.MAX_VALUE;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        resp = nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
        this.checkList(expectedRatings.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 1;
        maxItems = expectedRatings.size();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        resp = nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
        this.checkList(expectedRatings.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        expectedRatings = this.repoService.getNodeRatings(person12.getId(), network1.getId(), nodeRef1);
        skipCount = 0;
        maxItems = 1;
        paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        resp = nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
        this.checkList(expectedRatings.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 1;
        maxItems = Integer.MAX_VALUE;
        paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        resp = nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
        this.checkList(expectedRatings.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person21.getId()));
        expectedRatings = Collections.emptyList();
        try {
            skipCount = 0;
            maxItems = 1;
            paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
            nodesProxy.getNodeRatings(node1Id, this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount2 = 1;
            int maxItems2 = Integer.MAX_VALUE;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2);
            nodesProxy.getNodeRatings(GUID.generate(), this.createParams(paging2, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.repoService.generateFeed();
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        PublicApiClient.Paging paging3 = this.getPaging(0, Integer.MAX_VALUE);
        PublicApiClient.ListResponse<Activity> activities = peopleProxy.getActivities(person11.getId(), this.createParams(paging3, null));
        boolean found = false;
        for (Activity activity : activities.getList()) {
            String activityType = activity.getActivityType();
            if (!activityType.equals("org.alfresco.documentlibrary.file-liked")) continue;
            Map<String, Object> summary = activity.getSummary();
            Assert.assertNotNull(summary);
            String objectId = (String)summary.get("objectId");
            Assert.assertNotNull((Object)objectId);
            if (!node1Id.equals(objectId)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        rating2 = new NodeRating("likes", null);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person21.getId()));
            nodesProxy.removeNodeRating(node1Id, rating2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        nodesProxy.removeNodeRating(node1Id, rating2);
        List<NodeRating> ratings = this.repoService.getNodeRatings(person11.getId(), network1.getId(), nodeRef1);
        int skipCount3 = 0;
        int maxItems3 = Integer.MAX_VALUE;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        PublicApiClient.Paging paging4 = this.getPaging(skipCount3, maxItems3, ratings.size(), ratings.size());
        PublicApiClient.ListResponse<NodeRating> resp2 = nodesProxy.getNodeRatings(node1Id, this.createParams(paging4, null));
        this.checkList(ratings.subList(skipCount3, skipCount3 + paging4.getExpectedPaging().getCount()), paging4.getExpectedPaging(), resp2);
        rating2 = new NodeRating("likes", true);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        NodeRating expected = nodesProxy.createNodeRating(node1Id, rating2);
        NodeRating actual = nodesProxy.getNodeRating(node1Id, "likes");
        expected.expected(actual);
        rating2 = new NodeRating("fiveStar", 2);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        NodeRating createdRating = nodesProxy.createNodeRating(node1Id, rating2);
        NodeRating updateRating = new NodeRating(createdRating.getId(), 5);
        try {
            nodesProxy.updateNodeRating(node1Id, updateRating);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            ArrayList<NodeRating> ratings2 = new ArrayList<NodeRating>(2);
            ratings2.add(new NodeRating("likes", true));
            ratings2.add(new NodeRating("likes", false));
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.create("nodes", node1Id, "ratings", null, JSONArray.toJSONString(ratings2), "Unable to POST to multiple ratings");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
        PublicApiClient.ListResponse<NodeRating> resp3 = nodesProxy.getNodeRatings(node1Id, this.createParams(this.getPaging(0, Integer.MAX_VALUE), null));
        List<NodeRating> nodeRatings = resp3.getList();
        Assert.assertTrue((nodeRatings.size() > 0 ? 1 : 0) != 0);
        try {
            rating = new NodeRating("likes", true);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.create("nodes", node1Id, "ratings", "likes", rating.toJSON().toString(), "Unable to POST to a node rating");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.update("nodes", node1Id, "ratings", null, null, "Unable to PUT node ratings");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.remove("nodes", node1Id, "ratings", null, "Unable to DELETE node ratings");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            rating = nodeRatings.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person11.getId()));
            nodesProxy.update("nodes", node1Id, "ratings", rating.getId(), null, "Unable to PUT a node rating");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.testSkipCountLargeValue(person11, network1, nodeRef1, nodesProxy);
        }
        catch (PublicApiException e) {
            Assert.fail();
        }
    }

    public void testSkipCountLargeValue(RepoService.TestPerson person11, RepoService.TestNetwork network1, NodeRef nodeRef1, PublicApiClient.Nodes nodesProxy) throws PublicApiException {
        List<NodeRating> expectedRatings = this.repoService.getNodeRatings(person11.getId(), network1.getId(), nodeRef1);
        int skipCount = 10;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedRatings.size(), expectedRatings.size());
        nodesProxy.getNodeRatings(nodeRef1.getId(), this.createParams(paging, null));
    }

    @Override
    public String getScope() {
        return "public";
    }
}

