/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Group
extends org.alfresco.rest.api.model.Group
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = -3580248429177260831L;

    @Override
    public void expected(Object o) {
        Assert.assertTrue((String)("o is an instance of " + String.valueOf(o.getClass())), (boolean)(o instanceof Group));
        Group other = (Group)o;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
        AssertUtil.assertEquals("displayName", this.getDisplayName(), other.getDisplayName());
        AssertUtil.assertEquals("description", this.getDescription(), other.getDescription());
        AssertUtil.assertEquals("isRoot", this.getIsRoot(), other.getIsRoot());
        AssertUtil.assertEquals("hasSubgroups", this.getHasSubgroups(), other.getHasSubgroups());
        AssertUtil.assertEquals("parentIds", this.getParentIds(), other.getParentIds());
        AssertUtil.assertEquals("zones", this.getZones(), other.getZones());
    }

    public JSONObject toJSON() {
        JSONObject groupJson = new JSONObject();
        if (this.getId() != null) {
            groupJson.put((Object)"id", (Object)this.getId());
        }
        groupJson.put((Object)"displayName", (Object)this.getDisplayName());
        if (this.getDescription() != null) {
            groupJson.put((Object)"description", (Object)this.getDescription());
        }
        if (this.getIsRoot() != null) {
            groupJson.put((Object)"isRoot", (Object)this.getIsRoot());
        }
        if (this.getHasSubgroups() != null) {
            groupJson.put((Object)"hasSubgroups", (Object)this.getHasSubgroups());
        }
        if (this.getParentIds() != null) {
            groupJson.put((Object)"parentIds", new ArrayList(this.getParentIds()));
        }
        if (this.getZones() != null) {
            groupJson.put((Object)"zones", new ArrayList(this.getZones()));
        }
        return groupJson;
    }

    public static Group parseGroup(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String displayName = (String)jsonObject.get((Object)"displayName");
        String description = (String)jsonObject.get((Object)"description");
        Boolean isRoot = (Boolean)jsonObject.get((Object)"isRoot");
        Boolean hasSubgroups = (Boolean)jsonObject.get((Object)"hasSubgroups");
        List parentIds = (List)jsonObject.get((Object)"parentIds");
        List zones = (List)jsonObject.get((Object)"zones");
        Group group = new Group();
        group.setId(id);
        group.setDisplayName(displayName);
        group.setDescription(description);
        group.setIsRoot(isRoot);
        group.setHasSubgroups(hasSubgroups);
        group.setParentIds(parentIds != null ? new HashSet(parentIds) : null);
        group.setZones(zones != null ? new HashSet(zones) : null);
        return group;
    }

    public static PublicApiClient.ListResponse<Group> parseGroups(JSONObject jsonObject) {
        ArrayList<Group> groups = new ArrayList<Group>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            groups.add(Group.parseGroup(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<Group> resp = new PublicApiClient.ListResponse<Group>(paging, groups);
        return resp;
    }
}

