/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;

public class WebScriptSSOAuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter,
ActivateableBean {
    private static final Log logger = LogFactory.getLog(WebScriptSSOAuthenticationFilter.class);
    private RuntimeContainer container;
    private boolean isActive = true;

    public void setContainer(RuntimeContainer container) {
        this.container = container;
    }

    public final void setActive(boolean active) {
        this.isActive = active;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @Override
    public void doFilter(ServletContext context, ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        Match match;
        HttpServletRequest req = (HttpServletRequest)sreq;
        String requestURI = req.getRequestURI();
        String pathInfo = requestURI.substring((req.getContextPath() + req.getServletPath()).length());
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Processing request: " + requestURI + " SID:" + (req.getSession(false) != null ? req.getSession().getId() : null)));
        }
        if ((match = this.container.getRegistry().findWebScript(req.getMethod(), URLDecoder.decode((String)pathInfo))) != null && match.getWebScript() != null && Description.RequiredAuthentication.none == match.getWebScript().getDescription().getRequiredAuthentication()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Found webscript with no authentication - set NO_AUTH_REQUIRED flag.");
            }
            req.setAttribute("alfNoAuthRequired", (Object)Boolean.TRUE);
        }
        chain.doFilter(sreq, sresp);
    }

    @Override
    protected Log getLogger() {
        return logger;
    }
}

