/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractCalendarListingWebScript
extends AbstractCalendarWebScript {
    protected static final String RESULT_EVENT = "event";
    protected static final String RESULT_NAME = "name";
    protected static final String RESULT_TITLE = "title";
    protected static final String RESULT_START = "start";
    protected static final String RESULT_END = "end";

    protected static Comparator<Map<String, Object>> getEventDetailsSorter() {
        return new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> resultA, Map<String, Object> resultB) {
                DateTime sb;
                DateTimeFormatter fmtNoTz = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
                DateTimeFormatter fmtTz = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                String startA = (String)resultA.get(AbstractCalendarListingWebScript.RESULT_START);
                String startB = (String)resultB.get(AbstractCalendarListingWebScript.RESULT_START);
                startA = startA.replace("Z", "+00:00");
                startB = startB.replace("Z", "+00:00");
                DateTime sa = startA.length() > 23 ? fmtTz.parseDateTime(startA) : fmtNoTz.parseDateTime(startA);
                int cmp = sa.compareTo((ReadableInstant)(sb = startB.length() > 23 ? fmtTz.parseDateTime(startB) : fmtNoTz.parseDateTime(startB)));
                if (cmp == 0) {
                    DateTime eb;
                    String endA = (String)resultA.get(AbstractCalendarListingWebScript.RESULT_END);
                    String endB = (String)resultB.get(AbstractCalendarListingWebScript.RESULT_END);
                    DateTime ea = endA.length() > 23 ? fmtTz.parseDateTime(endA) : fmtNoTz.parseDateTime(endA);
                    cmp = ea.compareTo((ReadableInstant)(eb = endB.length() > 23 ? fmtTz.parseDateTime(endB) : fmtNoTz.parseDateTime(endB)));
                    if (cmp == 0) {
                        String nameA = (String)resultA.get(AbstractCalendarListingWebScript.RESULT_NAME);
                        String nameB = (String)resultB.get(AbstractCalendarListingWebScript.RESULT_NAME);
                        return nameA.compareTo(nameB);
                    }
                    return cmp;
                }
                return cmp;
            }
        };
    }

    protected boolean handleRecurring(CalendarEntry entry, Map<String, Object> entryResult, List<Map<String, Object>> allResults, Date from, Date until, boolean repeatingFirstOnly) {
        if (entry.getRecurrenceRule() == null) {
            return false;
        }
        if (from == null) {
            from = entry.getStart();
        }
        if (!repeatingFirstOnly && until == null) {
            Calendar c = Calendar.getInstance();
            c.setTime(from);
            c.add(5, 60);
            until = c.getTime();
        }
        long duration = entry.getEnd().getTime() - entry.getStart().getTime();
        HashSet<QName> childNodeTypeQNames = new HashSet<QName>();
        childNodeTypeQNames.add(CalendarModel.TYPE_IGNORE_EVENT);
        List ignoreEventList = this.nodeService.getChildAssocs(entry.getNodeRef(), childNodeTypeQNames);
        HashSet<Date> ignoredDates = new HashSet<Date>();
        for (ChildAssociationRef ignoreEvent : ignoreEventList) {
            NodeRef nodeRef = ignoreEvent.getChildRef();
            Date ignoredDate = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_IGNORE_EVENT_DATE);
            ignoredDates.add(ignoredDate);
        }
        ArrayList<Date> dates = CalendarRecurrenceHelper.getRecurrencesOnOrAfter((CalendarEntry)entry, (Date)from, (Date)until, (boolean)repeatingFirstOnly, ignoredDates);
        if (dates == null) {
            dates = new ArrayList<Date>();
        }
        if (entry.getStart().getTime() >= from.getTime() && (dates.size() == 0 || ((Date)dates.get(0)).getTime() != entry.getStart().getTime())) {
            dates.add(0, entry.getStart());
        }
        if (dates.size() == 0) {
            allResults.remove(entryResult);
            return false;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        childNodeTypeQNames = new HashSet();
        childNodeTypeQNames.add(CalendarModel.TYPE_UPDATED_EVENT);
        List updatedEventList = this.nodeService.getChildAssocs(entry.getNodeRef(), childNodeTypeQNames);
        HashMap<String, Object> updatedDates = new HashMap<String, Object>();
        for (ChildAssociationRef updatedEvent : updatedEventList) {
            NodeRef nodeRef = updatedEvent.getChildRef();
            Date updatedDate = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_UPDATED_EVENT_DATE);
            Date newStart = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_UPDATED_START);
            Date newEnd = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_UPDATED_END);
            String newWhere = (String)((Object)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_UPDATED_WHERE));
            String newWhat = (String)((Object)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_UPDATED_WHAT));
            updatedDates.put(fmt.format(updatedDate), new Date[]{newStart, newEnd});
            updatedDates.put(fmt.format(updatedDate).toString() + "where", newWhere);
            updatedDates.put(fmt.format(updatedDate).toString() + "what", newWhat);
        }
        Date liveEntry = (Date)dates.get(0);
        if (repeatingFirstOnly) {
            entryResult.put(RESULT_TITLE, entry.getTitle() + " (Repeating)");
            this.updateRepeating(entry, updatedDates, entryResult, duration, fmt, liveEntry);
            return true;
        }
        for (int i = 1; i < dates.size(); ++i) {
            HashMap<String, Object> newResult = new HashMap<String, Object>(entryResult);
            Date extra = (Date)dates.get(i);
            this.updateRepeating(entry, updatedDates, newResult, duration, fmt, extra);
            allResults.add(newResult);
        }
        this.updateRepeating(entry, updatedDates, entryResult, duration, fmt, liveEntry);
        return true;
    }

    private void updateRepeatingStartEnd(Date newStart, long duration, Map<String, Object> result) {
        Date newEnd = new Date(newStart.getTime() + duration);
        result.put(RESULT_START, ISO8601DateFormat.format((Date)newStart));
        result.put(RESULT_END, ISO8601DateFormat.format((Date)newEnd));
        String legacyDateFormat = "yyyy-MM-dd";
        SimpleDateFormat ldf = new SimpleDateFormat(legacyDateFormat);
        String legacyTimeFormat = "HH:mm";
        SimpleDateFormat ltf = new SimpleDateFormat(legacyTimeFormat);
        result.put("legacyDateFrom", ldf.format(newStart));
        result.put("legacyTimeFrom", ltf.format(newStart));
        result.put("legacyDateTo", ldf.format(newEnd));
        result.put("legacyTimeTo", ltf.format(newEnd));
    }

    private void updateRepeating(CalendarEntry entry, Map<String, Object> updatedDates, Map<String, Object> entryResult, long duration, SimpleDateFormat fmt, Date date) {
        if (updatedDates.keySet().contains(fmt.format(date))) {
            Date[] newValues = (Date[])updatedDates.get(fmt.format(date));
            long newDuration = newValues[1].getTime() - newValues[0].getTime();
            entryResult.put(RESULT_TITLE, (String)updatedDates.get(fmt.format(date).toString() + "what"));
            entryResult.put("where", (String)updatedDates.get(fmt.format(date).toString() + "where"));
            this.updateRepeatingStartEnd(newValues[0], newDuration, entryResult);
        } else {
            this.updateRepeatingStartEnd(date, duration, entryResult);
        }
    }
}

