/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import com.rometools.utils.Strings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.ContentPropertyName;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.SimpleCondition;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.collections.MapUtils;

@Experimental
public class RestRuleSimpleConditionModelMapper
implements RestModelMapper<SimpleCondition, ActionCondition> {
    static final String CATEGORY_INVALID_MSG = "Category in condition is invalid";
    static final String PARAM_CATEGORY = "category";
    static final String PARAM_MIMETYPE = "mimetype";
    static final String FIELD_NOT_NULL = "Field in condition must not be blank";
    static final String PARAMETER_NOT_NULL = "Parameter in condition must not be blank";
    static final String COMPARATOR_NOT_NULL = "Comparator in condition must not be blank";
    static final String INVALID_COMPARATOR_VALUE = "Comparator value for condition is invalid: %s";
    private final NamespaceService namespaceService;
    private final Nodes nodes;

    public RestRuleSimpleConditionModelMapper(NamespaceService namespaceService, Nodes nodes) {
        this.namespaceService = namespaceService;
        this.nodes = nodes;
    }

    @Override
    public SimpleCondition toRestModel(ActionCondition actionCondition) {
        if (actionCondition == null || actionCondition.getActionConditionDefinitionName() == null || MapUtils.isEmpty((Map)actionCondition.getParameterValues())) {
            return null;
        }
        switch (actionCondition.getActionConditionDefinitionName()) {
            case "compare-property-value": {
                return RestRuleSimpleConditionModelMapper.createComparePropertyValueCondition(actionCondition, this.namespaceService);
            }
            case "compare-mime-type": {
                return RestRuleSimpleConditionModelMapper.createCompareMimeTypeCondition(actionCondition);
            }
            case "has-aspect": {
                return RestRuleSimpleConditionModelMapper.createHasAspectCondition(actionCondition, this.namespaceService);
            }
            case "has-tag": {
                return RestRuleSimpleConditionModelMapper.createHasTagCondition(actionCondition);
            }
            case "in-category": {
                return RestRuleSimpleConditionModelMapper.createInCategoryCondition(actionCondition);
            }
            case "is-subtype": {
                return RestRuleSimpleConditionModelMapper.createIsSubtypeCondition(actionCondition, this.namespaceService);
            }
        }
        return null;
    }

    @Override
    public ActionCondition toServiceModel(SimpleCondition restModel) {
        String conditionDefinitionId;
        String field = restModel.getField();
        this.checkStringNotBlank(field, FIELD_NOT_NULL);
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String parameter = restModel.getParameter();
        this.checkStringNotBlank(parameter, PARAMETER_NOT_NULL);
        switch (field) {
            case "aspect": {
                conditionDefinitionId = "has-aspect";
                parameterValues.put("aspect", QName.createQName((String)parameter, (NamespacePrefixResolver)this.namespaceService));
                break;
            }
            case "tag": {
                conditionDefinitionId = "has-tag";
                parameterValues.put("tag", parameter);
                break;
            }
            case "category": {
                conditionDefinitionId = "in-category";
                parameterValues.put("category-aspect", ContentModel.ASPECT_GEN_CLASSIFIABLE);
                try {
                    parameterValues.put("category-value", this.nodes.validateOrLookupNode(parameter));
                    break;
                }
                catch (EntityNotFoundException e) {
                    throw new InvalidArgumentException(CATEGORY_INVALID_MSG);
                }
            }
            case "type": {
                conditionDefinitionId = "is-subtype";
                parameterValues.put("type", QName.createQName((String)parameter, (NamespacePrefixResolver)this.namespaceService));
                break;
            }
            case "mimetype": {
                conditionDefinitionId = "compare-mime-type";
                parameterValues.put("property", ContentModel.TYPE_CONTENT);
                parameterValues.put("value", parameter);
                break;
            }
            default: {
                conditionDefinitionId = "compare-property-value";
                try {
                    ContentPropertyName.valueOf((String)field.toUpperCase());
                    parameterValues.put("content-property", field.toUpperCase());
                    parameterValues.put("property", ContentModel.TYPE_CONTENT);
                }
                catch (IllegalArgumentException ignore) {
                    parameterValues.put("property", QName.createQName((String)field, (NamespacePrefixResolver)this.namespaceService));
                }
                this.checkStringNotBlank(restModel.getComparator(), COMPARATOR_NOT_NULL);
                parameterValues.put("operation", this.getComparatorValue(restModel.getComparator()));
                parameterValues.put("value", parameter);
            }
        }
        return new ActionConditionImpl(UUID.randomUUID().toString(), conditionDefinitionId, parameterValues);
    }

    private String getComparatorValue(String comparator) {
        try {
            return ComparePropertyValueOperation.valueOf((String)comparator.toUpperCase()).toString();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(String.format(INVALID_COMPARATOR_VALUE, comparator));
        }
    }

    private void checkStringNotBlank(String string, String message) {
        if (Strings.isBlank((String)string)) {
            throw new InvalidArgumentException(message);
        }
    }

    private static SimpleCondition createComparePropertyValueCondition(ActionCondition actionCondition, NamespaceService namespaceService) {
        SimpleCondition.Builder builder = SimpleCondition.builder();
        if (actionCondition.getParameterValues().get("content-property") != null) {
            builder.field(((Serializable)actionCondition.getParameterValues().get("content-property")).toString().toLowerCase());
        } else {
            builder.field(((QName)actionCondition.getParameterValues().get("property")).toPrefixString((NamespacePrefixResolver)namespaceService));
        }
        return builder.comparator(((Serializable)actionCondition.getParameterValues().get("operation")).toString().toLowerCase()).parameter(((Serializable)actionCondition.getParameterValues().get("value")).toString()).create();
    }

    private static SimpleCondition createCompareMimeTypeCondition(ActionCondition actionCondition) {
        return SimpleCondition.builder().field(PARAM_MIMETYPE).comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(((Serializable)actionCondition.getParameterValues().get("value")).toString()).create();
    }

    private static SimpleCondition createHasAspectCondition(ActionCondition actionCondition, NamespaceService namespaceService) {
        return SimpleCondition.builder().field("aspect").comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(((QName)actionCondition.getParameterValues().get("aspect")).toPrefixString((NamespacePrefixResolver)namespaceService)).create();
    }

    private static SimpleCondition createHasTagCondition(ActionCondition actionCondition) {
        return SimpleCondition.builder().field("tag").comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(((Serializable)actionCondition.getParameterValues().get("tag")).toString()).create();
    }

    private static SimpleCondition createInCategoryCondition(ActionCondition actionCondition) {
        return SimpleCondition.builder().field(PARAM_CATEGORY).comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(((NodeRef)actionCondition.getParameterValues().get("category-value")).getId()).create();
    }

    private static SimpleCondition createIsSubtypeCondition(ActionCondition actionCondition, NamespaceService namespaceService) {
        return SimpleCondition.builder().field("type").comparator(ComparePropertyValueOperation.EQUALS.toString().toLowerCase()).parameter(((QName)actionCondition.getParameterValues().get("type")).toPrefixString((NamespacePrefixResolver)namespaceService)).create();
    }
}

