/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.validator.actions;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.actions.ActionValidator;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.ActionParameterConstraint;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.util.Strings;

@Experimental
public class ActionParameterDefinitionValidator
implements ActionValidator {
    static final String INVALID_PARAMETER_VALUE = "Action parameter: %s has invalid value (%s). Look up possible values for constraint name %s";
    static final String MISSING_PARAMETER = "Missing action's mandatory parameter: %s";
    static final String MUST_NOT_CONTAIN_PARAMETER = "Action of definition id: %s must not contain parameter of name: %s";
    static final String PARAMS_SHOULD_NOT_BE_EMPTY = "Action parameters should not be null or empty for this action. See Action Definition for action of: %s";
    static final String INVALID_ACTION_DEFINITION = "Invalid rule action definition requested %s";
    static final String EMPTY_ACTION_DEFINITION = "Empty/null rule action definition id";
    private final Actions actions;

    public ActionParameterDefinitionValidator(Actions actions) {
        this.actions = actions;
    }

    @Override
    public void validate(Action action) {
        ActionDefinition actionDefinition;
        String actionDefinitionId = action.getActionDefinitionId();
        if (Strings.isBlank((String)actionDefinitionId)) {
            throw new InvalidArgumentException(EMPTY_ACTION_DEFINITION);
        }
        try {
            actionDefinition = this.actions.getRuleActionDefinitionById(actionDefinitionId);
        }
        catch (NotFoundException e) {
            throw new InvalidArgumentException(String.format(INVALID_ACTION_DEFINITION, actionDefinitionId));
        }
        this.validateParametersSize(action.getParams(), actionDefinition);
        Map<String, Serializable> params = action.getParams();
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((key, value) -> this.checkParameterShouldExist((String)key, actionDefinition));
            this.getParameterDefinitions(actionDefinition).forEach(p -> this.validateParameterDefinitions((ActionDefinition.ParameterDefinition)p, params));
        }
    }

    @Override
    public List<String> getActionDefinitionIds() {
        return List.of("all");
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    private void validateParametersSize(Map<String, Serializable> params, ActionDefinition actionDefinition) {
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = this.getParameterDefinitions(actionDefinition);
        if (CollectionUtils.isNotEmpty((Collection)parameterDefinitions.stream().filter(ActionDefinition.ParameterDefinition::isMandatory).collect(Collectors.toList())) && MapUtils.isEmpty(params)) {
            throw new InvalidArgumentException(String.format(PARAMS_SHOULD_NOT_BE_EMPTY, actionDefinition.getName()));
        }
    }

    private List<ActionDefinition.ParameterDefinition> getParameterDefinitions(ActionDefinition actionDefinition) {
        return actionDefinition.getParameterDefinitions() == null ? Collections.emptyList() : actionDefinition.getParameterDefinitions();
    }

    private void validateParameterDefinitions(ActionDefinition.ParameterDefinition parameterDefinition, Map<String, Serializable> params) {
        Serializable parameterValue = params.get(parameterDefinition.getName());
        if (parameterDefinition.isMandatory() && parameterValue == null) {
            throw new InvalidArgumentException(String.format(MISSING_PARAMETER, parameterDefinition.getName()));
        }
        if (parameterDefinition.getParameterConstraintName() != null) {
            ActionParameterConstraint actionConstraint = this.actions.getActionConstraint(parameterDefinition.getParameterConstraintName());
            if (parameterValue != null && actionConstraint.getConstraintValues().stream().noneMatch(constraintData -> constraintData.getValue().equals(Objects.toString(parameterValue, null)))) {
                throw new InvalidArgumentException(String.format(INVALID_PARAMETER_VALUE, parameterDefinition.getName(), parameterValue, actionConstraint.getConstraintName()));
            }
        }
    }

    private void checkParameterShouldExist(String parameterName, ActionDefinition actionDefinition) {
        if (this.getParameterDefinitions(actionDefinition).stream().noneMatch(pd -> parameterName.equals(pd.getName()))) {
            throw new InvalidArgumentException(String.format(MUST_NOT_CONTAIN_PARAMETER, actionDefinition.getName(), parameterName));
        }
    }
}

