/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.rest.api.Rules;
import org.alfresco.rest.api.rules.NodeRulesRelation;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tests.core.ParamsExtender;
import org.alfresco.service.Experimental;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class NodeRulesRelationTest
extends TestCase {
    private static final String FOLDER_NODE_ID = "dummy-node-id";
    private static final String RULE_SET_ID = "dummy-rule-set-id";
    private static final String RULE_ID = "dummy-rule-id";
    private static final List<String> INCLUDE = List.of("include-field");
    private static final Paging PAGING = Paging.DEFAULT;
    @Mock
    private Rules rulesMock;
    @InjectMocks
    private NodeRulesRelation nodeRulesRelation;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)((Object)this));
    }

    @Test
    public void testReadAll() {
        Params parameters = ParamsExtender.valueOf(PAGING, FOLDER_NODE_ID, RULE_SET_ID, null, INCLUDE);
        this.nodeRulesRelation.readAll(FOLDER_NODE_ID, (Parameters)parameters);
        ((Rules)BDDMockito.then((Object)this.rulesMock).should()).getRules(FOLDER_NODE_ID, RULE_SET_ID, INCLUDE, PAGING);
        BDDMockito.then((Object)this.rulesMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testReadById() {
        Params parameters = ParamsExtender.valueOf(null, FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE);
        this.nodeRulesRelation.readById(FOLDER_NODE_ID, RULE_SET_ID, (Parameters)parameters);
        ((Rules)BDDMockito.then((Object)this.rulesMock).should()).getRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE);
        BDDMockito.then((Object)this.rulesMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testDeleteById() {
        Params parameters = ParamsExtender.valueOf(null, FOLDER_NODE_ID, RULE_SET_ID, RULE_ID, INCLUDE);
        this.nodeRulesRelation.delete(FOLDER_NODE_ID, RULE_SET_ID, (Parameters)parameters);
        ((Rules)BDDMockito.then((Object)this.rulesMock).should()).deleteRuleById(FOLDER_NODE_ID, RULE_SET_ID, RULE_ID);
        BDDMockito.then((Object)this.rulesMock).shouldHaveNoMoreInteractions();
    }
}

