/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelConstraint;
import org.alfresco.rest.api.model.CustomModelNamedValue;
import org.alfresco.rest.api.model.CustomModelProperty;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.BaseCustomModelApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestCustomProperty
extends BaseCustomModelApiTest {
    @Test
    public void testCreateProperties() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        CustomAspect aspect = this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        CustomAspect payload = new CustomAspect();
        String aspectPropName = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        aspectProp.setMultiValued(true);
        aspectProp.setIndexed(true);
        aspectProp.setFacetable(Facetable.TRUE);
        aspectProp.setIndexTokenisationMode(IndexTokenisationMode.BOTH);
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        payload.setProperties(props);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(payload), "?select=props", 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(payload), "?select=props", 400);
        payload.setName(aspectName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(payload), "?select=props", 200);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/aspects", aspect.getName(), 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        CustomModelProperty customModelProperty = (CustomModelProperty)returnedAspect.getProperties().get(0);
        Assert.assertEquals((Object)aspectPropName, (Object)customModelProperty.getName());
        Assert.assertEquals((Object)"property title", (Object)customModelProperty.getTitle());
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + aspectPropName), (Object)customModelProperty.getPrefixedName());
        Assert.assertEquals((String)"Default data type is 'd:text'.", (Object)"d:text", (Object)customModelProperty.getDataType());
        Assert.assertNull((Object)customModelProperty.getDescription());
        Assert.assertTrue((boolean)customModelProperty.isMultiValued());
        Assert.assertFalse((boolean)customModelProperty.isMandatory());
        Assert.assertFalse((boolean)customModelProperty.isMandatoryEnforced());
        Assert.assertNull((Object)customModelProperty.getDefaultValue());
        Assert.assertTrue((boolean)customModelProperty.isIndexed());
        Assert.assertEquals((Object)Facetable.TRUE, (Object)customModelProperty.getFacetable());
        Assert.assertEquals((Object)IndexTokenisationMode.BOTH, (Object)customModelProperty.getIndexTokenisationMode());
        aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("new property title");
        props = new ArrayList(1);
        props.add(aspectProp);
        payload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(payload), "?select=props", 409);
        String typeName = "testType1" + System.currentTimeMillis();
        CustomType type = this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", "test type1 Desc", "cm:content");
        payload = new CustomType();
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property title");
        typeProp.setDataType("d:int");
        typeProp.setIndexed(false);
        typeProp.setFacetable(Facetable.FALSE);
        typeProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        props = new ArrayList(1);
        props.add(typeProp);
        payload.setProperties(props);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 400);
        payload.setName(typeName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 200);
        response = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        customModelProperty = (CustomModelProperty)returnedType.getProperties().get(0);
        Assert.assertEquals((Object)typePropName, (Object)customModelProperty.getName());
        Assert.assertEquals((Object)"property title", (Object)customModelProperty.getTitle());
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + typePropName), (Object)customModelProperty.getPrefixedName());
        Assert.assertEquals((Object)"d:int", (Object)customModelProperty.getDataType());
        Assert.assertNull((Object)customModelProperty.getDescription());
        Assert.assertFalse((boolean)customModelProperty.isMultiValued());
        Assert.assertFalse((boolean)customModelProperty.isMandatory());
        Assert.assertFalse((boolean)customModelProperty.isMandatoryEnforced());
        Assert.assertNull((Object)customModelProperty.getDefaultValue());
        Assert.assertFalse((boolean)customModelProperty.isIndexed());
        Assert.assertEquals((Object)Facetable.FALSE, (Object)customModelProperty.getFacetable());
        Assert.assertEquals((Object)IndexTokenisationMode.FALSE, (Object)customModelProperty.getIndexTokenisationMode());
        response = this.getSingle("cmm/" + modelName + "/types", type.getName() + "?select=allProps", 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)3L, (long)returnedType.getProperties().size());
        Assert.assertNotNull((Object)this.getProperty(returnedType.getProperties(), "content"));
        Assert.assertNotNull((Object)this.getProperty(returnedType.getProperties(), "name"));
        payload = new CustomType();
        payload.setName(typeName);
        String typePropName2 = "testType1Prop2" + System.currentTimeMillis();
        typeProp = new CustomModelProperty();
        typeProp.setName(typePropName2);
        typeProp.setTitle("property2 title");
        typeProp.setDescription("property2 desciption");
        typeProp.setDataType("d:int");
        typeProp.setDefaultValue("0");
        typeProp.setMultiValued(false);
        typeProp.setMandatory(true);
        typeProp.setMandatoryEnforced(true);
        props = new ArrayList(1);
        props.add(typeProp);
        payload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 200);
        response = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)2L, (long)returnedType.getProperties().size());
        customModelProperty = this.getProperty(returnedType.getProperties(), typePropName2);
        Assert.assertNotNull((Object)customModelProperty);
        Assert.assertEquals((Object)typePropName2, (Object)customModelProperty.getName());
        Assert.assertEquals((Object)"property2 title", (Object)customModelProperty.getTitle());
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + typePropName2), (Object)customModelProperty.getPrefixedName());
        Assert.assertEquals((Object)"d:int", (Object)customModelProperty.getDataType());
        Assert.assertEquals((Object)"property2 desciption", (Object)customModelProperty.getDescription());
        Assert.assertFalse((boolean)customModelProperty.isMultiValued());
        Assert.assertTrue((boolean)customModelProperty.isMandatory());
        Assert.assertTrue((boolean)customModelProperty.isMandatoryEnforced());
        Assert.assertEquals((Object)"0", (Object)customModelProperty.getDefaultValue());
        typeProp = new CustomModelProperty();
        typeProp.setName(typePropName2);
        typeProp.setTitle("new property title");
        typeProp.setDataType("d:text");
        props = new ArrayList(1);
        props.add(typeProp);
        payload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 409);
    }

    @Test
    public void testDeleteProperty() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelDeleteProp" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropNameOne = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectPropOne = new CustomModelProperty();
        aspectPropOne.setName(aspectPropNameOne);
        aspectPropOne.setTitle("aspect property one title");
        aspectPropOne.setMultiValued(true);
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectPropOne);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 200);
        aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropNameTwo = "testAspect1Prop2" + System.currentTimeMillis();
        CustomModelProperty aspectPropTwo = new CustomModelProperty();
        aspectPropTwo.setName(aspectPropNameTwo);
        aspectPropTwo.setTitle("aspect property two title");
        aspectPropTwo.setMandatory(true);
        aspectPropTwo.setDataType("d:int");
        aspectPropTwo.setDefaultValue("1");
        props = new ArrayList(1);
        props.add(aspectPropTwo);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 200);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)2L, (long)returnedAspect.getProperties().size());
        String typeName = "testType1" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", null, "cm:content");
        CustomType typePayload = new CustomType();
        typePayload.setName(typeName);
        String typePropNameOne = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typePropOne = new CustomModelProperty();
        typePropOne.setName(typePropNameOne);
        typePropOne.setTitle("type property one title");
        props = new ArrayList(1);
        props.add(typePropOne);
        typePayload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 200);
        typePayload = new CustomType();
        typePayload.setName(typeName);
        CustomModelConstraint inlineMinMaxConstraint = new CustomModelConstraint();
        inlineMinMaxConstraint.setType("MINMAX");
        inlineMinMaxConstraint.setTitle("test MINMAX title");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        inlineMinMaxConstraint.setParameters(parameters);
        String typePropNameTwo = "testType1Prop2" + System.currentTimeMillis();
        CustomModelProperty typePropTwo = new CustomModelProperty();
        typePropTwo.setName(typePropNameTwo);
        typePropTwo.setTitle("type property two title");
        typePropTwo.setDataType("d:int");
        typePropTwo.setConstraints(Arrays.asList(inlineMinMaxConstraint));
        props = new ArrayList(1);
        props.add(typePropTwo);
        typePayload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)2L, (long)returnedType.getProperties().size());
        String deletePropOneAspectQS = this.getPropDeleteUpdateQS(aspectPropNameOne, true);
        this.put("cmm/" + modelName + "/aspects", aspectName, null, deletePropOneAspectQS, 400);
        CustomAspect deletePropAspectPayload = new CustomAspect();
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload), deletePropOneAspectQS, 400);
        this.setRequestContext(this.nonAdminUserName);
        deletePropAspectPayload.setName(aspectName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload), deletePropOneAspectQS, 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload), deletePropOneAspectQS, 200);
        response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        Assert.assertFalse((String)"Property one should have been deleted.", (boolean)aspectPropNameOne.equals(((CustomModelProperty)returnedAspect.getProperties().get(0)).getName()));
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload), deletePropOneAspectQS, 404);
        String deletePropTwoTypeQS = this.getPropDeleteUpdateQS(typePropNameTwo, true);
        this.put("cmm/" + modelName + "/types", typeName, null, deletePropTwoTypeQS, 400);
        CustomType deletePropTypePayload = new CustomType();
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload), deletePropTwoTypeQS, 400);
        this.setRequestContext(this.nonAdminUserName);
        deletePropTypePayload.setName(typeName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload), deletePropTwoTypeQS, 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload), deletePropTwoTypeQS, 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        Assert.assertFalse((String)"Property two should have been deleted.", (boolean)typePropNameTwo.equals(((CustomModelProperty)returnedType.getProperties().get(0)).getName()));
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload), deletePropTwoTypeQS, 404);
        CustomModel statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        this.setRequestContext(this.customModelAdmin);
        String deletePropTwoAspectQS = this.getPropDeleteUpdateQS(aspectPropNameTwo, true);
        CustomAspect deletePropAspectPayload2 = new CustomAspect();
        deletePropAspectPayload2.setName(aspectName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload2), deletePropTwoAspectQS, 200);
        response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((String)"Property two should have been deleted.", (long)0L, (long)returnedAspect.getProperties().size());
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(deletePropAspectPayload2), deletePropTwoAspectQS, 404);
        String deletePropOneTypeQS = this.getPropDeleteUpdateQS(typePropNameOne, true);
        CustomType deletePropTypePayload2 = new CustomType();
        deletePropTypePayload2.setName(typeName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload2), deletePropOneTypeQS, 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((String)"Property one should have been deleted.", (long)0L, (long)returnedType.getProperties().size());
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(deletePropTypePayload2), deletePropOneTypeQS, 404);
    }

    @Test
    public void testUpdateProperty() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelUpdateProp" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspect1Prop" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("aspect property title");
        aspectProp.setMultiValued(true);
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 200);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        String typeName = "testType1" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "test type1 title", null, "cm:content");
        CustomType typePayload = new CustomType();
        typePayload.setName(typeName);
        CustomModelConstraint inlineMinMaxConstraint = new CustomModelConstraint();
        inlineMinMaxConstraint.setType("MINMAX");
        inlineMinMaxConstraint.setTitle("test MINMAX title");
        ArrayList<CustomModelNamedValue> parameters = new ArrayList<CustomModelNamedValue>(2);
        parameters.add(this.buildNamedValue("maxValue", "100.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "0.0", new String[0]));
        inlineMinMaxConstraint.setParameters(parameters);
        String typePropName = "testType1Prop" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setDataType("d:int");
        typeProp.setTitle("type property title");
        typeProp.setDefaultValue("0");
        typeProp.setConstraints(Arrays.asList(inlineMinMaxConstraint));
        props = new ArrayList(1);
        props.add(typeProp);
        typePayload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), "?select=props", 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        String updatePropOneAspectQS = this.getPropDeleteUpdateQS(aspectPropName, false);
        this.put("cmm/" + modelName + "/aspects", aspectName, null, updatePropOneAspectQS, 400);
        CustomAspect updatePropAspectPayload = new CustomAspect();
        CustomModelProperty propertyAspect = new CustomModelProperty();
        propertyAspect.setTitle("new Title");
        propertyAspect.setDescription("new Desc");
        propertyAspect.setDataType("d:int");
        propertyAspect.setMultiValued(false);
        propertyAspect.setMandatory(true);
        propertyAspect.setDefaultValue("10");
        ArrayList<CustomModelProperty> modifiedProp = new ArrayList<CustomModelProperty>(1);
        modifiedProp.add(propertyAspect);
        updatePropAspectPayload.setProperties(modifiedProp);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(updatePropAspectPayload), updatePropOneAspectQS, 400);
        updatePropAspectPayload.setName(aspectName + System.currentTimeMillis());
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(updatePropAspectPayload), updatePropOneAspectQS, 404);
        updatePropAspectPayload.setName(aspectName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(updatePropAspectPayload), updatePropOneAspectQS, 400);
        propertyAspect.setName(aspectPropName);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(updatePropAspectPayload), updatePropOneAspectQS, 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(updatePropAspectPayload), updatePropOneAspectQS, 200);
        response = this.getSingle("cmm/" + modelName + "/aspects", aspectName, 200);
        returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        CustomModelProperty modifiedAspectProperty = (CustomModelProperty)returnedAspect.getProperties().get(0);
        this.compareCustomModelProperties(propertyAspect, modifiedAspectProperty, "prefixedName", "indexTokenisationMode");
        CustomModel statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        String updatePropTwoTypeQS = this.getPropDeleteUpdateQS(typePropName, false);
        CustomType updatePropTypePayload = new CustomType();
        updatePropTypePayload.setName(typeName);
        CustomModelProperty propertyType = new CustomModelProperty();
        propertyType.setName(typePropName);
        propertyType.setTitle("new Title");
        propertyType.setDescription("new Desc");
        propertyType.setDataType("d:long");
        propertyType.setDefaultValue("5");
        ArrayList<CustomModelProperty> modifiedProp2 = new ArrayList<CustomModelProperty>(1);
        modifiedProp2.add(propertyType);
        updatePropTypePayload.setProperties(modifiedProp2);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 409);
        propertyType.setDataType("d:int");
        propertyType.setMultiValued(true);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 409);
        propertyType.setMultiValued(false);
        propertyType.setMandatory(true);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 409);
        propertyType.setMandatory(false);
        propertyType.setMandatoryEnforced(true);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 409);
        propertyType.setMandatoryEnforced(false);
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxValue", "120.0", new String[0]));
        parameters.add(this.buildNamedValue("minValue", "20.0", new String[0]));
        inlineMinMaxConstraint.setParameters(parameters);
        propertyType.setConstraints(Arrays.asList(inlineMinMaxConstraint));
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 409);
        propertyType.setDefaultValue("25");
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        CustomModelProperty modifiedTypeProperty = (CustomModelProperty)returnedType.getProperties().get(0);
        Assert.assertEquals((Object)"new Title", (Object)modifiedTypeProperty.getTitle());
        Assert.assertEquals((Object)"new Desc", (Object)modifiedTypeProperty.getDescription());
        Assert.assertEquals((Object)"25", (Object)modifiedTypeProperty.getDefaultValue());
        Assert.assertEquals((String)"Shouldn't be able to change the data type of the property of an active model.", (Object)"d:int", (Object)modifiedTypeProperty.getDataType());
        Assert.assertFalse((boolean)modifiedTypeProperty.isMandatory());
        Assert.assertFalse((boolean)modifiedTypeProperty.isMultiValued());
        Assert.assertFalse((boolean)modifiedTypeProperty.isMandatoryEnforced());
        Assert.assertEquals((long)1L, (long)modifiedTypeProperty.getConstraints().size());
        CustomModelConstraint modifiedConstraint = (CustomModelConstraint)modifiedTypeProperty.getConstraints().get(0);
        Assert.assertEquals((Object)"MINMAX", (Object)modifiedConstraint.getType());
        Assert.assertEquals((Object)"120.0", (Object)this.getParameterSimpleValue(modifiedConstraint.getParameters(), "maxValue"));
        Assert.assertEquals((Object)"20.0", (Object)this.getParameterSimpleValue(modifiedConstraint.getParameters(), "minValue"));
        inlineMinMaxConstraint.setType("LENGTH");
        inlineMinMaxConstraint.setTitle("test LENGTH title");
        parameters = new ArrayList(2);
        parameters.add(this.buildNamedValue("maxLength", "256", new String[0]));
        parameters.add(this.buildNamedValue("minLength", "0", new String[0]));
        inlineMinMaxConstraint.setParameters(parameters);
        propertyType.setConstraints(Arrays.asList(inlineMinMaxConstraint));
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 400);
        propertyType.setConstraints(Collections.emptyList());
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(updatePropTypePayload), updatePropTwoTypeQS, 200);
        response = this.getSingle("cmm/" + modelName + "/types", typeName, 200);
        returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        modifiedTypeProperty = (CustomModelProperty)returnedType.getProperties().get(0);
        Assert.assertEquals((long)0L, (long)modifiedTypeProperty.getConstraints().size());
    }

    @Test
    public void testValidatePropertyDefaultValue() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModelPropDefaultValue" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setName(aspectName);
        String aspectPropName = "testAspectProp" + System.currentTimeMillis();
        String updatePropAspectQS = this.getPropDeleteUpdateQS(aspectPropName, false);
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("aspect property title");
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspectPayload.setProperties(props);
        aspectProp.setDataType("d:int");
        aspectProp.setDefaultValue(" ");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("abc");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("1.0");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("1,2,3");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDataType("d:float");
        aspectProp.setDefaultValue(" ");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("abc");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("1,2,3");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 400);
        aspectProp.setDefaultValue("1.0");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), "?select=props", 200);
        aspectProp.setDefaultValue("1.0f");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 200);
        aspectProp.setDefaultValue("1.0d");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 200);
        aspectProp.setDataType("d:boolean");
        aspectProp.setDefaultValue(" ");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 400);
        aspectProp.setDefaultValue("abc");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 400);
        aspectProp.setDefaultValue("1");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 400);
        aspectProp.setDefaultValue("true");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 200);
        aspectProp.setDefaultValue("false");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), updatePropAspectQS, 200);
    }

    private String getPropDeleteUpdateQS(String propName, boolean isDelete) {
        String req = isDelete ? "&delete=" : "&update=";
        return "?select=props" + req + propName;
    }
}

