/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Group;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class SiteGroup
implements Serializable,
ExpectedComparison,
Comparable<SiteGroup> {
    private static final long serialVersionUID = 505331886661880399L;
    private String role;
    private String id;
    private Group group;
    private Collator collator = Collator.getInstance();

    public SiteGroup() {
    }

    public SiteGroup(String id, String role) {
        this.role = role;
        this.id = id;
    }

    public SiteGroup(String id, Group group, String role) {
        this.role = role;
        this.id = id;
        this.group = group;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void setCollator(Collator collator) {
        this.collator = collator;
    }

    public static SiteGroup parseSiteGroup(String siteId, JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String role = (String)jsonObject.get((Object)"role");
        JSONObject personJSON = (JSONObject)jsonObject.get((Object)"group");
        Group group = Group.parseGroup(personJSON);
        SiteGroup siteMember = new SiteGroup(id, group, role);
        return siteMember;
    }

    public static PublicApiClient.ListResponse<SiteGroup> parseGroupMemberOfSites(String siteId, JSONObject jsonObject) {
        ArrayList<SiteGroup> groups = new ArrayList<SiteGroup>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            groups.add(SiteGroup.parseSiteGroup(siteId, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<SiteGroup>(paging, groups);
    }

    public JSONObject toJSON() {
        JSONObject entry = new JSONObject();
        if (this.getId() != null) {
            entry.put((Object)"id", (Object)this.getId());
        }
        if (this.getRole() != null) {
            entry.put((Object)"role", (Object)this.getRole());
        }
        return entry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteGroup other = (SiteGroup)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof SiteGroup));
        SiteGroup other = (SiteGroup)o;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
    }

    @Override
    public int compareTo(SiteGroup o) {
        String displayName = this.group.getDisplayName();
        return this.collator.compare(displayName, o.getGroup().getDisplayName());
    }
}

