/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={LuceneTests.class})
public class DeclarativeSpreadsheetWebScriptTest
extends BaseWebScriptTest {
    private String admin;
    private static String URL = "/api/test/getcsv";
    protected static final QName[] COLUMNS = new QName[]{ContentModel.PROP_USERNAME, ContentModel.PROP_FIRSTNAME, ContentModel.PROP_LASTNAME};
    private static final String CONFIG_LOCATION = "classpath:alfresco/declarative-spreadsheet-webscript-application-context.xml";

    protected void setUp() throws Exception {
        super.setCustomContext(CONFIG_LOCATION);
        super.setUp();
        this.getServer().getApplicationContext();
        this.admin = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.admin);
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testCSVFormat() throws Exception {
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(URL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        DeclarativeSpreadsheetWebScriptTest.assertEquals((String)"The response CSV body was not correct.", (String)"User Name,First Name,Last Name\n", (String)response.getContentAsString());
        req = new TestWebScriptServer.GetRequest(URL + "?delimiter=%2C");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        DeclarativeSpreadsheetWebScriptTest.assertEquals((String)"The response CSV body was not correct.", (String)"User Name,First Name,Last Name\n", (String)response.getContentAsString());
        req = new TestWebScriptServer.GetRequest(URL + "?delimiter=%09");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        DeclarativeSpreadsheetWebScriptTest.assertEquals((String)"The response CSV body was not correct.", (String)"User Name\tFirst Name\tLast Name\n", (String)response.getContentAsString());
        req = new TestWebScriptServer.GetRequest(URL + "?delimiter=%3B");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        DeclarativeSpreadsheetWebScriptTest.assertEquals((String)"The response CSV body was not correct.", (String)"User Name;First Name;Last Name\n", (String)response.getContentAsString());
    }
}

