/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.categories.SubcategoriesRelation;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SubcategoriesRelationTest {
    private static final String PARENT_CATEGORY_ID = "parent-category-node-id";
    private static final String CATEGORY_ID = "category-node-id";
    private static final String CATEGORY_NAME = "categoryName";
    private static final String SUBCATEGORY_NAME_PREFIX = "childCategoryName";
    @Mock
    private Categories categoriesMock;
    @Mock
    private Parameters parametersMock;
    @InjectMocks
    private SubcategoriesRelation objectUnderTest;

    @Test
    public void testCreateSubcategory() {
        Category categoryToCreate = Category.builder().name(CATEGORY_NAME).create();
        Category category = Category.builder().name(CATEGORY_NAME).parentId(PARENT_CATEGORY_ID).hasChildren(false).id(CATEGORY_ID).create();
        List<Category> categoriesToCreate = List.of(categoryToCreate);
        BDDMockito.given((Object)this.categoriesMock.createSubcategories((String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willCallRealMethod();
        BDDMockito.given((Object)this.categoriesMock.createSubcategories((StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn(List.of(category));
        List categories = this.objectUnderTest.create(PARENT_CATEGORY_ID, categoriesToCreate, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).createSubcategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PARENT_CATEGORY_ID, categoriesToCreate, this.parametersMock);
        Assert.assertEquals(List.of(category), (Object)categories);
    }

    @Test
    public void testGetCategoryChildren() {
        List<Category> categoryChildren = this.getCategories(3);
        BDDMockito.given((Object)this.categoriesMock.getCategoryChildren((String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willCallRealMethod();
        BDDMockito.given((Object)this.categoriesMock.getCategoryChildren((StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn(categoryChildren);
        CollectionWithPagingInfo returnedChildren = this.objectUnderTest.readAll(PARENT_CATEGORY_ID, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).getCategoryChildren(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PARENT_CATEGORY_ID, this.parametersMock);
        Assert.assertEquals(categoryChildren, (Object)returnedChildren.getCollection());
    }

    private List<Category> getCategories(int count) {
        return IntStream.range(0, count).mapToObj(i -> Category.builder().name("childCategoryName-" + i).parentId(PARENT_CATEGORY_ID).hasChildren(false).id("category-node-id-" + i).create()).collect(Collectors.toList());
    }
}

