/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.rest.api.tests.client.AuthenticatedHttp;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class PublicApiHttpClient {
    private static final Log logger = LogFactory.getLog(PublicApiHttpClient.class);
    private static final String OLD_BASE_URL = "{0}://{1}:{2}{3}{4}{5}/api/";
    private static final String INDEX_URL = "{0}://{1}:{2}{3}{4}";
    private static final String BASE_URL = "{0}://{1}:{2}{3}{4}{5}/{6}/{7}/versions/{8}";
    private static final String PUBLICAPI_CMIS_SERVICE_URL = "{0}://{1}:{2}{3}{4}cmis/versions/{5}/{6}";
    private static final String PUBLICAPI_CMIS_URL = "{0}://{1}:{2}{3}{4}{5}/{6}/cmis/versions/{7}/{8}";
    private static final String PUBLICAPI_CMIS_URL_SUFFIX = "{0}/{1}/cmis/versions/{2}/{3}";
    private static final String ATOM_PUB_URL = "{0}://{1}:{2}{3}cmisatom";
    private String scheme = "http";
    private String host = "localhost";
    private int port = 8765;
    private String contextPath;
    private String servletName;
    private AuthenticatedHttp authenticatedHttp;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    protected String apiName = "alfresco";

    public PublicApiHttpClient(String host, int port, String contextPath, String servletName, AuthenticatedHttp authenticatedHttp) {
        this("http", host, port, contextPath, servletName, authenticatedHttp);
    }

    public PublicApiHttpClient(String scheme, String host, int port, String contextPath, String servletName, AuthenticatedHttp authenticatedHttp) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        if (this.contextPath != null && !this.contextPath.isEmpty() && !this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        if (this.contextPath != null && !this.contextPath.startsWith("/")) {
            this.contextPath = "/" + this.contextPath;
        }
        this.servletName = servletName;
        if (this.servletName != null && !this.servletName.isEmpty() && !this.servletName.endsWith("/")) {
            this.servletName = this.servletName + "/";
        }
        this.authenticatedHttp = authenticatedHttp;
    }

    public String getCmisUrl(String repositoryId, String operation) {
        StringBuilder url = new StringBuilder();
        if (repositoryId == null) {
            url.append(MessageFormat.format(ATOM_PUB_URL, this.scheme, this.host, String.valueOf(this.port), this.contextPath));
        } else {
            url.append(MessageFormat.format(ATOM_PUB_URL, this.scheme, this.host, String.valueOf(this.port), this.contextPath));
            url.append("/");
            url.append(repositoryId);
        }
        if (operation != null) {
            url.append("/");
            url.append(operation);
        }
        return url.toString();
    }

    public String getPublicApiCmisUrl(String networkId, CMISDispatcherRegistry.Binding binding, String version, String operation) {
        StringBuilder url = new StringBuilder();
        if (networkId == null) {
            url.append(MessageFormat.format(PUBLICAPI_CMIS_SERVICE_URL, this.scheme, this.host, String.valueOf(this.port), this.contextPath, this.servletName, version, binding.toString().toLowerCase()));
        } else {
            url.append(MessageFormat.format(PUBLICAPI_CMIS_URL, this.scheme, this.host, String.valueOf(this.port), this.contextPath, this.servletName, networkId, "public", version, binding.toString().toLowerCase()));
        }
        if (operation != null) {
            url.append("/");
            url.append(operation);
        }
        return url.toString();
    }

    public String getPublicApiCmisUrlSuffix(String networkId, CMISDispatcherRegistry.Binding binding, String version, String operation) {
        StringBuilder url = new StringBuilder();
        url.append(MessageFormat.format(PUBLICAPI_CMIS_URL_SUFFIX, networkId, "public", version, binding.toString().toLowerCase()));
        if (operation != null) {
            url.append("/");
            url.append(operation);
        }
        return url.toString();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void init() {
    }

    private void log(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg);
        }
    }

    protected AnnotationMetadata getAnnotationMetadata(String classname) throws IOException {
        MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(classname);
        AnnotationMetadata annotationMetaData = metadataReader.getAnnotationMetadata();
        return annotationMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse submitRequest(HttpMethod req, final RequestContext rq) throws HttpException, IOException {
        try {
            final long start = System.currentTimeMillis();
            AuthenticatedHttp.HttpRequestCallback<HttpResponse> callback = new AuthenticatedHttp.HttpRequestCallback<HttpResponse>(){

                @Override
                public HttpResponse onCallSuccess(HttpMethod method) throws Exception {
                    long end = System.currentTimeMillis();
                    HashMap<String, String> headersMap = null;
                    Header[] headers = method.getResponseHeaders();
                    if (headers != null) {
                        headersMap = new HashMap<String, String>(headers.length);
                        for (Header header : headers) {
                            headersMap.put(header.getName(), header.getValue());
                        }
                    }
                    return new HttpResponse(method, rq.getRunAsUser(), method.getResponseBody(), headersMap, end - start);
                }

                @Override
                public boolean onError(HttpMethod method, Throwable t) {
                    return false;
                }
            };
            HttpResponse response = null;
            response = rq.getPassword() != null ? this.authenticatedHttp.executeHttpMethodAuthenticated(req, rq.getRunAsUser(), rq.getPassword(), callback) : (rq.getRunAsUser() != null ? this.authenticatedHttp.executeHttpMethodAuthenticated(req, rq.getRunAsUser(), callback) : this.authenticatedHttp.executeHttpMethodUnauthenticated(req, callback));
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (req != null) {
                req.releaseConnection();
            }
        }
    }

    public HttpResponse get(RequestContext rq, String urlSuffix, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), urlSuffix, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse get(Class<?> c, RequestContext rq, Object entityId, Object relationshipEntityId, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(c, rq.getNetworkId(), entityId, relationshipEntityId, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse get(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        return this.get(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params, null);
    }

    public HttpResponse get(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params, Map<String, String> headers) throws IOException {
        return this.get(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params, headers);
    }

    public HttpResponse get(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params, Map<String, String> headers) throws IOException {
        if (headers == null) {
            headers = Collections.emptyMap();
        }
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            req.addRequestHeader(header.getKey(), header.getValue());
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse get(RequestContext rq, String scope, String password, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        return this.get(rq, scope, 1, password, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
    }

    public HttpResponse get(RequestContext rq, String scope, int version, String password, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse get(String urlSuffix, RequestContext rq, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(urlSuffix, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse getWithPassword(String urlSuffix, RequestContext rq, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(urlSuffix, params);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse post(Class<?> c, RequestContext rq, Object entityId, Object relationshipEntityId, String body) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(c, rq.getNetworkId(), entityId, relationshipEntityId, null);
        String url = endpoint.getUrl();
        PostMethod req = new PostMethod(url.toString());
        if (body != null) {
            StringRequestEntity requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse post(RequestContext rq, String urlSuffix, String body) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), urlSuffix, null);
        String url = endpoint.getUrl();
        PostMethod req = new PostMethod(url.toString());
        if (body != null) {
            StringRequestEntity requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse post(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, String body) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        PostMethod req = new PostMethod(url.toString());
        if (body != null) {
            StringRequestEntity requestEntity = null;
            if (cmisBinding.equals((Object)CMISDispatcherRegistry.Binding.atom)) {
                requestEntity = new StringRequestEntity(body, "text/xml", "UTF-8");
            } else if (cmisBinding.equals((Object)CMISDispatcherRegistry.Binding.browser)) {
                requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            }
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse put(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, String body) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        PutMethod req = new PutMethod(url.toString());
        if (body != null) {
            StringRequestEntity requestEntity = null;
            if (cmisBinding.equals((Object)CMISDispatcherRegistry.Binding.atom)) {
                requestEntity = new StringRequestEntity(body, "text/xml", "UTF-8");
            } else if (cmisBinding.equals((Object)CMISDispatcherRegistry.Binding.browser)) {
                requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            }
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse get(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, parameters);
        String url = endpoint.getUrl();
        GetMethod req = new GetMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse delete(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        DeleteMethod req = new DeleteMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse head(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        HeadMethod req = new HeadMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse options(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        OptionsMethod req = new OptionsMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse trace(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        TraceMethod req = new TraceMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse patch(RequestContext rq, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), cmisBinding, version, cmisOperation, null);
        String url = endpoint.getUrl();
        BaseWebScriptTest.PatchMethod req = new BaseWebScriptTest.PatchMethod(url.toString());
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse post(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body) throws IOException {
        return this.post(rq, scope, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, "application/json");
    }

    public HttpResponse post(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, Map<String, String> params) throws IOException {
        return this.post(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, "application/json", params);
    }

    public HttpResponse post(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, String contentType) throws IOException {
        return this.post(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, contentType);
    }

    public HttpResponse post(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, String contentType) throws IOException {
        return this.post(rq, scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, contentType, null);
    }

    public HttpResponse post(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, String contentType, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        PostMethod req = new PostMethod(url.toString());
        if (body != null) {
            if (contentType == null || contentType.isEmpty()) {
                contentType = "application/json";
            }
            StringRequestEntity requestEntity = new StringRequestEntity(body, contentType, "UTF-8");
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse post(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, byte[] body, String contentType) throws IOException {
        return this.post(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, contentType);
    }

    public HttpResponse post(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, byte[] body, String contentType) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, null);
        String url = endpoint.getUrl();
        PostMethod req = new PostMethod(url.toString());
        if (body != null) {
            if (contentType == null || contentType.isEmpty()) {
                contentType = "application/octet-stream";
            }
            ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(body, contentType);
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse delete(Class<?> c, RequestContext rq, Object entityId, Object relationshipEntityId) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(c, rq.getNetworkId(), entityId, relationshipEntityId, null);
        String url = endpoint.getUrl();
        DeleteMethod req = new DeleteMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse delete(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId) throws IOException {
        return this.delete(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, null);
    }

    public HttpResponse delete(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        DeleteMethod req = new DeleteMethod(url);
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse put(Class<?> c, RequestContext rq, Object entityId, Object relationshipEntityId, String body) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(c, rq.getNetworkId(), entityId, relationshipEntityId, null);
        String url = endpoint.getUrl();
        PutMethod req = new PutMethod(url);
        if (body != null) {
            StringRequestEntity requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse put(RequestContext rq, String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, Map<String, String> params) throws IOException {
        return this.put(rq, scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, params);
    }

    public HttpResponse put(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        PutMethod req = new PutMethod(url);
        if (body != null) {
            StringRequestEntity requestEntity = new StringRequestEntity(body, "application/json", "UTF-8");
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse putBinary(RequestContext rq, String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, BinaryPayload payload, Map<String, String> params) throws IOException {
        RestApiEndpoint endpoint = new RestApiEndpoint(rq.getNetworkId(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        String url = endpoint.getUrl();
        PutMethod req = new PutMethod(url);
        if (payload != null) {
            BinaryRequestEntity requestEntity = new BinaryRequestEntity(payload.getFile(), payload.getMimeType(), payload.getCharset());
            req.setRequestEntity((RequestEntity)requestEntity);
        }
        return this.submitRequest((HttpMethod)req, rq);
    }

    public HttpResponse execute(RequestBuilder requestBuilder) throws IOException {
        return this.submitRequest((HttpMethod)requestBuilder.getHttpMethod(), requestBuilder.getRequestContext());
    }

    private class RestApiEndpoint {
        private String url;

        RestApiEndpoint(String url, Map<String, String> params) throws IOException {
            StringBuilder sb = new StringBuilder(MessageFormat.format(PublicApiHttpClient.INDEX_URL, PublicApiHttpClient.this.scheme, PublicApiHttpClient.this.host, String.valueOf(PublicApiHttpClient.this.port), PublicApiHttpClient.this.contextPath, PublicApiHttpClient.this.servletName));
            if (url != null) {
                sb.append(url);
            }
            this.addParams(sb, params);
            this.url = sb.toString();
        }

        RestApiEndpoint(String tenantDomain, String url, Map<String, String> params) throws IOException {
            StringBuilder sb = new StringBuilder(MessageFormat.format(PublicApiHttpClient.OLD_BASE_URL, PublicApiHttpClient.this.scheme, PublicApiHttpClient.this.host, String.valueOf(PublicApiHttpClient.this.port), PublicApiHttpClient.this.contextPath, PublicApiHttpClient.this.servletName, tenantDomain == null ? "-default-" : tenantDomain));
            sb.append("/");
            sb.append(url);
            this.addParams(sb, params);
            this.url = sb.toString();
        }

        RestApiEndpoint(Class<?> resourceClass, String tenantDomain, Object collectionEntityId, Object relationEntityId, Map<String, String> params) throws IOException {
            StringBuilder sb = new StringBuilder();
            Api api = ResourceInspector.inspectApi(resourceClass);
            Api.SCOPE scope = api.getScope();
            int version = api.getVersion();
            String name = api.getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = PublicApiHttpClient.this.apiName;
            }
            Pair<String, String> relationshipCollectionInfo = this.getRelationCollectionInfo(resourceClass);
            sb.append(MessageFormat.format(PublicApiHttpClient.BASE_URL, PublicApiHttpClient.this.scheme, PublicApiHttpClient.this.host, String.valueOf(PublicApiHttpClient.this.port), PublicApiHttpClient.this.contextPath, PublicApiHttpClient.this.servletName, tenantDomain == null ? "-default-" : tenantDomain, scope.toString(), name, version));
            if (relationshipCollectionInfo != null) {
                String entityCollectionName = (String)relationshipCollectionInfo.getFirst();
                String relationshipCollectionName = (String)relationshipCollectionInfo.getSecond();
                String relationEntityIdString = this.encodeToString(relationEntityId);
                String collectionEntityIdString = this.encodeToString(collectionEntityId);
                sb.append('/');
                sb.append(entityCollectionName);
                sb.append('/');
                if (collectionEntityIdString != null) {
                    sb.append(collectionEntityIdString);
                    sb.append('/');
                }
                sb.append(relationshipCollectionName);
                sb.append('/');
                if (relationEntityIdString != null) {
                    sb.append(relationEntityIdString);
                    sb.append('/');
                }
            } else {
                String entityCollectionName = this.getEntityCollectionInfo(resourceClass);
                if (entityCollectionName != null) {
                    String collectionEntityIdString = this.encodeToString(collectionEntityId);
                    sb.append('/');
                    sb.append(entityCollectionName);
                    sb.append('/');
                    if (collectionEntityIdString != null) {
                        sb.append(collectionEntityIdString);
                        sb.append('/');
                    }
                } else {
                    throw new RuntimeException();
                }
            }
            this.addParams(sb, params);
            this.url = sb.toString();
        }

        RestApiEndpoint(String networkId, CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> params) throws IOException {
            StringBuilder sb = new StringBuilder();
            if (networkId == null) {
                throw new IllegalArgumentException();
            }
            sb.append(PublicApiHttpClient.this.getPublicApiCmisUrl(networkId, cmisBinding, version, cmisOperation));
            this.addParams(sb, params);
            this.url = sb.toString();
        }

        RestApiEndpoint(String tenantDomain, String scope, int version, String collectionName, Object collectionEntityId, String relationName, Object relationEntityId, Map<String, String> params) throws IOException {
            this(tenantDomain, scope, publicApiHttpClient.apiName, version, collectionName, collectionEntityId, relationName, relationEntityId, params);
        }

        RestApiEndpoint(String tenantDomain, String scope, String apiName, int version, String collectionName, Object collectionEntityId, String relationName, Object relationEntityId, Map<String, String> params) throws IOException {
            StringBuilder sb = new StringBuilder();
            if (tenantDomain == null || tenantDomain.equals("")) {
                tenantDomain = "-default-";
            }
            if (StringUtils.isEmpty((CharSequence)apiName)) {
                apiName = PublicApiHttpClient.this.apiName;
            }
            sb.append(MessageFormat.format(PublicApiHttpClient.BASE_URL, PublicApiHttpClient.this.scheme, PublicApiHttpClient.this.host, String.valueOf(PublicApiHttpClient.this.port), PublicApiHttpClient.this.contextPath, PublicApiHttpClient.this.servletName, tenantDomain, scope, apiName, version));
            if (collectionName != null) {
                sb.append('/');
                sb.append(collectionName);
                if (collectionEntityId != null) {
                    sb.append('/');
                    sb.append(collectionEntityId);
                }
            }
            if (relationName != null) {
                sb.append('/');
                sb.append(relationName);
                if (relationEntityId != null) {
                    sb.append('/');
                    sb.append(relationEntityId);
                }
            }
            this.addParams(sb, params);
            this.url = sb.toString();
        }

        RestApiEndpoint(String tenantDomain, String scope, String collectionName, Object collectionEntityId, String relationName, Object relationEntityId, Map<String, String> params) throws IOException {
            this(tenantDomain, scope, 1, collectionName, collectionEntityId, relationName, relationEntityId, params);
        }

        private void addParams(StringBuilder sb, Map<String, String> params) throws UnsupportedEncodingException {
            if (params != null && params.size() > 0) {
                sb.append("?");
                for (String paramName : params.keySet()) {
                    sb.append(URLEncoder.encode(paramName, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(params.get(paramName), "UTF-8"));
                    sb.append("&");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        }

        private String encodeToString(Object o) throws UnsupportedEncodingException {
            String ret = null;
            if (o instanceof NodeRef) {
                NodeRef nodeRef = (NodeRef)o;
                ret = o != null ? nodeRef.getId() : null;
            } else {
                ret = o != null ? o.toString() : null;
            }
            return ret;
        }

        private Pair<String, String> getRelationCollectionInfo(Class<?> resourceClass) throws IOException {
            AnnotationMetadata annotationMetaData = PublicApiHttpClient.this.getAnnotationMetadata(resourceClass.getCanonicalName());
            if (annotationMetaData.isConcrete() && annotationMetaData.isIndependent()) {
                if (annotationMetaData.getAnnotationTypes().contains(RelationshipResource.class.getCanonicalName())) {
                    Map attrs = annotationMetaData.getAnnotationAttributes(RelationshipResource.class.getName());
                    String relationshipCollectionName = (String)attrs.get("name");
                    Class entityResource = (Class)attrs.get("entityResource");
                    String entityCollectionName = this.getEntityCollectionInfo(entityResource.getCanonicalName());
                    Pair ret = new Pair((Object)entityCollectionName, (Object)relationshipCollectionName);
                    return ret;
                }
                return null;
            }
            throw new AlfrescoRuntimeException("");
        }

        private String getEntityCollectionInfo(Class<?> resourceClass) throws IOException {
            return this.getEntityCollectionInfo(resourceClass.getCanonicalName());
        }

        private String getEntityCollectionInfo(String className) throws IOException {
            AnnotationMetadata annotationMetaData = PublicApiHttpClient.this.getAnnotationMetadata(className);
            if (annotationMetaData.isConcrete() && annotationMetaData.isIndependent()) {
                if (annotationMetaData.getAnnotationTypes().contains(EntityResource.class.getCanonicalName())) {
                    Map attrs = annotationMetaData.getAnnotationAttributes(EntityResource.class.getName());
                    return (String)attrs.get("name");
                }
                return null;
            }
            throw new AlfrescoRuntimeException("");
        }

        public String getUrl() throws UnsupportedEncodingException {
            return this.url;
        }
    }

    public static class BinaryRequestEntity
    implements RequestEntity {
        private final File file;
        private final String mimeType;
        private final String charset;

        public BinaryRequestEntity(File file, String mimeType, String charset) {
            this.file = file;
            this.mimeType = mimeType;
            this.charset = charset;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream out) throws IOException {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.file));){
                int len;
                byte[] buffer = new byte[8190];
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
        }

        public long getContentLength() {
            return this.file.length();
        }

        public String getContentType() {
            if (this.charset == null) {
                return this.mimeType;
            }
            if (this.mimeType == null) {
                return null;
            }
            return this.mimeType + "; charset=" + this.charset;
        }
    }

    public static class BinaryPayload {
        private File file;
        private String mimeType;
        private String charset;

        public BinaryPayload(File file, String mimeType, String charset) {
            this.file = file;
            this.mimeType = mimeType;
            this.charset = charset;
        }

        public BinaryPayload(File file, String mimeType) {
            this(file, mimeType, null);
        }

        public BinaryPayload(File file) {
            this(file, null, null);
        }

        public File getFile() {
            return this.file;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getCharset() {
            return this.charset;
        }
    }

    public abstract class RequestBuilder<T extends HttpMethod> {
        private RequestContext requestContext;
        private String scope;
        private String apiName = "alfresco";
        private int version = 1;
        private String entityCollectionName;
        private Object entityId;
        private String relationCollectionName;
        private Object relationshipEntityId;
        private Map<String, String> params;
        private Map<String, String> headers;

        public RequestBuilder(PublicApiHttpClient this$0) {
        }

        public abstract T getHttpMethod() throws IOException;

        protected void setRequestHeaderIfAny(T methodBase) {
            if (this.headers != null) {
                for (Map.Entry<String, String> headerNameValue : this.headers.entrySet()) {
                    methodBase.addRequestHeader(headerNameValue.getKey(), headerNameValue.getValue());
                }
            }
        }

        public RequestContext getRequestContext() {
            return this.requestContext;
        }

        public RequestBuilder setRequestContext(RequestContext requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        public String getScope() {
            return this.scope;
        }

        public RequestBuilder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public String getApiName() {
            return this.apiName;
        }

        public RequestBuilder setApiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public int getVersion() {
            return this.version;
        }

        public RequestBuilder setVersion(int version) {
            this.version = version;
            return this;
        }

        public String getEntityCollectionName() {
            return this.entityCollectionName;
        }

        public RequestBuilder setEntityCollectionName(String entityCollectionName) {
            this.entityCollectionName = entityCollectionName;
            return this;
        }

        public Object getEntityId() {
            return this.entityId;
        }

        public RequestBuilder setEntityId(Object entityId) {
            this.entityId = entityId;
            return this;
        }

        public String getRelationCollectionName() {
            return this.relationCollectionName;
        }

        public RequestBuilder setRelationCollectionName(String relationCollectionName) {
            this.relationCollectionName = relationCollectionName;
            return this;
        }

        public Object getRelationshipEntityId() {
            return this.relationshipEntityId;
        }

        public RequestBuilder setRelationshipEntityId(Object relationshipEntityId) {
            this.relationshipEntityId = relationshipEntityId;
            return this;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public RequestBuilder setParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public RequestBuilder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }
    }

    public class PutRequestBuilder
    extends PostPutRequestBuilder<PutMethod> {
        private BinaryPayload binaryPayload;

        public PutRequestBuilder() {
            super(PublicApiHttpClient.this);
        }

        public BinaryPayload getBinaryPayload() {
            return this.binaryPayload;
        }

        public PutRequestBuilder setBinaryPayload(BinaryPayload binaryPayload) {
            this.binaryPayload = binaryPayload;
            return this;
        }

        @Override
        public PutMethod getHttpMethod() throws IOException {
            RestApiEndpoint endpoint = new RestApiEndpoint(this.getRequestContext().getNetworkId(), this.getScope(), this.getApiName(), this.getVersion(), this.getEntityCollectionName(), this.getEntityId(), this.getRelationCollectionName(), this.getRelationshipEntityId(), this.getParams());
            String url = endpoint.getUrl();
            PutMethod req = new PutMethod(url);
            if (this.getBodyAsString() != null) {
                StringRequestEntity requestEntity = new StringRequestEntity(this.getBodyAsString(), "application/json", "UTF-8");
                req.setRequestEntity((RequestEntity)requestEntity);
            } else if (this.binaryPayload != null) {
                BinaryRequestEntity requestEntity = new BinaryRequestEntity(this.binaryPayload.getFile(), this.binaryPayload.getMimeType(), this.binaryPayload.getCharset());
                req.setRequestEntity((RequestEntity)requestEntity);
            }
            this.setRequestHeaderIfAny(req);
            return req;
        }
    }

    public class PostRequestBuilder
    extends PostPutRequestBuilder<PostMethod> {
        public PostRequestBuilder() {
            super(PublicApiHttpClient.this);
        }

        @Override
        public PostMethod getHttpMethod() throws IOException {
            RestApiEndpoint endpoint = new RestApiEndpoint(this.getRequestContext().getNetworkId(), this.getScope(), this.getApiName(), this.getVersion(), this.getEntityCollectionName(), this.getEntityId(), this.getRelationCollectionName(), this.getRelationshipEntityId(), this.getParams());
            String url = endpoint.getUrl();
            PostMethod req = new PostMethod(url.toString());
            String contentType = this.getContentType();
            if (this.getBodyAsString() != null) {
                if (contentType == null || contentType.isEmpty()) {
                    contentType = "application/json";
                }
                StringRequestEntity requestEntity = new StringRequestEntity(this.getBodyAsString(), contentType, "UTF-8");
                req.setRequestEntity((RequestEntity)requestEntity);
            } else if (this.getBodyAsByteArray() != null) {
                if (contentType == null || contentType.isEmpty()) {
                    contentType = "application/octet-stream";
                }
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(this.getBodyAsByteArray(), contentType);
                req.setRequestEntity((RequestEntity)requestEntity);
            }
            this.setRequestHeaderIfAny(req);
            return req;
        }
    }

    public abstract class PostPutRequestBuilder<T extends HttpMethodBase>
    extends RequestBuilder<T> {
        private String bodyAsString;
        private byte[] bodyAsByteArray;
        private String contentType;

        public PostPutRequestBuilder(PublicApiHttpClient this$0) {
            super(this$0);
        }

        public String getBodyAsString() {
            return this.bodyAsString;
        }

        public PostPutRequestBuilder setBodyAsString(String bodyAsString) {
            this.bodyAsString = bodyAsString;
            return this;
        }

        public byte[] getBodyAsByteArray() {
            return this.bodyAsByteArray;
        }

        public PostPutRequestBuilder setBodyAsByteArray(byte[] bodyAsByteArray) {
            this.bodyAsByteArray = bodyAsByteArray;
            return this;
        }

        public String getContentType() {
            return this.contentType;
        }

        public PostPutRequestBuilder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }
    }

    public class DeleteRequestBuilder
    extends RequestBuilder<DeleteMethod> {
        public DeleteRequestBuilder() {
            super(PublicApiHttpClient.this);
        }

        @Override
        public DeleteMethod getHttpMethod() throws IOException {
            RestApiEndpoint endpoint = new RestApiEndpoint(this.getRequestContext().getNetworkId(), this.getScope(), this.getApiName(), this.getVersion(), this.getEntityCollectionName(), this.getEntityId(), this.getRelationCollectionName(), this.getRelationshipEntityId(), this.getParams());
            String url = endpoint.getUrl();
            DeleteMethod req = new DeleteMethod(url);
            this.setRequestHeaderIfAny(req);
            return req;
        }
    }

    public class GetRequestBuilder
    extends RequestBuilder<GetMethod> {
        private String password;

        public GetRequestBuilder() {
            super(PublicApiHttpClient.this);
        }

        public String getPassword() {
            return this.password;
        }

        public GetRequestBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        public GetMethod getHttpMethod() throws IOException {
            RestApiEndpoint endpoint = new RestApiEndpoint(this.getRequestContext().getNetworkId(), this.getScope(), this.getApiName(), this.getVersion(), this.getEntityCollectionName(), this.getEntityId(), this.getRelationCollectionName(), this.getRelationshipEntityId(), this.getParams());
            String url = endpoint.getUrl();
            GetMethod req = new GetMethod(url);
            this.setRequestHeaderIfAny(req);
            return req;
        }
    }
}

