/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public abstract class BaseRemoteStore
extends AbstractWebScript {
    public static final String TOKEN_STORE = "s";
    public static final String REQUEST_PARAM_STORE = "s";
    private static final Log logger = LogFactory.getLog(BaseRemoteStore.class);
    protected String defaultStore;
    protected MimetypeService mimetypeService;
    protected static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    protected static ThreadLocal<Transformer> transformer = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TRANSFORMER_FACTORY.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    public void setStore(String defaultStore) {
        this.defaultStore = defaultStore;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        if (webScriptServletRequest == null) {
            throw new WebScriptException("Remote Store access must be executed in HTTP Servlet environment");
        }
        HttpServletRequest httpReq = webScriptServletRequest.getHttpServletRequest();
        String extPath = req.getExtensionPath();
        String methodName = null;
        String store = null;
        StringBuilder pathBuilder = new StringBuilder(128);
        StringTokenizer tokenizer = new StringTokenizer(extPath, "/");
        if (tokenizer.hasMoreTokens()) {
            methodName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String el = tokenizer.nextToken();
                if ("s".equals(el)) {
                    store = tokenizer.nextToken();
                    String string = el = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                }
                while (el != null) {
                    pathBuilder.append('/');
                    pathBuilder.append(el);
                    el = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                }
            }
        } else {
            throw new WebScriptException("Unable to tokenize web path: " + extPath);
        }
        if (store == null) {
            store = req.getParameter("s");
            if (store == null) {
                store = this.defaultStore;
            }
            if (store == null) {
                throw new WebScriptException("Unable to determine which store to operate against. A store was not specified and a default was not provided.");
            }
        }
        String path = pathBuilder.toString();
        long start = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Remote method: " + methodName.toUpperCase() + "   Store Id: " + store + "   Path: " + path));
            start = System.nanoTime();
        }
        try {
            APIMethod method = APIMethod.valueOf(methodName.toUpperCase());
            switch (method.ordinal()) {
                case 0: {
                    BaseRemoteStore.validatePath(path);
                    this.lastModified(res, store, path);
                    break;
                }
                case 1: {
                    BaseRemoteStore.validatePath(path);
                    this.hasDocument(res, store, path);
                    break;
                }
                case 2: {
                    BaseRemoteStore.validatePath(path);
                    this.getDocument(res, store, path);
                    break;
                }
                case 3: {
                    this.listDocuments(res, store, path, false);
                    break;
                }
                case 4: {
                    this.listDocuments(res, store, path, true);
                    break;
                }
                case 5: {
                    this.listDocuments(res, store, path, req.getParameter("m"));
                    break;
                }
                case 6: {
                    BaseRemoteStore.validatePath(path);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CREATE: content length=" + httpReq.getContentLength()));
                    }
                    this.createDocument(res, store, path, (InputStream)httpReq.getInputStream());
                    break;
                }
                case 7: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CREATEMULTI: content length=" + httpReq.getContentLength()));
                    }
                    this.createDocuments(res, store, (InputStream)httpReq.getInputStream());
                    break;
                }
                case 8: {
                    BaseRemoteStore.validatePath(path);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("UPDATE: content length=" + httpReq.getContentLength()));
                    }
                    this.updateDocument(res, store, path, (InputStream)httpReq.getInputStream());
                    break;
                }
                case 9: {
                    BaseRemoteStore.validatePath(path);
                    this.deleteDocument(res, store, path);
                }
            }
        }
        catch (IllegalArgumentException enumErr) {
            throw new WebScriptException("Unknown method specified to remote store API: " + methodName);
        }
        catch (IOException ioErr) {
            throw new WebScriptException("Error during remote store API: " + ioErr.getMessage());
        }
        if (logger.isDebugEnabled()) {
            long end = System.nanoTime();
            logger.debug((Object)("Time to execute method: " + (float)(end - start) / 1000000.0f + "ms"));
        }
    }

    private static void validatePath(String path) {
        if (path == null) {
            throw new WebScriptException("Remote Store expecting document path elements.");
        }
    }

    protected List<String> getPathParts(String[] extPaths) {
        ArrayList<String> pathParts = new ArrayList<String>(extPaths.length - 1);
        for (int i = 1; i < extPaths.length; ++i) {
            pathParts.add(extPaths[i]);
        }
        return pathParts;
    }

    protected abstract void lastModified(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void hasDocument(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void getDocument(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void listDocuments(WebScriptResponse var1, String var2, String var3, boolean var4) throws IOException;

    protected abstract void listDocuments(WebScriptResponse var1, String var2, String var3, String var4) throws IOException;

    protected abstract void createDocument(WebScriptResponse var1, String var2, String var3, InputStream var4);

    protected abstract void createDocuments(WebScriptResponse var1, String var2, InputStream var3);

    protected abstract void updateDocument(WebScriptResponse var1, String var2, String var3, InputStream var4);

    protected abstract void deleteDocument(WebScriptResponse var1, String var2, String var3);

    protected static String encodePath(String s) {
        StringBuilder sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String soFar;
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '/' || ch == '\'' || ch == ' ' || ch == '.' || ch == '~' || ch == '-' || ch == '_' || ch == '@' || ch == '!' || ch == '(' || ch == ')' || ch == ';' || ch == ',' || ch == '+' || ch == '$') {
                if (sb == null) continue;
                sb.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                if (sb == null) {
                    soFar = s.substring(0, i);
                    sb = new StringBuilder(len + 16);
                    sb.append(soFar);
                }
                sb.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                if (sb == null) {
                    soFar = s.substring(0, i);
                    sb = new StringBuilder(len + 16);
                    sb.append(soFar);
                }
                sb.append(hex[0xC0 | ch >> 6]);
                sb.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            if (sb == null) {
                soFar = s.substring(0, i);
                sb = new StringBuilder(len + 16);
                sb.append(soFar);
            }
            sb.append(hex[0xE0 | ch >> 12]);
            sb.append(hex[0x80 | ch >> 6 & 0x3F]);
            sb.append(hex[0x80 | ch & 0x3F]);
        }
        return sb != null ? sb.toString() : s;
    }

    private static enum APIMethod {
        LASTMODIFIED,
        HAS,
        GET,
        LIST,
        LISTALL,
        LISTPATTERN,
        CREATE,
        CREATEMULTI,
        UPDATE,
        DELETE;

    }
}

