/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.groups;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Groups;
import org.alfresco.rest.api.model.Group;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="groups", title="Groups")
public class GroupsEntityResource
implements EntityResourceAction.Read<Group>,
EntityResourceAction.ReadById<Group>,
EntityResourceAction.Create<Group>,
EntityResourceAction.Update<Group>,
EntityResourceAction.Delete,
InitializingBean {
    private Groups groups;

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"groups", (Object)this.groups);
    }

    @Override
    @WebApiDescription(title="Get List of Groups", description="Get List of Groups")
    public CollectionWithPagingInfo<Group> readAll(Parameters params) {
        return this.groups.getGroups(params);
    }

    @Override
    @WebApiDescription(title="Returns group information for group id")
    public Group readById(String groupId, Parameters parameters) throws EntityNotFoundException {
        return this.groups.getGroup(groupId, parameters);
    }

    @Override
    @WebApiDescription(title="Create group", description="Create group")
    @WebApiParam(name="entity", title="A single group", description="A single group, multiple groups are not supported.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false, required=true)
    public List<Group> create(List<Group> entity, Parameters parameters) {
        ArrayList<Group> result = new ArrayList<Group>(1);
        result.add(this.groups.create(entity.get(0), parameters));
        return result;
    }

    @Override
    @WebApiDescription(title="Update group", description="Update group")
    public Group update(String groupId, Group group, Parameters parameters) {
        return this.groups.update(groupId, group, parameters);
    }

    @Override
    @WebApiDescription(title="Delete group", description="Delete group")
    public void delete(String groupId, Parameters parameters) {
        this.groups.delete(groupId, parameters);
    }
}

