/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.sites;

import org.alfresco.rest.api.SiteMembershipRequests;
import org.alfresco.rest.api.model.SiteMembershipApproval;
import org.alfresco.rest.api.model.SiteMembershipRejection;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="site-membership-requests", entityResource=SiteEntityResource.class, title="Site Membership Requests")
public class SiteMembershipRequestsRelation
implements InitializingBean {
    private SiteMembershipRequests siteMembershipRequests;

    public void setSiteMembershipRequests(SiteMembershipRequests siteMembershipRequests) {
        this.siteMembershipRequests = siteMembershipRequests;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"siteMembershipRequests", (Object)this.siteMembershipRequests);
    }

    @Operation(value="approve")
    @WebApiParam(name="siteMembershipApproval", title="Site membership approval", description="Site membership approval", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Approve a site membership request.", description="Approve a site membership request.", successStatus=200)
    public void approve(String siteId, String invitationId, SiteMembershipApproval siteMembershipApproval, Parameters parameters, WithResponse withResponse) {
        this.siteMembershipRequests.approveSiteMembershipRequest(siteId, invitationId, siteMembershipApproval);
    }

    @Operation(value="reject")
    @WebApiParam(name="siteMembershipRejection", title="Site membership rejection", description="Site membership rejection", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Reject a site membership request.", description="Reject a site membership request.", successStatus=200)
    public void reject(String siteId, String invitationId, SiteMembershipRejection siteMembershipRejection, Parameters parameters, WithResponse withResponse) {
        this.siteMembershipRequests.rejectSiteMembershipRequest(siteId, invitationId, siteMembershipRejection);
    }
}

