/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import java.util.List;
import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.categories.NodesCategoryLinksRelation;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NodesCategoryLinksRelationTest {
    private static final String CONTENT_ID = "content-node-id";
    private static final String CATEGORY_ID = "category-id";
    @Mock
    private Categories categoriesMock;
    @Mock
    private Category categoryMock;
    @Mock
    private Parameters parametersMock;
    @InjectMocks
    private NodesCategoryLinksRelation objectUnderTest;

    @Test
    public void testReadAll() {
        BDDMockito.given((Object)this.categoriesMock.listCategoriesForNode((String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn(List.of(this.categoryMock));
        CollectionWithPagingInfo actualCategoriesPage = this.objectUnderTest.readAll(CONTENT_ID, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).listCategoriesForNode(CONTENT_ID, this.parametersMock);
        BDDMockito.then((Object)this.categoriesMock).shouldHaveNoMoreInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)actualCategoriesPage).isNotNull()).extracting(CollectionWithPagingInfo::getCollection).isEqualTo(List.of(this.categoryMock));
    }

    @Test
    public void testCreate() {
        BDDMockito.given((Object)this.categoriesMock.linkNodeToCategories((String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn(List.of(this.categoryMock));
        List actualCategories = this.objectUnderTest.create(CONTENT_ID, List.of(this.categoryMock), this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).linkNodeToCategories(CONTENT_ID, List.of(this.categoryMock), this.parametersMock);
        BDDMockito.then((Object)this.categoriesMock).shouldHaveNoMoreInteractions();
        ((ListAssert)Assertions.assertThat((List)actualCategories).isNotNull()).isEqualTo(List.of(this.categoryMock));
    }

    @Test
    public void testDelete() {
        this.objectUnderTest.delete(CONTENT_ID, CATEGORY_ID, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).unlinkNodeFromCategory(CONTENT_ID, CATEGORY_ID, this.parametersMock);
        BDDMockito.then((Object)this.categoriesMock).shouldHaveNoMoreInteractions();
    }
}

