/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.io.IOException;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.junit.Assert;
import org.junit.Test;

public class WhereTests
implements RecognizedParamsExtractor {
    @Test
    public void basicTest() throws IOException {
        Query theQuery = this.getWhereClause(" ( fred   > g ) ");
        CommonTree ast = theQuery.getTree();
        Assert.assertEquals((long)10L, (long)ast.getType());
        Assert.assertEquals((long)23L, (long)ast.getChild(0).getType());
        Assert.assertEquals((long)24L, (long)ast.getChild(1).getType());
    }

    @Test
    public void existClauseTest() {
        Query theQuery = this.getWhereClause(null);
        Assert.assertNotNull((Object)theQuery);
        Assert.assertTrue((String)"Null passed in so nothing to theQuery.", (theQuery.getTree() == null ? 1 : 0) != 0);
        try {
            theQuery = this.getWhereClause("fred");
            Assert.fail((String)"Should throw an InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        try {
            theQuery = this.getWhereClause("(noClosingBracket");
            Assert.fail((String)"Should throw an InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        try {
            theQuery = this.getWhereClause("noOpeningBracket)");
            Assert.fail((String)"Should throw an InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        try {
            theQuery = this.getWhereClause("(EXISTS(target.file))");
            Assert.fail((String)"Should throw an InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("(exists(/target/file))");
        this.assertExistsPropertyEquals("/target/file", theQuery, false);
        theQuery = this.getWhereClause("(EXISTS(b))");
        this.assertExistsPropertyEquals("b", theQuery, false);
        theQuery = this.getWhereClause("  ( EXISTS ( whitespace ) )  ");
        this.assertExistsPropertyEquals("whitespace", theQuery, false);
        theQuery = this.getWhereClause("(exists ( folder ))");
        this.assertExistsPropertyEquals("folder", theQuery, false);
        theQuery = this.getWhereClause("(NOT EXISTS(b))");
        this.assertExistsPropertyEquals("b", theQuery, true);
        theQuery = this.getWhereClause(" (NOT EXISTS(b))");
        this.assertExistsPropertyEquals("b", theQuery, true);
        theQuery = this.getWhereClause("(  NOT EXISTS(b))");
        this.assertExistsPropertyEquals("b", theQuery, true);
        theQuery = this.getWhereClause("  (  NOT EXISTS(b))");
        this.assertExistsPropertyEquals("b", theQuery, true);
        try {
            theQuery = this.getWhereClause("(exists  folder)");
            Assert.fail((String)"Should throw an InvalidQueryException, 'folder' should have a bracket around it");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("(EXISTS(/target/folder) AND NOT EXISTS(/target/site))");
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){
            int i = 0;

            public void exists(String propertyName, boolean negated) {
                if (this.i == 0) {
                    Assert.assertTrue((boolean)"/target/folder".equals(propertyName));
                } else {
                    Assert.assertTrue((boolean)"/target/site".equals(propertyName));
                }
                ++this.i;
            }

            public void and() {
            }
        });
        try {
            theQuery = this.getWhereClause("(EXISTS(/target/folder)OR EXISTS(/target/site))");
            Assert.fail((String)"Should throw an InvalidQueryException, the OR should have a space before it.");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("(NOT EXISTS(/target/folder) OR EXISTS(/target/site))");
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void exists(String propertyName, boolean negated) {
                if (negated) {
                    Assert.assertTrue((boolean)"/target/folder".equals(propertyName));
                } else {
                    Assert.assertTrue((boolean)"/target/site".equals(propertyName));
                }
            }

            public void or() {
            }
        });
        theQuery = this.getWhereClause("(EXISTS   (  /target/folder  )   OR   EXISTS(  /target/site  )  )");
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){
            int i = 0;

            public void exists(String propertyName, boolean negated) {
                if (this.i == 0) {
                    Assert.assertTrue((boolean)"/target/folder".equals(propertyName));
                } else {
                    Assert.assertTrue((boolean)"/target/site".equals(propertyName));
                }
                ++this.i;
            }

            public void or() {
            }
        });
        theQuery = this.getWhereClause("(EXISTS(target/file) AND EXISTS(target/folder) AND EXISTS(target/site))");
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){
            int i = 0;

            public void exists(String propertyName, boolean negated) {
                switch (this.i) {
                    case 0: {
                        Assert.assertTrue((boolean)"target/file".equals(propertyName));
                        break;
                    }
                    case 1: {
                        Assert.assertTrue((boolean)"target/folder".equals(propertyName));
                        break;
                    }
                    case 2: {
                        Assert.assertTrue((boolean)"target/site".equals(propertyName));
                        break;
                    }
                }
                ++this.i;
            }

            public void and() {
            }
        });
    }

    @Test
    public void inClauseTest() {
        Query theQuery = this.getWhereClause("( dueAt in (5,8) )");
        this.inChecks(theQuery, "dueAt", "5", "8");
        theQuery = this.getWhereClause("( fred/bloggs in (head,elbow) )");
        this.inChecks(theQuery, "fred/bloggs", "head", "elbow");
        theQuery = this.getWhereClause("( nextOne in (5,8,4) )");
        this.inChecks(theQuery, "nextOne", "5", "8", "4");
        theQuery = this.getWhereClause("( nextOne in (5,56,fred) )");
        this.inChecks(theQuery, "nextOne", "5", "56", "fred");
        theQuery = this.getWhereClause("( nextOne in (5,56,'fred&') )");
        this.inChecks(theQuery, "nextOne", "5", "56", "fred&");
        theQuery = this.getWhereClause("( nextOne in ('me , you',56,egg) )");
        this.inChecks(theQuery, "nextOne", "me , you", "56", "egg");
        theQuery = this.getWhereClause("( NOT nextOne in (5,56,fred, king, kong, 'fred\\'^') )");
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void in(String property, boolean negated, String ... propertyValues) {
                Assert.assertTrue((String)"Property name should be nextOne", (boolean)"nextOne".equals(property));
                Assert.assertTrue((boolean)negated);
                String[] values = new String[]{"5", "56", "fred", "king", "kong", "fred\\'^"};
                for (int i = 0; i < values.length; ++i) {
                    Assert.assertTrue((String)("Value must match:" + values[i]), (boolean)values[i].equals(propertyValues[i]));
                }
            }
        });
    }

    @Test
    public void betweenClauseTest() {
        Query theQuery = this.getWhereClause("( dueAt between (5,8) )");
        this.betweenChecks(theQuery, "dueAt", "5", "8");
        theQuery = this.getWhereClause("( fred/bloggs between (head,elbow) )");
        this.betweenChecks(theQuery, "fred/bloggs", "head", "elbow");
        try {
            theQuery = this.getWhereClause("( nextOne between (5,8,4) )");
            Assert.fail((String)"Should throw an InvalidQueryException, between can have only two values.");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        try {
            theQuery = this.getWhereClause("( nextOne between 5,8 )");
            Assert.fail((String)"Should throw an InvalidQueryException, Need brackets.");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("(NOT dueAt between (5,8) AND nextOne between (green,blue))");
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void between(String property, String firstVal, String secondVal, boolean negated) {
                if (negated) {
                    Assert.assertTrue((String)"Property name should be dueAt", (boolean)"dueAt".equals(property));
                    Assert.assertTrue((String)"First value should be 5", (boolean)"5".equals(firstVal));
                    Assert.assertTrue((String)"Second value should be 8", (boolean)"8".equals(secondVal));
                } else {
                    Assert.assertTrue((String)"Property name should be nextOne", (boolean)"nextOne".equals(property));
                    Assert.assertTrue((String)"First value should be green", (boolean)"green".equals(firstVal));
                    Assert.assertTrue((String)"Second value should be blue", (boolean)"blue".equals(secondVal));
                }
            }

            public void and() {
            }
        });
    }

    @Test
    public void matchesClauseTest() {
        Query theQuery = this.getWhereClause("(fred matches(bob))");
        this.matchesChecks(theQuery, "fred", "bob");
        theQuery = this.getWhereClause("( king/kong/hair/shoulders/knees/toes matches ('fred%') )");
        this.matchesChecks(theQuery, "king/kong/hair/shoulders/knees/toes", "fred%");
        theQuery = this.getWhereClause("( niceone matches (bob) )");
        this.matchesChecks(theQuery, "niceone", "bob");
        try {
            theQuery = this.getWhereClause("( fred matches bob )");
            Assert.fail((String)"Should throw an InvalidQueryException, Need brackets.");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    @Test
    public void comparisonClauseTest() {
        Query theQuery = this.getWhereClause("( dueAt > '12.04.345' )");
        int comparisonOperator = 10;
        this.comparisonChecks(theQuery, comparisonOperator, "dueAt", "12.04.345");
        theQuery = this.getWhereClause("( dueAt >= '12.04.345' )");
        comparisonOperator = 11;
        this.comparisonChecks(theQuery, comparisonOperator, "dueAt", "12.04.345");
        theQuery = this.getWhereClause("( dueAt < '12.04.345' )");
        comparisonOperator = 18;
        this.comparisonChecks(theQuery, comparisonOperator, "dueAt", "12.04.345");
        theQuery = this.getWhereClause("( dueAt <= '12.04.345' )");
        comparisonOperator = 19;
        this.comparisonChecks(theQuery, comparisonOperator, "dueAt", "12.04.345");
        try {
            theQuery = this.getWhereClause("( Fred/Bloggs = %$NICE&* )");
            Assert.fail((String)"Should throw an InvalidQueryException, needs single quotes");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("( Fred/Bloggs = '%$NICE&*' )");
        comparisonOperator = 8;
        this.comparisonChecks(theQuery, comparisonOperator, "Fred/Bloggs", "%$NICE&*");
        try {
            theQuery = this.getWhereClause("( Ken = (456) )");
            Assert.fail((String)"Should throw an InvalidQueryException, needs single quotes no brackets");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        theQuery = this.getWhereClause("( Ken = '456' )");
        comparisonOperator = 8;
        this.comparisonChecks(theQuery, comparisonOperator, "Ken", "456");
        theQuery = this.getWhereClause("( DogHouse = 'Cat\\'s House' )");
        comparisonOperator = 8;
        this.comparisonChecks(theQuery, comparisonOperator, "DogHouse", "Cat\\'s House");
        theQuery = this.getWhereClause("( KING_KONG >= 'Mighty Mouse' )");
        comparisonOperator = 11;
        this.comparisonChecks(theQuery, comparisonOperator, "KING_KONG", "Mighty Mouse");
    }

    @Test
    public void stripLeadingTrailingQuotesTests() {
        Assert.assertTrue((boolean)"".equals(QueryHelper.stripQuotes((String)"")));
        Assert.assertTrue((boolean)"g".equals(QueryHelper.stripQuotes((String)"g")));
        Assert.assertTrue((boolean)"  bob ".equals(QueryHelper.stripQuotes((String)"  bob ")));
        Assert.assertTrue((boolean)"  bob '".equals(QueryHelper.stripQuotes((String)"  bob '")));
        Assert.assertTrue((boolean)"  bob ".equals(QueryHelper.stripQuotes((String)"'  bob '")));
        Assert.assertTrue((boolean)"bob".equals(QueryHelper.stripQuotes((String)"'bob'")));
    }

    @Test
    public void getChildrenTests() {
        Query theQuery = this.getWhereClause("(fred matches(bob))");
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertTrue((2 == QueryHelper.getChildren((Tree)tree).size() ? 1 : 0) != 0);
        theQuery = this.getWhereClause("( dueAt between (5,8) )");
        Assert.assertNotNull((Object)theQuery);
        tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertTrue((3 == QueryHelper.getChildren((Tree)tree).size() ? 1 : 0) != 0);
        theQuery = this.getWhereClause("(NOT EXISTS(b))");
        Assert.assertNotNull((Object)theQuery);
        tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertTrue((1 == QueryHelper.getChildren((Tree)tree).size() ? 1 : 0) != 0);
        theQuery = this.getWhereClause("(EXISTS(/target/folder) AND EXISTS(/target/site))");
        Assert.assertNotNull((Object)theQuery);
        tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertTrue((2 == QueryHelper.getChildren((Tree)tree).size() ? 1 : 0) != 0);
    }

    private void comparisonChecks(Query theQuery, final int comparisonOperator, final String propName, final String propVal) {
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)comparisonOperator, (long)tree.getType());
        Assert.assertEquals((long)23L, (long)tree.getChild(0).getType());
        Assert.assertTrue((boolean)propName.equals(tree.getChild(0).getText()));
        Assert.assertEquals((long)24L, (long)tree.getChild(1).getType());
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void comparison(int comparisonType, String propertyName, String propertyValue, boolean negated) {
                Assert.assertTrue((String)("Property name should be " + propName), (boolean)propName.equals(propertyName));
                Assert.assertTrue((comparisonOperator == comparisonType ? 1 : 0) != 0);
                Assert.assertTrue((String)("Property value should be " + propVal), (boolean)propVal.equals(propertyValue));
            }
        });
    }

    private void betweenChecks(Query theQuery, final String propName, final String firstValue, final String secondValue) {
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)5L, (long)tree.getType());
        Assert.assertEquals((long)23L, (long)tree.getChild(0).getType());
        Assert.assertTrue((boolean)propName.equals(tree.getChild(0).getText()));
        Assert.assertEquals((long)24L, (long)tree.getChild(1).getType());
        Assert.assertEquals((long)24L, (long)tree.getChild(2).getType());
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void between(String property, String firstVal, String secondVal, boolean negated) {
                Assert.assertTrue((String)("Property name should be " + propName), (boolean)propName.equals(property));
                Assert.assertTrue((String)("First value should be " + firstValue), (boolean)firstValue.equals(firstVal));
                Assert.assertTrue((String)("Second value should be " + secondValue), (boolean)secondValue.equals(secondVal));
            }
        });
    }

    private void matchesChecks(Query theQuery, final String propName, final String propVal) {
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)23L, (long)tree.getChild(0).getType());
        Assert.assertTrue((boolean)propName.equals(tree.getChild(0).getText()));
        Assert.assertEquals((long)24L, (long)tree.getChild(1).getType());
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void matches(String propertyName, String propertyValue, boolean negated) {
                Assert.assertTrue((String)("Property name should be " + propName), (boolean)propName.equals(propertyName));
                Assert.assertTrue((String)("Property value should be " + propVal), (boolean)propVal.equals(propertyValue));
            }
        });
    }

    private void inChecks(Query theQuery, final String propName, final String ... values) {
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)16L, (long)tree.getType());
        Assert.assertEquals((long)23L, (long)tree.getChild(0).getType());
        Assert.assertTrue((boolean)propName.equals(tree.getChild(0).getText()));
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void in(String property, boolean negated, String ... propertyValues) {
                Assert.assertTrue((String)("Property name should be " + propName), (boolean)propName.equals(property));
                for (int i = 0; i < values.length; ++i) {
                    Assert.assertTrue((String)("Value must match:" + values[i]), (boolean)values[i].equals(propertyValues[i]));
                }
            }
        });
    }

    private void assertExistsPropertyEquals(final String property, Query theQuery, final boolean isNegated) {
        Assert.assertNotNull((Object)theQuery);
        CommonTree tree = theQuery.getTree();
        Assert.assertNotNull((Object)tree);
        QueryHelper.walk((Query)theQuery, (QueryHelper.WalkerCallback)new QueryHelper.WalkerCallbackAdapter(this){

            public void exists(String propertyName, boolean negated) {
                Assert.assertTrue((boolean)property.equals(propertyName));
                Assert.assertTrue((isNegated == negated ? 1 : 0) != 0);
            }
        });
    }
}

