/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.VersionableAspectTest;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.util.ResourceUtils;

public class UploadWebScriptTest
extends BaseWebScriptTest {
    public static final String AUTO_VERSION_KEY = "version.store.enableAutoVersioning";
    public static final String AUTO_VERSION_PROPS_KEY = "version.store.enableAutoVersionOnUpdateProps";
    private static final String ADMIN_CREDENTIAL = "admin";
    private AuthenticationService authenticationService;
    private Properties globalProperties;
    private TransactionService transactionService;
    private SiteService siteService;
    private NodeService nodeService;
    private ContentService contentService;
    private CheckOutCheckInService checkOutCheckInService;
    private static final String DOCUMENT_SITE_NAME = "docSiteWithVersionLabel-.txt";
    private static final String UPLOAD_URL = "api/upload";
    private static final String RESOURCE_PREFIX = "publicapi/upload/";
    private static final String TEST_SITE_PRESET = "testSitePreset";
    private static final String TEST_TITLE = "TitleTest This is my title";
    private static final String TEST_DESCRIPTION = "DescriptionTest This is my description";
    private NodeRef documentSite;
    private String fileName;
    private File file;

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.globalProperties = (Properties)this.getServer().getApplicationContext().getBean("global-properties");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("transactionService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("nodeService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("contentService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.getServer().getApplicationContext().getBean("checkOutCheckInService");
        this.globalProperties.setProperty(AUTO_VERSION_PROPS_KEY, "true");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UploadWebScriptTest.this.authenticationService.authenticate(UploadWebScriptTest.ADMIN_CREDENTIAL, UploadWebScriptTest.ADMIN_CREDENTIAL.toCharArray());
                UploadWebScriptTest.this.fileName = "quick-2.pdf";
                UploadWebScriptTest.this.file = UploadWebScriptTest.this.getResourceFile(UploadWebScriptTest.this.fileName);
                SiteInfo siteInfo = UploadWebScriptTest.this.createSite("site" + GUID.generate(), "doclib", SiteVisibility.PUBLIC);
                TestWebScriptServer.Response response = UploadWebScriptTest.this.uploadFileWs(UploadWebScriptTest.this.file, UploadWebScriptTest.this.fileName, siteInfo.getShortName(), "doclib");
                TestCase.assertNotNull((String)"content of file", (Object)response.getContentAsString());
                JSONObject jsonRsp = (JSONObject)JSONValue.parse((String)response.getContentAsString());
                String ssdNodeRefString = (String)jsonRsp.get((Object)"nodeRef");
                TestCase.assertNotNull((String)"nodeRef", (Object)ssdNodeRefString);
                UploadWebScriptTest.this.documentSite = new NodeRef(ssdNodeRefString);
                return null;
            }
        });
    }

    public void testChangeMetadataOnSite() {
        final String name11 = GUID.generate() + "02";
        final String name21 = GUID.generate() + "2.1";
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Map<QName, Serializable> properties = UploadWebScriptTest.this.getAndAssertProperties(UploadWebScriptTest.this.documentSite, "1.0");
                Serializable autoVersionProps = properties.get(ContentModel.PROP_AUTO_VERSION_PROPS);
                TestCase.assertNotNull((String)("Autoversion property is NULL! NodeRef = '" + UploadWebScriptTest.this.documentSite.toString() + "'"), (Object)autoVersionProps);
                TestCase.assertTrue((String)("Autoversion must be TRUE! NodeRef = '" + UploadWebScriptTest.this.documentSite.toString() + "'"), (boolean)((Boolean)autoVersionProps));
                UploadWebScriptTest.this.nodeService.setProperty(UploadWebScriptTest.this.documentSite, ContentModel.PROP_NAME, (Serializable)((Object)name11));
                return null;
            }
        });
        Map<QName, Serializable> properties = this.getAndAssertProperties(this.documentSite, "1.1");
        UploadWebScriptTest.assertEquals((Object)name11, (Object)properties.get(ContentModel.PROP_NAME));
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef workingCopyDocSite = UploadWebScriptTest.this.checkOutCheckInService.checkout(UploadWebScriptTest.this.documentSite);
                UploadWebScriptTest.this.contentService.getWriter(workingCopyDocSite, ContentModel.PROP_CONTENT, true).putContent("content new");
                HashMap<String, VersionType> versionProperties = new HashMap<String, VersionType>();
                versionProperties.put("versionType", VersionType.MAJOR);
                UploadWebScriptTest.this.documentSite = UploadWebScriptTest.this.checkOutCheckInService.checkin(workingCopyDocSite, versionProperties);
                return null;
            }
        });
        this.getAndAssertProperties(this.documentSite, "2.0");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UploadWebScriptTest.this.nodeService.setProperty(UploadWebScriptTest.this.documentSite, ContentModel.PROP_NAME, (Serializable)((Object)name21));
                return null;
            }
        });
        this.getAndAssertProperties(this.documentSite, "2.1");
    }

    private TestWebScriptServer.Response uploadFileWs(File file, String filename, String siteId, String containerId) throws IOException {
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(file, filename, siteId, containerId);
        return this.sendRequest((TestWebScriptServer.Request)postRequest, 200);
    }

    public TestWebScriptServer.PostRequest buildMultipartPostRequest(File file, String filename, String siteId, String containerId) throws IOException {
        Part[] parts = new Part[]{new FilePart("filedata", file.getName(), file, "text/plain", null), new StringPart("filename", filename), new StringPart("description", "description"), new StringPart("siteid", siteId), new StringPart("containerid", containerId)};
        MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(parts, new HttpMethodParams());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        multipartRequestEntity.writeRequest((OutputStream)os);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(UPLOAD_URL, os.toByteArray(), multipartRequestEntity.getContentType());
        return postReq;
    }

    private File getResourceFile(String fileName) throws FileNotFoundException {
        URL url = VersionableAspectTest.class.getClassLoader().getResource(RESOURCE_PREFIX + fileName);
        if (url == null) {
            UploadWebScriptTest.fail((String)("Cannot get the resource: " + fileName));
        }
        return ResourceUtils.getFile((URL)url);
    }

    private SiteInfo createSite(String siteShortName, String componentId, SiteVisibility visibility) {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, visibility);
        this.siteService.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        return siteInfo;
    }

    private Map<QName, Serializable> getAndAssertProperties(NodeRef nodeRef, String versionLabel) {
        UploadWebScriptTest.assertNotNull((String)"NodeRef of document is NULL!", (Object)nodeRef);
        Map properties = this.nodeService.getProperties(nodeRef);
        UploadWebScriptTest.assertNotNull((String)("Properties must not be NULL! NodeRef = '" + nodeRef.toString() + "'"), (Object)properties);
        UploadWebScriptTest.assertFalse((String)("Version specific properties can't be found! NodeRef = '" + nodeRef.toString() + "'"), (boolean)properties.isEmpty());
        UploadWebScriptTest.assertEquals((Object)versionLabel, properties.get(ContentModel.PROP_VERSION_LABEL));
        return properties;
    }
}

