/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsService;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsServiceImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.SizeDetailsImpl;
import org.alfresco.rest.api.model.Node;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SizeDetailsImplTest {
    private static final String NAMESPACE = "http://www.alfresco.org/test/NodeSizeDetailsTest";
    private static final QName TYPE_FOLDER = QName.createQName((String)"http://www.alfresco.org/test/NodeSizeDetailsTest", (String)"folder");
    private SizeDetailsImpl sizeDetailsImpl;
    private Nodes nodes;
    private NodeSizeDetailsServiceImpl nodeSizeDetailsServiceImpl;
    private NodeSizeDetailsServiceImpl.NodeSizeDetails nodeSizeDetails;

    @Before
    public void setUp() throws Exception {
        this.nodes = (Nodes)Mockito.mock(Nodes.class);
        SearchService searchService = (SearchService)Mockito.mock(SearchService.class);
        this.nodeSizeDetailsServiceImpl = (NodeSizeDetailsServiceImpl)Mockito.mock(NodeSizeDetailsServiceImpl.class);
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        SimpleCache simpleCache = (SimpleCache)Mockito.mock(SimpleCache.class);
        this.nodeSizeDetails = (NodeSizeDetailsServiceImpl.NodeSizeDetails)Mockito.mock(NodeSizeDetailsServiceImpl.NodeSizeDetails.class);
        this.nodeSizeDetailsServiceImpl.setSearchService(searchService);
        this.nodeSizeDetailsServiceImpl.setDefaultItems(1000);
        this.nodeSizeDetailsServiceImpl.setSimpleCache(simpleCache);
        ((NodeSizeDetailsServiceImpl)Mockito.verify((Object)this.nodeSizeDetailsServiceImpl)).setSimpleCache(simpleCache);
        this.nodeSizeDetailsServiceImpl.setThreadPoolExecutor(threadPoolExecutor);
        this.sizeDetailsImpl = new SizeDetailsImpl(this.nodes, (NodeSizeDetailsService)this.nodeSizeDetailsServiceImpl);
    }

    @Test
    public void calculateNodeSizeDetails() {
        String nodeName = "folderNode";
        String nodeId = "node-id";
        String jobId = "job-id";
        NodeRef nodeRef = new NodeRef("protocol", "identifier", nodeId);
        Node node = new Node();
        node.setIsFolder(Boolean.valueOf(true));
        node.setNodeRef(nodeRef);
        node.setName(nodeName);
        node.setNodeType(TYPE_FOLDER.getLocalName());
        node.setNodeId(nodeRef.getId());
        Mockito.when((Object)this.nodes.validateOrLookupNode(nodeId)).thenReturn((Object)nodeRef);
        Mockito.when((Object)this.nodes.isSubClass(nodeRef, ContentModel.TYPE_FOLDER, false)).thenReturn((Object)true);
        Mockito.when((Object)this.nodeSizeDetailsServiceImpl.getSizeDetails(nodeId)).thenReturn(Optional.ofNullable(this.nodeSizeDetails));
        NodeSizeDetailsServiceImpl.NodeSizeDetails requestSizeDetails = this.sizeDetailsImpl.generateNodeSizeDetailsRequest(nodeId);
        Assert.assertNotNull((String)"After executing POST/size-details, it will provide with 202 status code", (Object)requestSizeDetails);
        NodeSizeDetailsServiceImpl.NodeSizeDetails nodeSizeDetails = this.sizeDetailsImpl.getNodeSizeDetails(nodeId, jobId);
        Assert.assertNotNull((String)"After executing GET/size-details, it will provide with 200 status code", (Object)nodeSizeDetails);
    }
}

