/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class GroupMember
extends org.alfresco.rest.api.model.GroupMember
implements Serializable,
ExpectedComparison {
    @Override
    public void expected(Object o) {
        Assert.assertTrue((String)("o is an instance of " + String.valueOf(o.getClass())), (boolean)(o instanceof GroupMember));
        GroupMember other = (GroupMember)o;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
        AssertUtil.assertEquals("displayName", this.getDisplayName(), other.getDisplayName());
        AssertUtil.assertEquals("memberType", this.getMemberType(), other.getMemberType());
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)this.getId());
        jsonObject.put((Object)"displayName", (Object)this.getDisplayName());
        jsonObject.put((Object)"memberType", (Object)this.getMemberType());
        return jsonObject;
    }

    public static GroupMember parseGroupMember(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String displayName = (String)jsonObject.get((Object)"displayName");
        String memberType = (String)jsonObject.get((Object)"memberType");
        GroupMember group = new GroupMember();
        group.setId(id);
        group.setDisplayName(displayName);
        group.setMemberType(memberType);
        return group;
    }

    public static PublicApiClient.ListResponse<GroupMember> parseGroupMembers(JSONObject jsonObject) {
        ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            groupMembers.add(GroupMember.parseGroupMember(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<GroupMember> resp = new PublicApiClient.ListResponse<GroupMember>(paging, groupMembers);
        return resp;
    }
}

