/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.replication;

import jakarta.transaction.UserTransaction;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.CancellableAction;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class ReplicationRestApiTest
extends BaseWebScriptTest {
    private static final String URL_REPLICATION_SERVICE_STATUS = "/api/replication-service-status";
    private static final String URL_DEFINITION = "api/replication-definition/";
    private static final String URL_DEFINITIONS = "api/replication-definitions";
    private static final String URL_RUNNING_ACTION = "api/running-action/";
    private static final String JSON = "application/json";
    private static final String USER_NORMAL = "Normal" + GUID.generate();
    private NodeService nodeService;
    private TestPersonManager personManager;
    private ReplicationService replicationService;
    private TransactionService transactionService;
    private ActionTrackingService actionTrackingService;
    private Repository repositoryHelper;
    private NodeRef dataDictionary;

    public void testReplicationServiceIsEnabled() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_REPLICATION_SERVICE_STATUS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject data = json.getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)data);
        ReplicationRestApiTest.assertTrue((String)"ReplicationService was unexpectedly disabled.", (boolean)data.getBoolean("enabled"));
    }

    public void testReplicationDefinitionsGet() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)0, (int)results.length());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)1, (int)results.length());
        JSONObject jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        JSONArray keys = jsonRD.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("name") || key.equals("status") || key.equals("startedAt") || key.equals("enabled") || key.equals("details")) continue;
            ReplicationRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        this.actionTrackingService.recordActionPending((Action)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Pending", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        rd = this.replicationService.createReplicationDefinition("Test2", "2nd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        rd = this.replicationService.createReplicationDefinition("AnotherTest", "3rd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)3, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"AnotherTest", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/AnotherTest", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(1);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(2);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test2", (Object)jsonRD.get("details"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definitions?sort=status"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)3, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"AnotherTest", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/AnotherTest", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(1);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test2", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(2);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        rd = this.replicationService.loadReplicationDefinition("Test2");
        this.actionTrackingService.recordActionExecuting((Action)rd);
        this.actionTrackingService.recordActionComplete((Action)rd);
        String startedAt2 = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        txn.commit();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definitions?sort=status"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)3, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Completed", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt2, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test2", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(1);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"AnotherTest", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/AnotherTest", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(2);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definitions?sort=lastRun"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)3, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Completed", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt2, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test2", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(1);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(2);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"AnotherTest", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/AnotherTest", (Object)jsonRD.get("details"));
        rd = this.replicationService.loadReplicationDefinition("AnotherTest");
        rd.setEnabled(false);
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        String startedAt3 = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITIONS), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        ReplicationRestApiTest.assertNotNull((Object)results);
        ReplicationRestApiTest.assertEquals((int)3, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"AnotherTest", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt3, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/AnotherTest", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(1);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test1", (Object)jsonRD.get("details"));
        jsonRD = (JSONObject)results.get(2);
        ReplicationRestApiTest.assertNotNull((Object)jsonRD);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)jsonRD.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Completed", (Object)jsonRD.get("status"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)jsonRD.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)startedAt2, (Object)jsonRD.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"/api/replication-definition/Test2", (Object)jsonRD.get("details"));
    }

    public void testReplicationDefinitionGet() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/madeup"), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/madeup"), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/madeup"), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        JSONArray keys = json.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("name") || key.equals("description") || key.equals("status") || key.equals("startedAt") || key.equals("endedAt") || key.equals("failureMessage") || key.equals("executionDetails") || key.equals("payload") || key.equals("transferLocalReport") || key.equals("transferRemoteReport") || key.equals("enabled") || key.equals("targetName") || key.equals("schedule")) continue;
            ReplicationRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        this.actionTrackingService.recordActionPending((Action)rd);
        String actionId = rd.getId();
        int instanceId = ((ActionImpl)rd).getExecutionInstance();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Pending", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        this.actionTrackingService.recordActionExecuting((Action)rd);
        ReplicationRestApiTest.assertEquals((String)actionId, (String)rd.getId());
        ReplicationRestApiTest.assertEquals((int)instanceId, (int)((ActionImpl)rd).getExecutionInstance());
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        rd.getPayload().add(this.repositoryHelper.getCompanyHome());
        rd.getPayload().add(this.dataDictionary);
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)2, (int)json.getJSONArray("payload").length());
        JSONObject payload = json.getJSONArray("payload").getJSONObject(0);
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Company Home", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home", (Object)payload.get("path"));
        payload = json.getJSONArray("payload").getJSONObject(1);
        ReplicationRestApiTest.assertEquals((Object)this.dataDictionary.toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Data Dictionary", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home/Data Dictionary", (Object)payload.get("path"));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        NodeRef deleted = this.nodeService.createNode(this.dataDictionary, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"IwillBEdeleted"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.deleteNode(deleted);
        txn.commit();
        rd.getPayload().add(deleted);
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)2, (int)json.getJSONArray("payload").length());
        payload = json.getJSONArray("payload").getJSONObject(0);
        ReplicationRestApiTest.assertEquals((Object)"Company Home", (Object)payload.get("name"));
        payload = json.getJSONArray("payload").getJSONObject(1);
        ReplicationRestApiTest.assertEquals((Object)"Data Dictionary", (Object)payload.get("name"));
        rd = this.replicationService.createReplicationDefinition("Test2", "2nd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        rd = this.replicationService.createReplicationDefinition("Test3", "3rd Testing");
        rd.setLocalTransferReport(this.repositoryHelper.getRootHome());
        rd.setRemoteTransferReport(this.repositoryHelper.getCompanyHome());
        rd.setEnabled(false);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        this.actionTrackingService.recordActionFailure((Action)rd, (Throwable)new Exception("Test Failure"));
        txn.commit();
        Thread.sleep(50L);
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test1"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test1", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)2, (int)json.getJSONArray("payload").length());
        payload = json.getJSONArray("payload").getJSONObject(0);
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Company Home", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home", (Object)payload.get("path"));
        payload = json.getJSONArray("payload").getJSONObject(1);
        ReplicationRestApiTest.assertEquals((Object)this.dataDictionary.toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Data Dictionary", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home/Data Dictionary", (Object)payload.get("path"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test2"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"2nd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test3"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        String endedAt = ISO8601DateFormat.format((Date)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals((Object)"Test3", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"3rd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Failed", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)endedAt, (Object)json.getJSONObject("endedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)"Test Failure", (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getRootHome().toString(), (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        rd = this.replicationService.loadReplicationDefinition("Test3");
        ReplicationRestApiTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions((Action)rd).size());
        this.actionTrackingService.recordActionPending((Action)rd);
        ReplicationRestApiTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions((Action)rd).size());
        instanceId = ((ActionImpl)rd).getExecutionInstance();
        actionId = rd.getId();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test3"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertEquals((Object)"Test3", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"3rd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Pending", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        this.actionTrackingService.recordActionExecuting((Action)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test3"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals((Object)"Test3", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"3rd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test3"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals((Object)"Test3", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"3rd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"CancelRequested", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.actionTrackingService.recordActionComplete((Action)rd);
        txn.commit();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test3"), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        endedAt = ISO8601DateFormat.format((Date)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals((Object)"Test3", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"3rd Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Completed", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)endedAt, (Object)json.getJSONObject("endedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getRootHome().toString(), (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
    }

    public void testReplicationDefinitionsPost() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, "", JSON), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, "", JSON), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ReplicationRestApiTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        JSONObject json = new JSONObject();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 400);
        ReplicationRestApiTest.assertEquals((int)400, (int)response.getStatus());
        json.put("name", (Object)"New Definition");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 400);
        ReplicationRestApiTest.assertEquals((int)400, (int)response.getStatus());
        json.put("description", (Object)"Testing");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"New Definition", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        ReplicationDefinition rd = this.replicationService.loadReplicationDefinition("New Definition");
        ReplicationRestApiTest.assertEquals((String)"New Definition", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Testing", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)true, (boolean)rd.isEnabled());
        json = new JSONObject();
        json.put("name", (Object)"Test");
        json.put("description", (Object)"Test Description");
        json.put("targetName", (Object)"Target");
        json.put("enabled", false);
        JSONArray payloadRefs = new JSONArray();
        payloadRefs.put((Object)this.repositoryHelper.getCompanyHome().toString());
        payloadRefs.put((Object)this.dataDictionary.toString());
        json.put("payload", (Object)payloadRefs);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Test Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)2, (int)json.getJSONArray("payload").length());
        JSONObject payload = json.getJSONArray("payload").getJSONObject(0);
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Company Home", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home", (Object)payload.get("path"));
        payload = json.getJSONArray("payload").getJSONObject(1);
        ReplicationRestApiTest.assertEquals((Object)this.dataDictionary.toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Data Dictionary", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home/Data Dictionary", (Object)payload.get("path"));
        rd = this.replicationService.loadReplicationDefinition("Test");
        ReplicationRestApiTest.assertEquals((String)"Test", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Test Description", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals((String)"Target", (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((boolean)false, (boolean)rd.isEnabled());
        ReplicationRestApiTest.assertEquals((int)2, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome(), rd.getPayload().get(0));
        ReplicationRestApiTest.assertEquals((Object)this.dataDictionary, rd.getPayload().get(1));
        rd = this.replicationService.loadReplicationDefinition("New Definition");
        ReplicationRestApiTest.assertEquals((String)"New Definition", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Testing", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)true, (boolean)rd.isEnabled());
        json = new JSONObject();
        json.put("name", (Object)"Test");
        json.put("description", (Object)"New Duplicate");
        json.put("targetName", (Object)"New Duplicate Target");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 400);
        ReplicationRestApiTest.assertEquals((int)400, (int)response.getStatus());
        rd = this.replicationService.loadReplicationDefinition("New Definition");
        ReplicationRestApiTest.assertEquals((String)"New Definition", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Testing", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)true, (boolean)rd.isEnabled());
    }

    public void testReplicationDefinitionPut() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/MadeUp", "", JSON), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/MadeUp", "", JSON), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ReplicationRestApiTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/MadeUp", "", JSON), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", "{}", JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Testing", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        JSONArray keys = json.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("name") || key.equals("description") || key.equals("status") || key.equals("startedAt") || key.equals("endedAt") || key.equals("failureMessage") || key.equals("executionDetails") || key.equals("payload") || key.equals("transferLocalReport") || key.equals("transferRemoteReport") || key.equals("enabled") || key.equals("targetName") || key.equals("schedule")) continue;
            ReplicationRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        json = new JSONObject();
        json.put("description", (Object)"Updated Description");
        json.put("enabled", false);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        rd = this.replicationService.loadReplicationDefinition("Test");
        ReplicationRestApiTest.assertEquals((String)"Test", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Updated Description", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)false, (boolean)rd.isEnabled());
        rd = this.replicationService.createReplicationDefinition("Test2", "Testing2");
        rd.setTargetName("Target");
        this.replicationService.saveReplicationDefinition(rd);
        json = new JSONObject();
        json.put("description", (Object)"Updated Description 2");
        json.put("enabled", false);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test2", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test2", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description 2", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)false, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        rd = this.replicationService.loadReplicationDefinition("Test");
        ReplicationRestApiTest.assertEquals((String)"Test", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Updated Description", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)false, (boolean)rd.isEnabled());
        rd = this.replicationService.loadReplicationDefinition("Test2");
        ReplicationRestApiTest.assertEquals((String)"Test2", (String)rd.getReplicationName());
        ReplicationRestApiTest.assertEquals((String)"Updated Description 2", (String)rd.getDescription());
        ReplicationRestApiTest.assertEquals((Object)ActionStatus.New, (Object)rd.getExecutionStatus());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getExecutionEndDate());
        ReplicationRestApiTest.assertEquals(null, (String)rd.getExecutionFailureMessage());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getLocalTransferReport());
        ReplicationRestApiTest.assertEquals(null, (Object)rd.getRemoteTransferReport());
        ReplicationRestApiTest.assertEquals((String)"Target", (String)rd.getTargetName());
        ReplicationRestApiTest.assertEquals((int)0, (int)rd.getPayload().size());
        ReplicationRestApiTest.assertEquals((boolean)false, (boolean)rd.isEnabled());
        rd = this.replicationService.loadReplicationDefinition("Test");
        this.actionTrackingService.recordActionExecuting((Action)rd);
        this.replicationService.saveReplicationDefinition(rd);
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        String actionId = rd.getId();
        int instanceId = ((ActionImpl)rd).getExecutionInstance();
        json = new JSONObject();
        json.put("enabled", true);
        json.put("targetName", (Object)"Another Target");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Another Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        JSONArray payloadRefs = new JSONArray();
        payloadRefs.put((Object)this.repositoryHelper.getCompanyHome().toString());
        payloadRefs.put((Object)this.dataDictionary.toString());
        json = new JSONObject();
        json.put("payload", (Object)payloadRefs);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Another Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)2, (int)json.getJSONArray("payload").length());
        JSONObject payload = json.getJSONArray("payload").getJSONObject(0);
        ReplicationRestApiTest.assertEquals((Object)this.repositoryHelper.getCompanyHome().toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Company Home", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home", (Object)payload.get("path"));
        payload = json.getJSONArray("payload").getJSONObject(1);
        ReplicationRestApiTest.assertEquals((Object)this.dataDictionary.toString(), (Object)payload.get("nodeRef"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)payload.get("isFolder"));
        ReplicationRestApiTest.assertEquals((Object)"Data Dictionary", (Object)payload.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"/Company Home/Data Dictionary", (Object)payload.get("path"));
        json = new JSONObject();
        payloadRefs = new JSONArray();
        json.put("payload", (Object)payloadRefs);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Test", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Another Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        json = new JSONObject();
        json.put("name", (Object)"Test2");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 400);
        ReplicationRestApiTest.assertEquals((int)400, (int)response.getStatus());
        json = new JSONObject();
        json.put("name", (Object)"Renamed");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Test", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Renamed", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Updated Description", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"Another Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        ReplicationRestApiTest.assertEquals(null, (Object)this.replicationService.loadReplicationDefinition("Test"));
        ReplicationRestApiTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("Renamed"));
        json = new JSONObject();
        json.put("name", (Object)"Renamed Again");
        json.put("description", (Object)"Was Renamed");
        json.put("targetName", (Object)"New Target");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/replication-definition/Renamed", json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)"Renamed Again", (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Was Renamed", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"Running", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)startedAt, (Object)json.getJSONObject("startedAt").get("iso8601"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + actionId + "=" + instanceId), (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)"New Target", (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
    }

    public void testReplicationDefinitionDelete() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/MadeUp"), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/MadeUp"), 401);
        ReplicationRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ReplicationRestApiTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/MadeUp"), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        ReplicationRestApiTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/Test"), 204);
        ReplicationRestApiTest.assertEquals((int)204, (int)response.getStatus());
        txn.commit();
        Thread.sleep(50L);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/replication-definition/Test"), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test"));
        ReplicationRestApiTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
        rd = this.replicationService.createReplicationDefinition("Test", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        rd = this.replicationService.createReplicationDefinition("Test 2", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        rd = this.replicationService.createReplicationDefinition("Test 3", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        ReplicationRestApiTest.assertEquals((int)3, (int)this.replicationService.loadReplicationDefinitions().size());
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/Test"), 204);
        ReplicationRestApiTest.assertEquals((int)204, (int)response.getStatus());
        txn.commit();
        Thread.sleep(50L);
        ReplicationRestApiTest.assertEquals((int)2, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test"));
        ReplicationRestApiTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("Test 2"));
        ReplicationRestApiTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("Test 3"));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/Test 3"), 204);
        ReplicationRestApiTest.assertEquals((int)204, (int)response.getStatus());
        txn.commit();
        Thread.sleep(50L);
        ReplicationRestApiTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test"));
        ReplicationRestApiTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("Test 2"));
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test 3"));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/replication-definition/Test 3"), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        txn.commit();
        Thread.sleep(50L);
        ReplicationRestApiTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test"));
        ReplicationRestApiTest.assertNotNull((Object)this.replicationService.loadReplicationDefinition("Test 2"));
        ReplicationRestApiTest.assertNull((Object)this.replicationService.loadReplicationDefinition("Test 3"));
    }

    public void testReplicationDefinitionsNastyNames() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String nastyName = "~!@#$%^&()_+-={}[];";
        String nastyNameURL = URLEncoder.encodeUriComponent((String)nastyName);
        JSONObject json = new JSONObject();
        json.put("name", (Object)nastyName);
        json.put("description", (Object)"Nasty Characters");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DEFINITIONS, json.toString(), JSON), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)nastyName, (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Nasty Characters", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("startedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("endedAt"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("failureMessage"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("executionDetails"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferLocalReport"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("transferRemoteReport"));
        ReplicationRestApiTest.assertEquals((Object)true, (Object)json.get("enabled"));
        ReplicationRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)json.get("targetName"));
        ReplicationRestApiTest.assertEquals((int)0, (int)json.getJSONArray("payload").length());
        ReplicationRestApiTest.assertEquals((int)1, (int)this.replicationService.loadReplicationDefinitions().size());
        ReplicationRestApiTest.assertEquals((String)nastyName, (String)((ReplicationDefinition)this.replicationService.loadReplicationDefinitions().get(0)).getReplicationName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITION + nastyNameURL), 200);
        ReplicationRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr).getJSONObject("data");
        ReplicationRestApiTest.assertNotNull((Object)json);
        ReplicationRestApiTest.assertEquals((Object)nastyName, (Object)json.get("name"));
        ReplicationRestApiTest.assertEquals((Object)"Nasty Characters", (Object)json.get("description"));
        ReplicationRestApiTest.assertEquals((Object)"New", (Object)json.get("status"));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_DEFINITION + nastyNameURL), 204);
        ReplicationRestApiTest.assertEquals((int)204, (int)response.getStatus());
        txn.commit();
        Thread.sleep(50L);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_DEFINITION + nastyNameURL), 404);
        ReplicationRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationRestApiTest.assertEquals((int)0, (int)this.replicationService.loadReplicationDefinitions().size());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.replicationService = (ReplicationService)appContext.getBean("ReplicationService");
        this.actionTrackingService = (ActionTrackingService)appContext.getBean("actionTrackingService");
        this.repositoryHelper = (Repository)appContext.getBean("repositoryHelper");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)appContext.getBean("AuthenticationService");
        PersonService personService = (PersonService)appContext.getBean("PersonService");
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.personManager.createPerson(USER_NORMAL);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (ReplicationDefinition rd : this.replicationService.loadReplicationDefinitions()) {
            this.replicationService.deleteReplicationDefinition(rd);
        }
        txn.commit();
        this.dataDictionary = this.nodeService.getChildByName(this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, "Data Dictionary");
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.personManager.clearPeople();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (ReplicationDefinition rd : this.replicationService.loadReplicationDefinitions()) {
            this.replicationService.deleteReplicationDefinition(rd);
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        txn.commit();
    }
}

