/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.node;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodeFolderPost
extends DeclarativeWebScript {
    private NodeService nodeService;
    private SiteService siteService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        SiteInfo site = null;
        String container = null;
        NodeRef parentNodeRef = null;
        Map templateArgs = req.getServiceMatch().getTemplateVars();
        if (templateArgs.get("site") != null && templateArgs.get("container") != null) {
            site = this.siteService.getSite((String)templateArgs.get("site"));
            if (site == null) {
                status.setCode(404);
                status.setRedirect(true);
                return null;
            }
            container = (String)templateArgs.get("container");
            NodeRef containerNodeRef = this.siteService.getContainer(site.getShortName(), container);
            if (containerNodeRef == null) {
                status.setCode(404);
                status.setRedirect(true);
                return null;
            }
            if (templateArgs.get("path") != null) {
                parentNodeRef = containerNodeRef;
                StringTokenizer st = new StringTokenizer((String)templateArgs.get("path"), "/");
                while (st.hasMoreTokens()) {
                    String childName = st.nextToken();
                    if ((parentNodeRef = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, childName)) != null) continue;
                    status.setCode(404);
                    status.setRedirect(true);
                    return null;
                }
            } else {
                parentNodeRef = containerNodeRef;
            }
        } else if (templateArgs.get("store_type") != null && templateArgs.get("store_id") != null && templateArgs.get("id") != null) {
            parentNodeRef = new NodeRef((String)templateArgs.get("store_type"), (String)templateArgs.get("store_id"), (String)templateArgs.get("id"));
            if (!this.nodeService.exists(parentNodeRef)) {
                status.setCode(404);
                status.setRedirect(true);
                return null;
            }
        } else {
            throw new WebScriptException(400, "No parent details found");
        }
        JSONObject json = null;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(req.getContent().getContent());
        }
        catch (IOException io) {
            throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
        }
        catch (ParseException pe) {
            throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
        }
        String name = (String)json.get((Object)"name");
        if (name == null) {
            throw new WebScriptException(400, "Name is required");
        }
        String title = (String)json.get((Object)"title");
        if (title == null) {
            title = name;
        }
        String description = (String)json.get((Object)"description");
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_TITLE, title);
        props.put(ContentModel.PROP_DESCRIPTION, description);
        QName type = ContentModel.TYPE_FOLDER;
        if (json.get((Object)"type") != null && !this.dictionaryService.isSubClass(type = QName.createQName((String)((String)json.get((Object)"type")), (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER)) {
            throw new WebScriptException(400, "Specified type is not a folder");
        }
        NodeRef nodeRef = null;
        try {
            nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), type, props).getChildRef();
        }
        catch (AccessDeniedException e) {
            throw new WebScriptException(403, "You don't have permission to create the node");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("nodeRef", nodeRef);
        model.put("site", site);
        model.put("container", container);
        model.put("parentNodeRef", parentNodeRef);
        return model;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

