/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class FacetField {
    private final String field;
    private final String label;
    private final String prefix;
    private final String sort;
    private final String method;
    private final Boolean missing;
    private final Integer limit;
    private final Integer offset;
    private final Integer mincount;
    private final Integer facetEnumCacheMinDf;
    private final List<String> excludeFilters;

    @JsonCreator
    public FacetField(@JsonProperty(value="field") String field, @JsonProperty(value="label") String label, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="sort") String sort, @JsonProperty(value="method") String method, @JsonProperty(value="missing") Boolean missing, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="offset") Integer offset, @JsonProperty(value="mincount") Integer mincount, @JsonProperty(value="excludeFilters") List<String> excludeFilters, @JsonProperty(value="facetEnumCacheMinDf") Integer facetEnumCacheMinDf) {
        this.field = field;
        this.label = label;
        this.prefix = prefix;
        this.sort = sort;
        this.method = method;
        this.missing = missing == null ? false : missing;
        this.limit = limit;
        this.offset = offset == null ? 0 : offset;
        this.mincount = mincount == null ? 1 : mincount;
        this.excludeFilters = excludeFilters == null ? Collections.emptyList() : excludeFilters;
        this.facetEnumCacheMinDf = facetEnumCacheMinDf == null ? 0 : facetEnumCacheMinDf;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public String getField() {
        return this.field;
    }

    public String getLabel() {
        return this.label;
    }

    public String toFilterQuery(String value) {
        return "Null".equals(value) ? "ISNULL:\"" + this.field + "\"" : this.field + ":\"" + value + "\"";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSort() {
        return this.sort;
    }

    public String getMethod() {
        return this.method;
    }

    public Boolean getMissing() {
        return this.missing;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getMincount() {
        return this.mincount;
    }

    public Integer getFacetEnumCacheMinDf() {
        return this.facetEnumCacheMinDf;
    }
}

