/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Association;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeAssociationsApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_DELETED_NODES = "deleted-nodes";
    private static final String PARAM_ASSOC_TYPE = "assocType";
    private static final String URL_TARGETS = "targets";
    private static final String URL_SOURCES = "sources";
    private static final String ASPECT_CM_REFERENCING = "cm:referencing";
    private static final String ASSOC_TYPE_CM_REFERENCES = "cm:references";
    private static final String ASPECT_CM_PARTABLE = "cm:partable";
    private static final String ASSOC_TYPE_CM_PARTS = "cm:parts";
    private static final String URL_SECONDARY_CHILDREN = "secondary-children";
    private static final String URL_PARENTS = "parents";
    private PermissionService permissionService;

    protected String getNodeTargetsUrl(String nodeId) {
        return "nodes/" + nodeId + "/targets";
    }

    protected String getNodeSourcesUrl(String nodeId) {
        return "nodes/" + nodeId + "/sources";
    }

    protected String getNodeSecondaryChildrenUrl(String nodeId) {
        return "nodes/" + nodeId + "/secondary-children";
    }

    protected String getNodeParentsUrl(String nodeId) {
        return "nodes/" + nodeId + "/parents";
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService", PermissionService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodePeerAssocs() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        Node n = new Node();
        n.setName("o1");
        n.setNodeType("cm:content");
        n.setAspectNames(Arrays.asList(ASPECT_CM_REFERENCING, ASPECT_CM_PARTABLE));
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String f2Id = this.createFolder(myFolderNodeId, "f2").getId();
        n = new Node();
        n.setName("o2");
        n.setNodeType("cm:content");
        n.setAspectNames(Arrays.asList(ASPECT_CM_REFERENCING, ASPECT_CM_PARTABLE));
        response = this.post(this.getNodeChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o2Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            AssocTarget tgt = new AssocTarget(o2Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(o1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            tgt = new AssocTarget(o2Id, ASSOC_TYPE_CM_PARTS);
            this.post(this.getNodeTargetsUrl(o1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            tgt = new AssocTarget(o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(o2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            tgt = new AssocTarget(o1Id, ASSOC_TYPE_CM_PARTS);
            this.post(this.getNodeTargetsUrl(o2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("where", "(assocType='cm:references')");
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)ASSOC_TYPE_CM_REFERENCES, (Object)nodes.get(0).getAssociation().getAssocType());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)ASSOC_TYPE_CM_REFERENCES, (Object)nodes.get(0).getAssociation().getAssocType());
            params = new HashMap(1);
            params.put("where", "(assocType='cm:parts')");
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o1Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)ASSOC_TYPE_CM_PARTS, (Object)nodes.get(0).getAssociation().getAssocType());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o1Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)ASSOC_TYPE_CM_PARTS, (Object)nodes.get(0).getAssociation().getAssocType());
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, ASSOC_TYPE_CM_REFERENCES);
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, params, 204);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, ASSOC_TYPE_CM_PARTS);
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, params, 204);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.delete(this.getNodeTargetsUrl(o2Id), o1Id, 204);
            response = this.getAll(this.getNodeTargetsUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.setRequestContext(null);
            tgt = new AssocTarget(o2Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(o1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 401);
            this.setRequestContext(user1);
            tgt = new AssocTarget(f2Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(o1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 422);
            tgt = new AssocTarget(o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(o2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.post(this.getNodeTargetsUrl(o2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 409);
            tgt = new AssocTarget(o1Id, "cm:unknowntype");
            this.post(this.getNodeTargetsUrl(o2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 400);
            this.setRequestContext(null);
            this.getAll(this.getNodeTargetsUrl(f1Id), paging, null, 401);
            this.getAll(this.getNodeSourcesUrl(f1Id), paging, null, 401);
            this.setRequestContext(user1);
            this.getAll(this.getNodeTargetsUrl(UUID.randomUUID().toString()), paging, null, 404);
            this.getAll(this.getNodeSourcesUrl(UUID.randomUUID().toString()), paging, null, 404);
            params = new HashMap(1);
            params.put("where", "(assocType='cm:unknownassoctype')");
            this.getAll(this.getNodeTargetsUrl(o1Id), paging, params, 400);
            this.getAll(this.getNodeSourcesUrl(o1Id), paging, params, 400);
            this.setRequestContext(null);
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, 401);
            this.setRequestContext(user1);
            this.delete(this.getNodeTargetsUrl(UUID.randomUUID().toString()), o2Id, null, 404);
            this.delete(this.getNodeTargetsUrl(o1Id), UUID.randomUUID().toString(), null, 404);
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, null, 404);
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, ASSOC_TYPE_CM_REFERENCES);
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, params, 404);
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:unknowntype");
            this.delete(this.getNodeTargetsUrl(o1Id), o2Id, params, 400);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
            this.deleteNode(f2Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodePeerAssocsPermissions() throws Exception {
        this.setRequestContext(user1);
        String sharedFolderNodeId = this.getSharedNodeId();
        String sf1Id = this.createFolder(sharedFolderNodeId, "shared folder " + this.RUNID).getId();
        Node n = new Node();
        n.setName("shared content " + this.RUNID);
        n.setNodeType("cm:content");
        n.setAspectNames(Arrays.asList(ASPECT_CM_REFERENCING, ASPECT_CM_PARTABLE));
        HttpResponse response = this.post(this.getNodeChildrenUrl(sf1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String so1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String u1myNodeId = this.getMyNodeId();
        String u1f1Id = this.createFolder(u1myNodeId, "f1").getId();
        n = new Node();
        n.setName("o1");
        n.setNodeType("cm:content");
        n.setAspectNames(Arrays.asList(ASPECT_CM_REFERENCING, ASPECT_CM_PARTABLE));
        response = this.post(this.getNodeChildrenUrl(u1f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String u1o1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        this.setRequestContext(user2);
        String u2myNodeId = this.getMyNodeId();
        String u2f1Id = this.createFolder(u2myNodeId, "f1").getId();
        n = new Node();
        n.setName("o1");
        n.setNodeType("cm:content");
        n.setAspectNames(Arrays.asList(ASPECT_CM_REFERENCING, ASPECT_CM_PARTABLE));
        response = this.post(this.getNodeChildrenUrl(u2f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String u2o1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            this.setRequestContext(user1);
            response = this.getAll(this.getNodeTargetsUrl(u1f1Id), paging, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.setRequestContext(user2);
            response = this.getAll(this.getNodeTargetsUrl(u2f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.setRequestContext(user1);
            AssocTarget tgt = new AssocTarget(u1o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u1f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(user2);
            tgt = new AssocTarget(u2o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u2f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(user1);
            response = this.getAll(this.getNodeTargetsUrl(u1f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            this.setRequestContext(user2);
            response = this.getAll(this.getNodeTargetsUrl(u2f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            this.setRequestContext(user2);
            this.getAll(this.getNodeTargetsUrl(u1f1Id), paging, null, 403);
            this.getAll(this.getNodeSourcesUrl(u1o1Id), paging, null, 403);
            this.setRequestContext(user1);
            tgt = new AssocTarget(u2o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u1f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 403);
            tgt = new AssocTarget(u1o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u2f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 403);
            this.setRequestContext(user2);
            this.delete(this.getNodeTargetsUrl(u1f1Id), u2o1Id, null, 403);
            this.delete(this.getNodeTargetsUrl(u2f1Id), u1o1Id, null, 404);
            this.setRequestContext(user1);
            AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
            this.permissionService.setPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, sf1Id), user2, "Editor", true);
            this.setRequestContext(networkAdmin);
            response = this.publicApiClient.get(this.getScope(), "nodes/" + sf1Id + "/targets", null, null, null, this.createParams(paging, null));
            this.checkStatus(200, response.getStatusCode());
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.setRequestContext(user1);
            tgt = new AssocTarget(u1o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(sf1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(user2);
            tgt = new AssocTarget(u2o1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(sf1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(networkAdmin);
            response = this.publicApiClient.get(this.getScope(), "nodes/" + sf1Id + "/targets", null, null, null, this.createParams(paging, null));
            this.checkStatus(200, response.getStatusCode());
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            this.setRequestContext(user1);
            response = this.getAll(this.getNodeTargetsUrl(sf1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)u1o1Id, (Object)nodes.get(0).getId());
            this.setRequestContext(user2);
            response = this.getAll(this.getNodeTargetsUrl(sf1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)u2o1Id, (Object)nodes.get(0).getId());
            AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
            this.permissionService.setPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, sf1Id), user2, "Editor", true);
            this.setRequestContext(networkAdmin);
            response = this.publicApiClient.get(this.getScope(), "nodes/" + so1Id + "/sources", null, null, null, this.createParams(paging, null));
            this.checkStatus(200, response.getStatusCode());
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.setRequestContext(user1);
            tgt = new AssocTarget(so1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u1f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(user2);
            tgt = new AssocTarget(so1Id, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(u2f1Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            this.setRequestContext(networkAdmin);
            response = this.publicApiClient.get(this.getScope(), "nodes/" + so1Id + "/sources", null, null, null, this.createParams(paging, null));
            this.checkStatus(200, response.getStatusCode());
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            this.setRequestContext(user1);
            response = this.getAll(this.getNodeSourcesUrl(so1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)u1f1Id, (Object)nodes.get(0).getId());
            this.setRequestContext(user2);
            response = this.getAll(this.getNodeSourcesUrl(so1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)u2f1Id, (Object)nodes.get(0).getId());
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(u1f1Id, true, 204);
            this.deleteNode(sf1Id, true, 204);
            this.setRequestContext(user2);
            this.deleteNode(u2f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeSecondaryChildAssocs() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        Node n = new Node();
        n.setName("f1");
        n.setNodeType("cm:folder");
        n.setAspectNames(Arrays.asList("cm:preferences"));
        HttpResponse response = this.post(this.getNodeChildrenUrl(myFolderNodeId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String f1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String o1Name = "o1";
        n = new Node();
        n.setName(o1Name);
        n.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String f2Id = this.createFolder(myFolderNodeId, "f2").getId();
        String o2Name = "o2";
        n = new Node();
        n.setName(o2Name);
        n.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o2Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String f3Id = this.createFolder(myFolderNodeId, "f3").getId();
        String f4Id = this.createFolder(myFolderNodeId, "f4").getId();
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)"cm:contains", (Object)nodes.get(0).getAssociation().getAssocType());
            Assert.assertTrue((boolean)nodes.get(0).getAssociation().getIsPrimary());
            AssocChild secChild = new AssocChild(o2Id, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(o2Id, "cm:preferenceImage");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            int i = 0;
            for (Node node : nodes) {
                Association association = node.getAssociation();
                if (association.getAssocType().equals("cm:contains")) {
                    ++i;
                } else if (association.getAssocType().equals("cm:preferenceImage")) {
                    ++i;
                }
                Assert.assertEquals((Object)o2Id, (Object)node.getId());
                Assert.assertFalse((boolean)association.getIsPrimary());
            }
            Assert.assertEquals((long)2L, (long)i);
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            i = 0;
            for (Node node : nodes) {
                String string = node.getId();
                Association nodeAssoc = node.getAssociation();
                if (string.equals(f2Id)) {
                    Assert.assertEquals((Object)"cm:contains", (Object)nodeAssoc.getAssocType());
                    Assert.assertTrue((boolean)nodeAssoc.getIsPrimary());
                    ++i;
                    continue;
                }
                if (!string.equals(f1Id)) continue;
                if (nodeAssoc.getAssocType().equals("cm:contains")) {
                    ++i;
                } else if (nodeAssoc.getAssocType().equals("cm:preferenceImage")) {
                    ++i;
                }
                Assert.assertFalse((boolean)nodeAssoc.getIsPrimary());
            }
            Assert.assertEquals((long)3L, (long)i);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("where", "(assocType='cm:contains')");
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)"cm:contains", (Object)nodes.get(0).getAssociation().getAssocType());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            i = 0;
            for (Node node : nodes) {
                String nodeId = node.getId();
                Association nodeAssoc = node.getAssociation();
                if (nodeId.equals(f2Id)) {
                    Assert.assertEquals((Object)"cm:contains", (Object)nodeAssoc.getAssocType());
                    Assert.assertTrue((boolean)nodeAssoc.getIsPrimary());
                    ++i;
                    continue;
                }
                if (!nodeId.equals(f1Id)) continue;
                Assert.assertEquals((Object)"cm:contains", (Object)nodeAssoc.getAssocType());
                Assert.assertFalse((boolean)nodeAssoc.getIsPrimary());
                ++i;
            }
            Assert.assertEquals((long)2L, (long)i);
            params = new HashMap(1);
            params.put("where", "(assocType='cm:preferenceImage')");
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)"cm:preferenceImage", (Object)nodes.get(0).getAssociation().getAssocType());
            Assert.assertFalse((boolean)nodes.get(0).getAssociation().getIsPrimary());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)"cm:preferenceImage", (Object)nodes.get(0).getAssociation().getAssocType());
            Assert.assertFalse((boolean)nodes.get(0).getAssociation().getIsPrimary());
            response = this.getAll(this.getNodeChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            List<String> list = Arrays.asList(nodes.get(0).getId(), nodes.get(1).getId());
            Assert.assertTrue((boolean)list.contains(o1Id));
            Assert.assertTrue((boolean)list.contains(o2Id));
            params = new HashMap(1);
            params.put("where", "(isPrimary=true)");
            response = this.getAll(this.getNodeChildrenUrl(f1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o1Id, (Object)nodes.get(0).getId());
            params = new HashMap(1);
            params.put("where", "(isPrimary=false)");
            response = this.getAll(this.getNodeChildrenUrl(f1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)3L, (long)nodes.size());
            params = new HashMap(1);
            params.put("where", "(isPrimary=true)");
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f2Id, (Object)nodes.get(0).getId());
            params = new HashMap(1);
            params.put("where", "(isPrimary=false)");
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            i = 0;
            for (Node node : nodes) {
                String nodeId = node.getId();
                Association nodeAssoc = node.getAssociation();
                if (!nodeId.equals(f1Id)) continue;
                if (nodeAssoc.getAssocType().equals("cm:contains")) {
                    ++i;
                } else if (nodeAssoc.getAssocType().equals("cm:preferenceImage")) {
                    ++i;
                }
                Assert.assertFalse((boolean)nodeAssoc.getIsPrimary());
            }
            Assert.assertEquals((long)2L, (long)i);
            params = new HashMap(1);
            params.put("where", "(isPrimary=false and assocType='cm:preferenceImage')");
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1Id, (Object)nodes.get(0).getId());
            Assert.assertFalse((boolean)nodes.get(0).getAssociation().getIsPrimary());
            Assert.assertEquals((Object)"cm:preferenceImage", (Object)nodes.get(0).getAssociation().getAssocType());
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:contains");
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, params, 204);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:preferenceImage");
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, params, 204);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            secChild = new AssocChild(o2Id, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(o2Id, "cm:preferenceImage");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(1).getId());
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, null, 204);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f3Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            int n2 = 6;
            String[] childIds = new String[n2];
            for (int j = 0; j < n2; ++j) {
                String childName = "child " + j;
                n = new Node();
                n.setName(childName);
                n.setNodeType("cm:content");
                response = this.post(this.getNodeChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
                childIds[j] = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
                secChild = new AssocChild(childIds[j], "cm:contains");
                this.post(this.getNodeSecondaryChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            }
            int skipCount = 0;
            int maxItems = 100;
            paging = this.getPaging(skipCount, maxItems);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f3Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)n2, (long)nodes.size());
            PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)n2, (long)expectedPaging.getCount().intValue());
            Assert.assertEquals((long)skipCount, (long)expectedPaging.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems, (long)expectedPaging.getMaxItems().intValue());
            Assert.assertFalse((boolean)expectedPaging.getHasMoreItems());
            skipCount = 1;
            maxItems = 3;
            paging = this.getPaging(skipCount, maxItems);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f3Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)maxItems, (long)nodes.size());
            Assert.assertEquals((Object)childIds[1], (Object)nodes.get(0).getId());
            Assert.assertEquals((Object)childIds[2], (Object)nodes.get(1).getId());
            Assert.assertEquals((Object)childIds[3], (Object)nodes.get(2).getId());
            expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)maxItems, (long)expectedPaging.getCount().intValue());
            Assert.assertEquals((long)skipCount, (long)expectedPaging.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems, (long)expectedPaging.getMaxItems().intValue());
            Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
            String string = "child with many parents";
            n = new Node();
            n.setName(string);
            n.setNodeType("cm:content");
            response = this.post(this.getNodeChildrenUrl(f4Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
            String childId = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
            paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeParentsUrl(childId), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f4Id, (Object)nodes.get(0).getId());
            int parentCnt = 5;
            String[] parentIds = new String[parentCnt];
            for (int j = 0; j < parentCnt; ++j) {
                String parentName = "parent " + j;
                parentIds[j] = this.createFolder(f4Id, parentName).getId();
                secChild = new AssocChild(childId, "cm:contains");
                this.post(this.getNodeSecondaryChildrenUrl(parentIds[j]), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            }
            int skipCount2 = 0;
            int maxItems2 = 100;
            int expectedCnt = parentCnt + 1;
            paging = this.getPaging(skipCount2, maxItems2);
            response = this.getAll(this.getNodeParentsUrl(childId), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)expectedCnt, (long)nodes.size());
            PublicApiClient.ExpectedPaging expectedPaging2 = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)expectedCnt, (long)expectedPaging2.getCount().intValue());
            Assert.assertEquals((long)skipCount2, (long)expectedPaging2.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getMaxItems().intValue());
            Assert.assertFalse((boolean)expectedPaging2.getHasMoreItems());
            params = new HashMap(1);
            params.put("where", "(isPrimary=false)");
            ArrayList<String> expectedIds = new ArrayList<String>(5);
            expectedIds.addAll(Arrays.asList(parentIds));
            skipCount2 = 0;
            maxItems2 = 2;
            paging = this.getPaging(skipCount2, maxItems2);
            response = this.getAll(this.getNodeParentsUrl(childId), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)maxItems2, (long)nodes.size());
            for (Node node : nodes) {
                expectedIds.remove(node.getId());
            }
            Assert.assertEquals((long)3L, (long)expectedIds.size());
            expectedPaging2 = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getCount().intValue());
            Assert.assertEquals((long)skipCount2, (long)expectedPaging2.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getMaxItems().intValue());
            Assert.assertTrue((boolean)expectedPaging2.getHasMoreItems());
            skipCount2 = 2;
            maxItems2 = 2;
            paging = this.getPaging(skipCount2, maxItems2);
            response = this.getAll(this.getNodeParentsUrl(childId), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)maxItems2, (long)nodes.size());
            for (Node node : nodes) {
                expectedIds.remove(node.getId());
            }
            Assert.assertEquals((long)1L, (long)expectedIds.size());
            expectedPaging2 = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getCount().intValue());
            Assert.assertEquals((long)skipCount2, (long)expectedPaging2.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getMaxItems().intValue());
            Assert.assertTrue((boolean)expectedPaging2.getHasMoreItems());
            skipCount2 = 4;
            maxItems2 = 2;
            paging = this.getPaging(skipCount2, maxItems2);
            response = this.getAll(this.getNodeParentsUrl(childId), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            for (Node node : nodes) {
                expectedIds.remove(node.getId());
            }
            Assert.assertEquals((long)0L, (long)expectedIds.size());
            expectedPaging2 = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)1L, (long)expectedPaging2.getCount().intValue());
            Assert.assertEquals((long)skipCount2, (long)expectedPaging2.getSkipCount().intValue());
            Assert.assertEquals((long)maxItems2, (long)expectedPaging2.getMaxItems().intValue());
            Assert.assertFalse((boolean)expectedPaging2.getHasMoreItems());
            this.setRequestContext(null);
            secChild = new AssocChild(o2Id, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 401);
            this.setRequestContext(user1);
            secChild = new AssocChild(o2Id, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(o1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 422);
            secChild = new AssocChild(o2Id, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 409);
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, null, 204);
            secChild = new AssocChild(o2Id, "cm:unknowntype");
            this.post(this.getNodeSecondaryChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(secChild), 400);
            this.setRequestContext(null);
            this.getAll(this.getNodeSecondaryChildrenUrl(f1Id), paging, null, 401);
            this.getAll(this.getNodeParentsUrl(o2Id), paging, null, 401);
            this.setRequestContext(user1);
            this.getAll(this.getNodeSecondaryChildrenUrl(UUID.randomUUID().toString()), paging, null, 404);
            this.getAll(this.getNodeParentsUrl(UUID.randomUUID().toString()), paging, null, 404);
            params = new HashMap(1);
            params.put("where", "(assocType='cm:unknownassoctype')");
            this.getAll(this.getNodeSecondaryChildrenUrl(o1Id), paging, params, 400);
            this.getAll(this.getNodeParentsUrl(o1Id), paging, params, 400);
            this.setRequestContext(null);
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, null, 401);
            this.setRequestContext(user1);
            this.delete(this.getNodeSecondaryChildrenUrl(UUID.randomUUID().toString()), o2Id, null, 404);
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), UUID.randomUUID().toString(), null, 404);
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, null, 404);
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:preferenceImage");
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o2Id, params, 404);
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:unknowntype");
            this.delete(this.getNodeSecondaryChildrenUrl(o1Id), o2Id, params, 400);
            params = new HashMap(1);
            params.put(PARAM_ASSOC_TYPE, "cm:contains");
            this.delete(this.getNodeSecondaryChildrenUrl(f1Id), o1Id, params, 400);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
            this.deleteNode(f2Id, true, 204);
            this.deleteNode(f3Id, true, 204);
            this.deleteNode(f4Id, true, 204);
        }
    }

    @Test
    public void testListChildrenConsistentParentIdWithSecondaryAssociations() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String primaryFolderName = "primary folder " + this.RUNID;
        String primaryFolderId = this.createFolder(myNodeId, primaryFolderName, null).getId();
        String contentFileName = "content" + this.RUNID + " in folder";
        String contentId = this.createTextFile(primaryFolderId, contentFileName, "The quick brown fox jumps over the lazy dog.").getId();
        Node n = new Node();
        n.setName("secondary folder " + this.RUNID);
        n.setNodeType("cm:folder");
        n.setAspectNames(Arrays.asList("cm:preferences"));
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String secondaryFolderId = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        AssocChild secChild = new AssocChild(contentId, "cm:contains");
        this.post(this.getNodeSecondaryChildrenUrl(secondaryFolderId), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        Map<String, String> orderBy = Collections.singletonMap("orderBy", "isFolder DESC,modifiedAt DESC");
        String primaryChildrenUrl = this.getNodeChildrenUrl(primaryFolderId);
        response = this.getAll(primaryChildrenUrl, paging, orderBy, 200);
        List<Document> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Document node = nodes.get(0);
        Assert.assertEquals((Object)contentId, (Object)node.getId());
        Assert.assertEquals((Object)primaryFolderId, (Object)node.getParentId());
        String secondaryChildrenUrl = this.getNodeChildrenUrl(secondaryFolderId);
        response = this.getAll(secondaryChildrenUrl, paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        node = nodes.get(0);
        Assert.assertEquals((Object)contentId, (Object)node.getId());
        Assert.assertEquals((Object)primaryFolderId, (Object)node.getParentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndRestoreNodeWithAssocs() throws Exception {
        this.setRequestContext(user1);
        String f1Id = null;
        String f2Id = null;
        String f3Id = null;
        try {
            String myFolderNodeId = this.getMyNodeId();
            f1Id = this.createFolder(myFolderNodeId, "f1").getId();
            String f1bId = this.createFolder(f1Id, "f1b").getId();
            String f1cId = this.createFolder(f1bId, "f1c").getId();
            String f1dId = this.createFolder(f1cId, "f1d").getId();
            String c1eId = this.createTextFile(f1dId, "c1e", "some text content").getId();
            f2Id = this.createFolder(myFolderNodeId, "f2").getId();
            f3Id = this.createFolder(myFolderNodeId, "f3").getId();
            HttpResponse response = this.getAll(this.getNodeParentsUrl(f1bId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1Id, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeParentsUrl(f1dId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1cId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeSourcesUrl(c1eId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            AssocChild secChild = new AssocChild(f1bId, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(f1bId, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(f1dId, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(f1dId, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            secChild = new AssocChild(f1dId, "cm:contains");
            this.post(this.getNodeSecondaryChildrenUrl(f1bId), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
            AssocTarget tgt = new AssocTarget(c1eId, ASSOC_TYPE_CM_REFERENCES);
            this.post(this.getNodeTargetsUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            tgt = new AssocTarget(c1eId, ASSOC_TYPE_CM_PARTS);
            this.post(this.getNodeTargetsUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            tgt = new AssocTarget(c1eId, ASSOC_TYPE_CM_PARTS);
            this.post(this.getNodeTargetsUrl(f1cId), RestApiUtil.toJsonAsStringNonNull(tgt), 201);
            response = this.getAll(this.getNodeParentsUrl(f1bId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)3L, (long)nodes.size());
            response = this.getAll(this.getNodeParentsUrl(f1dId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)4L, (long)nodes.size());
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f2Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            List<String> nodeIds = Arrays.asList(nodes.get(0).getId(), nodes.get(1).getId());
            Assert.assertTrue((boolean)nodeIds.contains(f1bId));
            Assert.assertTrue((boolean)nodeIds.contains(f1dId));
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f3Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            nodeIds = Arrays.asList(nodes.get(0).getId(), nodes.get(1).getId());
            Assert.assertTrue((boolean)nodeIds.contains(f1bId));
            Assert.assertTrue((boolean)nodeIds.contains(f1dId));
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f1bId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1dId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeSourcesUrl(c1eId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)3L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(f2Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)c1eId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeTargetsUrl(f3Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)c1eId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeTargetsUrl(f1cId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)c1eId, (Object)nodes.get(0).getId());
            this.deleteNode(f1bId);
            this.getSingle(NodesEntityResource.class, f1bId, null, 404);
            response = this.getAll(this.getNodeTargetsUrl(f2Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(f3Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            this.post("deleted-nodes/" + f1bId + "/restore", null, null, 200);
            response = this.getSingle(NodesEntityResource.class, f1bId, null, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)f1Id, (Object)nodeResp.getParentId());
            response = this.getSingle(NodesEntityResource.class, f1cId, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)f1bId, (Object)nodeResp.getParentId());
            response = this.getSingle(NodesEntityResource.class, f1dId, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)f1cId, (Object)nodeResp.getParentId());
            response = this.getAll(this.getNodeParentsUrl(f1bId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1Id, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeParentsUrl(f1cId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1bId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeParentsUrl(f1dId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)f1cId, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f2Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f3Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeSourcesUrl(c1eId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(f1cId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(f2Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeTargetsUrl(f3Id), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
        }
        catch (Throwable throwable) {
            this.setRequestContext(user1);
            if (f1Id != null) {
                this.deleteNode(f1Id, true, 204);
            }
            if (f2Id != null) {
                this.deleteNode(f2Id, true, 204);
            }
            if (f3Id != null) {
                this.deleteNode(f3Id, true, 204);
            }
            throw throwable;
        }
        this.setRequestContext(user1);
        if (f1Id != null) {
            this.deleteNode(f1Id, true, 204);
        }
        if (f2Id != null) {
            this.deleteNode(f2Id, true, 204);
        }
        if (f3Id != null) {
            this.deleteNode(f3Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNodeWithAssocs() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        Node n = new Node();
        n.setName("f1");
        n.setNodeType("cm:folder");
        n.setAspectNames(Arrays.asList("cm:preferences"));
        HttpResponse response = this.post(this.getNodeChildrenUrl(myFolderNodeId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String f1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String o1Name = "o1";
        n = new Node();
        n.setName(o1Name);
        n.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String o2Name = "o2";
        n = new Node();
        n.setName(o2Name);
        n.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String o2Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String f2Name = "f2";
        n = new Node();
        n.setName(f2Name);
        n.setNodeType("cm:folder");
        AssocChild secChild = new AssocChild(o1Id, "cm:contains");
        n.setSecondaryChildren(Collections.singletonList(secChild));
        AssocTarget tgt = new AssocTarget(o2Id, ASSOC_TYPE_CM_REFERENCES);
        n.setTargets(Collections.singletonList(tgt));
        response = this.post(this.getNodeChildrenUrl(myFolderNodeId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        String f2Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
        String f3Id = this.createFolder(myFolderNodeId, "f3").getId();
        try {
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeSecondaryChildrenUrl(f2Id), paging, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o1Id, (Object)nodes.get(0).getId());
            response = this.getAll(this.getNodeTargetsUrl(f2Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)o2Id, (Object)nodes.get(0).getId());
            n = new Node();
            n.setName("my-folder");
            n.setNodeType("cm:folder");
            AssocChild assocChild = new AssocChild(myFolderNodeId, "cm:contains");
            n.setSecondaryChildren(Collections.singletonList(assocChild));
            this.post(this.getNodeChildrenUrl(myFolderNodeId), RestApiUtil.toJsonAsStringNonNull(n), 400);
            n = new Node();
            n.setName("my-folder");
            n.setNodeType("cm:folder");
            assocChild = new AssocChild(null, "cm:contains");
            n.setSecondaryChildren(Collections.singletonList(assocChild));
            this.post(this.getNodeChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(n), 400);
            n = new Node();
            n.setName("my-folder");
            n.setNodeType("cm:folder");
            assocChild = new AssocChild(f2Id, null);
            n.setSecondaryChildren(Collections.singletonList(assocChild));
            this.post(this.getNodeChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(n), 400);
            n = new Node();
            n.setName("my-folder");
            n.setNodeType("cm:folder");
            tgt = new AssocTarget(null, ASSOC_TYPE_CM_REFERENCES);
            n.setTargets(Collections.singletonList(tgt));
            this.post(this.getNodeChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(n), 400);
            n = new Node();
            n.setName("my-folder");
            n.setNodeType("cm:folder");
            tgt = new AssocTarget(f2Id, null);
            n.setTargets(Collections.singletonList(tgt));
            this.post(this.getNodeChildrenUrl(f3Id), RestApiUtil.toJsonAsStringNonNull(n), 400);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
            this.deleteNode(f2Id, true, 204);
            this.deleteNode(f3Id, true, 204);
        }
    }

    @Override
    public String getScope() {
        return "public";
    }
}

