/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.subscriptions;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PrivateSubscriptionListException;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.cmr.subscriptions.SubscriptionsDisabledException;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ISO8601DateFormat;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public abstract class AbstractSubscriptionServiceWebScript
extends AbstractWebScript {
    protected SubscriptionService subscriptionService;
    protected NodeService nodeService;
    protected PersonService personService;

    public void setSubscriptionService(SubscriptionService subscriptionService) {
        this.subscriptionService = subscriptionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        if (!this.subscriptionService.isActive()) {
            res.setStatus(404);
            return;
        }
        try {
            String userId = (String)req.getServiceMatch().getTemplateVars().get("userid");
            Object obj = this.executeImpl(userId, req, res);
            if (obj instanceof JSONObject || obj instanceof JSONArray) {
                res.setContentEncoding(Charset.defaultCharset().displayName());
                res.setContentType(Format.JSON.mimetype() + ";charset=UTF-8");
                Writer writer = res.getWriter();
                if (obj instanceof JSONObject) {
                    ((JSONObject)obj).writeJSONString(writer);
                } else {
                    ((JSONArray)obj).writeJSONString(writer);
                }
                writer.flush();
            } else {
                res.setStatus(204);
            }
        }
        catch (SubscriptionsDisabledException sde) {
            throw new WebScriptException(404, "Subscription service is disabled!", (Throwable)sde);
        }
        catch (NoSuchPersonException nspe) {
            throw new WebScriptException(404, "Unknown user '" + nspe.getUserName() + "'!", (Throwable)nspe);
        }
        catch (PrivateSubscriptionListException psle) {
            throw new WebScriptException(403, "Subscription list is private!", (Throwable)psle);
        }
        catch (ParseException pe) {
            throw new WebScriptException(400, "Unable to parse JSON!", (Throwable)pe);
        }
        catch (ClassCastException cce) {
            throw new WebScriptException(400, "Unable to parse JSON!", (Throwable)cce);
        }
        catch (IOException ioe) {
            throw new WebScriptException(500, "Unable to serialize JSON!", (Throwable)ioe);
        }
    }

    public abstract Object executeImpl(String var1, WebScriptRequest var2, WebScriptResponse var3) throws IOException, ParseException;

    protected int parseNumber(String name, String number, int def) {
        if (number != null && number.length() > 0) {
            try {
                return Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, name + " is not a number!", (Throwable)e);
            }
        }
        return def;
    }

    protected PagingRequest createPagingRequest(WebScriptRequest req) {
        int skipCount = this.parseNumber("skipCount", req.getParameter("skipCount"), 0);
        int maxItems = this.parseNumber("maxItems", req.getParameter("maxItems"), -1);
        PagingRequest result = new PagingRequest(skipCount, maxItems, null);
        result.setRequestTotalCountMax(Integer.MAX_VALUE);
        return result;
    }

    protected JSONObject getUserDetails(String username) {
        List assocRefs;
        Date statusTime;
        NodeRef node = this.personService.getPerson(username);
        JSONObject result = new JSONObject();
        result.put((Object)"userName", (Object)username);
        result.put((Object)"firstName", (Object)this.nodeService.getProperty(node, ContentModel.PROP_FIRSTNAME));
        result.put((Object)"lastName", (Object)this.nodeService.getProperty(node, ContentModel.PROP_LASTNAME));
        result.put((Object)"jobtitle", (Object)this.nodeService.getProperty(node, ContentModel.PROP_JOBTITLE));
        result.put((Object)"organization", (Object)this.nodeService.getProperty(node, ContentModel.PROP_ORGANIZATION));
        String status = (String)((Object)this.nodeService.getProperty(node, ContentModel.PROP_USER_STATUS));
        if (status != null) {
            result.put((Object)"userStatus", (Object)status);
        }
        if ((statusTime = (Date)this.nodeService.getProperty(node, ContentModel.PROP_USER_STATUS_TIME)) != null) {
            JSONObject statusTimeJson = new JSONObject();
            statusTimeJson.put((Object)"iso8601", (Object)ISO8601DateFormat.format((Date)statusTime));
            result.put((Object)"userStatusTime", (Object)statusTimeJson);
        }
        if (!(assocRefs = this.nodeService.getTargetAssocs(node, (QNamePattern)ContentModel.ASSOC_AVATAR)).isEmpty()) {
            NodeRef avatarNodeRef = ((AssociationRef)assocRefs.get(0)).getTargetRef();
            result.put((Object)"avatar", (Object)avatarNodeRef.toString());
        } else {
            result.put((Object)"avatar", (Object)"avatar");
        }
        return result;
    }

    protected JSONArray getUserArray(List<String> usernames) {
        JSONArray result = new JSONArray();
        if (usernames != null) {
            for (String username : usernames) {
                result.add((Object)this.getUserDetails(username));
            }
        }
        return result;
    }
}

