/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.opencmis.AlfrescoCmisServiceImpl;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.tenant.Network;
import org.alfresco.repo.tenant.NetworksService;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.util.FileFilterMode;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class PublicApiAlfrescoCmisService
extends AlfrescoCmisServiceImpl {
    protected CMISConnector connector;
    protected TenantAdminService tenantAdminService;
    protected NetworksService networksService;

    public PublicApiAlfrescoCmisService(CMISConnector connector, TenantAdminService tenantAdminService, NetworksService networksService) {
        super(connector);
        this.connector = connector;
        this.networksService = networksService;
        this.tenantAdminService = tenantAdminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            String string = super.create(repositoryId, properties, folderId, contentStream, versioningState, policies, extension);
            return string;
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        String newId = super.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            super.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        PagingResults networks = this.networksService.getNetworks(new PagingRequest(0, Integer.MAX_VALUE));
        List page = networks.getPage();
        ArrayList<RepositoryInfo> repoInfos = new ArrayList<RepositoryInfo>(page.size() + 1);
        for (Network network : page) {
            repoInfos.add(this.getRepositoryInfo(network));
        }
        return repoInfos;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        Network network = null;
        try {
            this.checkRepositoryId(repositoryId);
            network = this.networksService.getNetwork(repositoryId);
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
        return this.getRepositoryInfo(network);
    }

    private RepositoryInfo getRepositoryInfo(Network network) {
        final String networkId = network.getTenantDomain();
        final String tenantDomain = networkId.equals("-system-") || networkId.equals("-default-") ? "" : networkId;
        return (RepositoryInfo)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepositoryInfo>(){

            public RepositoryInfo doWork() {
                RepositoryInfoImpl repoInfo = (RepositoryInfoImpl)PublicApiAlfrescoCmisService.this.connector.getRepositoryInfo(PublicApiAlfrescoCmisService.this.getContext().getCmisVersion());
                repoInfo.setId(!networkId.equals("") ? networkId : "-system-");
                repoInfo.setName(tenantDomain);
                repoInfo.setDescription(tenantDomain);
                return repoInfo;
            }
        }, (String)tenantDomain);
    }

    public void checkRepositoryId(String repositoryId) {
        if (repositoryId.equals("-default-") || repositoryId.equals("-system-")) {
            return;
        }
        if (!this.tenantAdminService.existsTenant(repositoryId) || !this.tenantAdminService.isEnabledTenant(repositoryId)) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
    }

    public void beforeCall() {
    }

    public void afterCall() {
    }

    public void close() {
        super.close();
    }
}

