/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.api.RuleSets;
import org.alfresco.rest.api.model.rules.RuleSetLink;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="rule-set-links", entityResource=NodesEntityResource.class, title="Rule set links")
public class NodeRuleSetLinksRelation
implements InitializingBean,
RelationshipResourceAction.Create<RuleSetLink>,
RelationshipResourceAction.Delete {
    private final RuleSets ruleSets;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"ruleSets", (Object)this.ruleSets);
    }

    @Override
    @WebApiParam(name="ruleSetLinkRequest", title="Request body - rule set id", description="Request body with rule set id", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Link a rule set to a folder node", description="Submits a request to link a rule set to folder", successStatus=201)
    public List<RuleSetLink> create(String nodeId, List<RuleSetLink> ruleSetLinksBody, Parameters parameters) {
        return ruleSetLinksBody.stream().map(r -> this.ruleSets.linkToRuleSet(nodeId, r.getId())).collect(Collectors.toList());
    }

    @Override
    @WebApiDescription(title="Remove link between a rule set and a folder node", description="Submits a request to unlink a rule set from a folder", successStatus=204)
    public void delete(String folderNodeId, String ruleSetNodeId, Parameters parameters) {
        this.ruleSets.unlinkRuleSet(folderNodeId, ruleSetNodeId);
    }

    public NodeRuleSetLinksRelation(RuleSets ruleSets) {
        this.ruleSets = ruleSets;
    }
}

