/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.site.AbstractSiteServiceTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={LuceneTests.class})
public class SiteServiceTest
extends AbstractSiteServiceTest {
    private SiteService siteService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private FileFolderService fileFolderService;
    private static final String USER_ONE = "SiteTestOne";
    private static final String USER_TWO = "SiteTestTwo";
    private static final String USER_THREE = "SiteTestThree";
    private static final String USER_NUMERIC = "1234567890";
    private static final String USER_FOUR_AS_SITE_ADMIN = "SiteAdmin";
    private static final String URL_SITES = "/api/sites";
    private static final String URL_SITES_QUERY = "/api/sites/query";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private static final String URL_SITES_ADMIN = "/api/admin-sites";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.permissionService = (PermissionService)this.getServer().getApplicationContext().getBean("PermissionService");
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.createUser(USER_NUMERIC);
        this.createUser(USER_FOUR_AS_SITE_ADMIN);
        this.authorityService.addAuthority("GROUP_SITE_ADMINISTRATORS", USER_FOUR_AS_SITE_ADMIN);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteUser(USER_NUMERIC);
        this.deleteUser(USER_FOUR_AS_SITE_ADMIN);
        this.deleteSites();
    }

    public void testCreateSite() throws Exception {
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        SiteServiceTest.assertEquals((Object)"myPreset", (Object)result.get("sitePreset"));
        SiteServiceTest.assertEquals((Object)shortName, (Object)result.get("shortName"));
        SiteServiceTest.assertEquals((Object)"myTitle", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"myDescription", (Object)result.get("description"));
        SiteServiceTest.assertNotNull((Object)result.get("node"));
        SiteServiceTest.assertNotNull((Object)result.get("tagScope"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)result.get("visibility"));
        SiteServiceTest.assertTrue((boolean)result.getBoolean("isPublic"));
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 400);
    }

    public void testGetSites() throws Exception {
        JSONArray result;
        TestWebScriptServer.Response response;
        int preexistingSiteCount = 0;
        try {
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES), 200);
            result = new JSONArray(response.getContentAsString());
            SiteServiceTest.assertNotNull((Object)result);
            preexistingSiteCount = result.length();
        }
        catch (AssertionFailedError e) {
            SiteServiceTest.assertEquals((int)0, (int)preexistingSiteCount);
        }
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((String)"Wrong site count", (int)(preexistingSiteCount + 5), (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites?size=3"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((String)"Wrong site count (?size=3)", (int)3, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites?size=13"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((String)"Wrong site count (?size=13)", (int)Math.min(13, preexistingSiteCount + 5), (int)result.length());
    }

    public void testQuerySites() throws Exception {
        String[] shortNames = new String[]{GUID.generate(), GUID.generate(), GUID.generate(), GUID.generate(), GUID.generate()};
        this.createSite("myPreset", shortNames[0], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[1], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[2], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[3], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[4], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject shortNameQuery = new JSONObject();
        shortNameQuery.put("match", (Object)"exact");
        JSONArray valuesArray = new JSONArray();
        valuesArray.put(0, (Object)shortNames[0]);
        valuesArray.put(1, (Object)shortNames[2]);
        valuesArray.put(2, (Object)shortNames[4]);
        valuesArray.put(3, (Object)"bobbins");
        shortNameQuery.put("values", (Object)valuesArray);
        JSONObject query = new JSONObject();
        query.put("shortName", (Object)shortNameQuery);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES_QUERY, query.toString(), "application/json"), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertEquals((int)3, (int)result.length());
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < result.length(); ++i) {
            resultSet.add((String)result.getJSONObject(i).get("shortName"));
        }
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[0]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains(shortNames[1]));
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[2]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains(shortNames[3]));
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[4]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains("bobbins"));
        JSONObject site = result.getJSONObject(0);
        SiteServiceTest.assertNotNull((Object)site);
        SiteServiceTest.assertEquals((Object)"myPreset", (Object)site.get("sitePreset"));
        SiteServiceTest.assertEquals((Object)"myTitle", (Object)site.get("title"));
        SiteServiceTest.assertEquals((Object)"myDescription", (Object)site.get("description"));
        SiteServiceTest.assertNotNull((Object)site.get("node"));
        SiteServiceTest.assertNotNull((Object)site.get("tagScope"));
        SiteServiceTest.assertTrue((boolean)site.getBoolean("isPublic"));
    }

    public void testGetSite() throws Exception {
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/somerandomshortname"), 404);
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
    }

    public void testUpdateSite() throws Exception {
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        result.put("title", (Object)"abs123abc");
        result.put("description", (Object)"123abc123");
        result.put("visibility", (Object)SiteVisibility.PRIVATE.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, result.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"abs123abc", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"123abc123", (Object)result.get("description"));
        SiteServiceTest.assertFalse((boolean)result.getBoolean("isPublic"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"abs123abc", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"123abc123", (Object)result.get("description"));
        SiteServiceTest.assertFalse((boolean)result.getBoolean("isPublic"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
    }

    public void testDeleteSite() throws Exception {
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/somerandomshortname"), 404);
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 404);
    }

    public void testGetMemberships() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)1, (int)result.length());
        JSONObject membership = result.getJSONObject(0);
        SiteServiceTest.assertEquals((Object)"SiteManager", (Object)membership.get("role"));
        SiteServiceTest.assertEquals((Object)USER_ONE, (Object)membership.getJSONObject("authority").get("userName"));
    }

    public void testPostMemberships() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        SiteServiceTest.assertEquals((Object)"SiteConsumer", (Object)membership.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)membership.getJSONObject("person").get("userName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray result2 = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result2);
        SiteServiceTest.assertEquals((int)2, (int)result2.length());
        membership = new JSONObject();
        membership.put("role", (Object)"SiteContributor");
        person = new JSONObject();
        person.put("userName", (Object)USER_NUMERIC);
        membership.put("person", (Object)person);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        membership = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteContributor", (Object)membership.get("role"));
        SiteServiceTest.assertEquals((Object)USER_NUMERIC, (Object)membership.getJSONObject("authority").get("userName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        String json = response.getContentAsString();
        JSONArray result3 = new JSONArray(json);
        SiteServiceTest.assertNotNull((Object)result3);
        SiteServiceTest.assertEquals((int)3, (int)result3.length());
        HashMap<String, JSONObject> membershipMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < membership.length(); ++i) {
            membershipMap.put(result3.getJSONObject(i).getString("role"), result3.getJSONObject(i));
        }
        membership = (JSONObject)membershipMap.get("SiteManager");
        SiteServiceTest.assertNotNull((String)"The response did not contain SiteManager", (Object)membership);
        SiteServiceTest.assertEquals((Object)USER_ONE, (Object)membership.getJSONObject("authority").get("userName"));
        membership = (JSONObject)membershipMap.get("SiteConsumer");
        SiteServiceTest.assertNotNull((String)"The response did not contain SiteConsumer", (Object)membership);
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)membership.getJSONObject("authority").get("userName"));
        membership = (JSONObject)membershipMap.get("SiteContributor");
        SiteServiceTest.assertNotNull((String)"The response did not contain SiteContributor", (Object)membership);
        SiteServiceTest.assertEquals((Object)USER_NUMERIC, (Object)membership.getJSONObject("authority").get("userName"));
    }

    public void testGetMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/badsite/memberships/SiteTestOne"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/baduser"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 404);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/SiteTestOne"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteManager", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_ONE, (Object)result.getJSONObject("authority").get("userName"));
    }

    public void testPutMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject newMember = new JSONObject(response.getContentAsString());
        newMember.put("role", (Object)"SiteCollaborator");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, newMember.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteCollaborator", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)result.getJSONObject("authority").get("userName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteCollaborator", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)result.getJSONObject("authority").get("userName"));
    }

    public void testGroupMembership() throws Exception {
        String testGroup = "SiteServiceTestGroupA";
        Object testGroupName = "GROUP_" + testGroup;
        if (!this.authorityService.authorityExists((String)testGroupName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            testGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, testGroup, testGroup, this.authorityService.getDefaultZones());
        }
        this.authenticationComponent.setCurrentUser(USER_ONE);
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject group = new JSONObject();
        group.put("fullName", testGroupName);
        membership.put("group", (Object)group);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject newMember = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((String)"role not correct", (String)"SiteConsumer", (String)newMember.getString("role"));
        JSONObject newGroup = newMember.getJSONObject("authority");
        SiteServiceTest.assertNotNull((Object)"newGroup");
        SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)newGroup.getString("fullName"));
        SiteServiceTest.assertEquals((String)"authorityType not correct", (String)"GROUP", (String)newGroup.getString("authorityType"));
        newMember.put("role", (Object)"SiteCollaborator");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, newMember.toString(), "application/json"), 200);
        JSONObject updateResult = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((String)"role not correct", (String)"SiteCollaborator", (String)updateResult.getString("role"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray listResult = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertTrue((String)"result too small", (listResult.length() >= 2 ? 1 : 0) != 0);
        for (int i = 0; i < listResult.length(); ++i) {
            JSONObject obj = listResult.getJSONObject(i);
            JSONObject authority = obj.getJSONObject("authority");
            if (authority.getString("authorityType").equals("GROUP")) {
                SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)authority.getString("fullName"));
            }
            if (!authority.getString("authorityType").equals("USER")) continue;
            SiteServiceTest.assertEquals((String)"full name not correct", (String)USER_ONE, (String)authority.getString("fullName"));
        }
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/" + (String)testGroupName), 200);
        JSONObject getResult = new JSONObject(response.getContentAsString());
        System.out.println(response.getContentAsString());
        JSONObject grp = getResult.getJSONObject("authority");
        SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)grp.getString("fullName"));
        if (this.authorityService.authorityExists((String)testGroupName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.authorityService.deleteAuthority((String)testGroupName);
        }
    }

    public void testDeleteMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 404);
    }

    public void testGetPersonSites() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String shortName2 = GUID.generate();
        this.createSite("myPreset", shortName2, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestTwo/sites"), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)0, (int)result.length());
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName2 + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestTwo/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestThree/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)0, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites?size=1"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)1, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites?size=5"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
    }

    public void testGetPotentialMemberships() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String filter = "";
        String authorityType = "GROUP";
        String url = "/api/sites/" + shortName + "/potentialmembers?filter=" + filter + "&amp;maxResults=10&amp;authorityType=" + authorityType;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String contentAsString = response.getContentAsString();
        JSONObject result = new JSONObject(contentAsString);
        SiteServiceTest.assertNotNull((Object)result);
        JSONArray people = result.getJSONArray("people");
        SiteServiceTest.assertNotNull((String)"people array was null", (Object)people);
        JSONArray data = result.getJSONArray("data");
        SiteServiceTest.assertNotNull((String)"data array was null", (Object)data);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 200);
    }

    public void testSiteCustomProperties() throws Exception {
        QName custPropSingle = QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation");
        QName custPropMuliple = QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"siteTags");
        SiteInfo siteInfo = this.siteService.createSite("testPreset", "mySiteWithCustomProperty2", "testTitle", "testDescription", SiteVisibility.PUBLIC);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, Object> properties = new HashMap<QName, Object>(1);
        properties.put(custPropSingle, "information");
        properties.put(custPropMuliple, (Serializable)((Object)Arrays.asList("tag1", "tag2", "tag333")));
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        this.createdSites.add("mySiteWithCustomProperty2");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/mySiteWithCustomProperty2"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        JSONObject customProperties = result.getJSONObject("customProperties");
        SiteServiceTest.assertNotNull((Object)customProperties);
        JSONObject addInfo = customProperties.getJSONObject("{http://www.alfresco.org/model/sitecustomproperty/1.0}additionalInformation");
        SiteServiceTest.assertNotNull((Object)addInfo);
        SiteServiceTest.assertEquals((Object)"{http://www.alfresco.org/model/sitecustomproperty/1.0}additionalInformation", (Object)addInfo.get("name"));
        SiteServiceTest.assertEquals((Object)"information", (Object)addInfo.get("value"));
        SiteServiceTest.assertEquals((Object)"{http://www.alfresco.org/model/dictionary/1.0}text", (Object)addInfo.get("type"));
        SiteServiceTest.assertEquals((Object)"Additional Site Information", (Object)addInfo.get("title"));
        JSONObject tags = customProperties.getJSONObject("{http://www.alfresco.org/model/sitecustomproperty/1.0}siteTags");
        SiteServiceTest.assertNotNull((Object)tags);
        SiteServiceTest.assertEquals((Object)"{http://www.alfresco.org/model/sitecustomproperty/1.0}siteTags", (Object)tags.get("name"));
        SiteServiceTest.assertEquals((Object)JSONObject.NULL, (Object)tags.get("type"));
        SiteServiceTest.assertEquals((Object)JSONObject.NULL, (Object)tags.get("title"));
        System.err.println(response.getContentAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckPermissionsAfterCopy() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        String groupName = AuthorityType.GROUP.getPrefixString() + "_" + GUID.generate().substring(0, 5).trim();
        String createdAuth = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
        NodeRef fileNode = null;
        NodeRef siteDocLib = null;
        NodeRef copiedNode = null;
        NodeRef movedNode = null;
        try {
            fileNode = this.createRepoFile();
            siteDocLib = this.createTestSite();
            this.addPermissionsToFile(fileNode, createdAuth, "SiteContributor", true);
            this.checkPermissions(fileNode, createdAuth, "SiteContributor", "before copy");
            copiedNode = this.copyToSite(fileNode, siteDocLib);
            this.checkPermissions(copiedNode, createdAuth, "SiteContributor", "after copy");
            this.nodeService.deleteNode(copiedNode);
            copiedNode = null;
            this.checkPermissions(fileNode, createdAuth, "SiteContributor", "before move");
            movedNode = this.moveToSite(fileNode, siteDocLib);
            this.checkPermissions(movedNode, createdAuth, "SiteContributor", "after move");
        }
        finally {
            if (fileNode != null) {
                this.nodeService.deleteNode(fileNode);
            }
            if (siteDocLib != null) {
                this.nodeService.deleteNode(siteDocLib);
            }
            AuthenticationUtil.popAuthentication();
        }
    }

    private NodeRef copyToSite(NodeRef fileRef, NodeRef destRef) throws Exception {
        FileInfo copiedFileInfo = this.fileFolderService.copy(fileRef, destRef, null);
        return copiedFileInfo.getNodeRef();
    }

    private NodeRef moveToSite(NodeRef fileRef, NodeRef destRef) throws Exception {
        FileInfo movedFileInfo = this.fileFolderService.move(fileRef, destRef, null);
        return movedFileInfo.getNodeRef();
    }

    private void checkPermissions(NodeRef nodeRef, String necessatyAuth, String expectedPermission, String actionInfo) {
        Set allSetPermissions = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission perm : allSetPermissions) {
            String authority = perm.getAuthority();
            if (!necessatyAuth.equals(authority)) continue;
            if (expectedPermission.equals(perm.getPermission())) {
                return;
            }
            SiteServiceTest.fail((String)("Expected permissions for authority \"" + necessatyAuth + "\" are incorrect. Expected: " + expectedPermission + ", but actual permission: " + perm.getPermission() + ". Check position: " + actionInfo));
        }
        SiteServiceTest.fail((String)("Expected authority \"" + necessatyAuth + "\" wasn't found. Check position: " + actionInfo));
    }

    private void addPermissionsToFile(NodeRef nodeRef, String user, String permission, boolean isAllowed) {
        this.permissionService.setPermission(nodeRef, user, permission, isAllowed);
    }

    private NodeRef createTestSite() {
        String sName = GUID.generate();
        this.siteService.createSite("testSitePreset", sName, sName, sName, SiteVisibility.PUBLIC);
        NodeRef siteContainer = this.siteService.createContainer(sName, "testContainer", ContentModel.TYPE_FOLDER, null);
        return siteContainer;
    }

    private NodeRef createRepoFile() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef workingRootNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
        String fName = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, fName);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)fName));
        ChildAssociationRef assocRef = this.nodeService.createNode(workingRootNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, properties);
        return assocRef.getChildRef();
    }

    public void testInvitationSanityCheck() throws Exception {
        String shortName = GUID.generate();
        String secondShortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", secondShortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteComments = "Please sir, let me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String moderatedId = this.createModeratedInvitation(secondShortName, inviteComments, userName, roleName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + secondShortName + "/invitations/" + moderatedId), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=" + userName), 200);
        String nominatedId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL, 201);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + secondShortName + "/invitations/" + moderatedId), 200);
    }

    public void testGetInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteId = this.createModeratedInvitation(shortName, inviteeComments, userName, roleName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/rubbish/invitations/" + inviteId), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/activiti$8787487"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/trash$123"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/trash123"), 404);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        SiteServiceTest.assertNotNull((String)"data is null", (Object)data);
        SiteServiceTest.assertEquals((String)"inviteId is not set", (String)data.getString("inviteId"), (String)inviteId);
        SiteServiceTest.assertEquals((String)"invitationType", (String)"MODERATED", (String)data.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"inviteeUserName is not set", (String)userName, (String)data.getString("inviteeUserName"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data.getString("resourceType"));
        SiteServiceTest.assertEquals((String)"inviteeComments", (String)inviteeComments, (String)data.getString("inviteeComments"));
        SiteServiceTest.assertEquals((String)"roleName is not set", (String)roleName, (String)data.getString("roleName"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 404);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "FirstName123.LastName123@email.com";
        String inviteeUserName = null;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        inviteId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL, 201);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        JSONObject data2 = top2.getJSONObject("data");
        SiteServiceTest.assertNotNull((String)"data is null", (Object)data2);
        SiteServiceTest.assertEquals((String)"inviteId is not set", (String)data2.getString("inviteId"), (String)inviteId);
        SiteServiceTest.assertEquals((String)"invitationType", (String)"NOMINATED", (String)data2.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data2.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data2.getString("resourceType"));
        SiteServiceTest.assertEquals((String)"roleName is not set", (String)roleName, (String)data2.getString("roleName"));
        SiteServiceTest.assertNotNull((String)"inviteeUserName is not set", (Object)data2.getString("inviteeUserName"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInviteDisabledUser() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String username = "testUser" + System.nanoTime();
        String siteShortName = GUID.generate();
        try {
            this.createUser(username);
            this.createSite("myPreset", siteShortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
            NodeRef personNodeRef = this.personService.getPerson(username);
            String firstName = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_LASTNAME));
            String email = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL));
            String serverPath = "http://localhost:8081/share/";
            String acceptURL = "page/accept-invite";
            String rejectURL = "page/reject-invite";
            this.authenticationService.setAuthenticationEnabled(username, false);
            this.createNominatedInvitation(siteShortName, firstName, lastName, email, username, "SiteConsumer", serverPath, acceptURL, rejectURL, 409);
            SiteServiceTest.fail((String)("The user " + username + " is disabled and cannot be invited"));
        }
        catch (JSONException jSONException) {
        }
        finally {
            this.siteService.deleteSite(siteShortName);
            this.deleteUser(username);
            AuthenticationUtil.popAuthentication();
        }
    }

    public void testListInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String moderatedIdA = this.createModeratedInvitation(shortName, inviteeComments, userName, roleName);
        String inviteeCommentsB = "Please sir, let $* me in";
        String userNameB = USER_THREE;
        String roleNameB = "SiteConsumer";
        String moderatedIdB = this.createModeratedInvitation(shortName, inviteeCommentsB, userNameB, roleNameB);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String nominatedId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL, 201);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=wombat"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user wombat", (int)data.length(), (int)0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=SiteTestTwo"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user two invitation not found", (int)1, (int)data.length());
        JSONObject first = data.getJSONObject(0);
        SiteServiceTest.assertEquals((String)"userid is wrong", (String)first.getString("inviteeUserName"), (String)USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?invitationType=MODERATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"two moderated invitations not found", (int)data.length(), (int)2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?invitationType=Crap"), 500);
        top = new JSONObject(response.getContentAsString());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=SiteTestTwo&invitationType=MODERATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user two invitation not found", (int)data.length(), (int)1);
        first = data.getJSONObject(0);
        SiteServiceTest.assertEquals((String)"first userid is wrong", (String)first.getString("inviteeUserName"), (String)USER_TWO);
        SiteServiceTest.assertEquals((String)"type is wrong", (String)first.getString("invitationType"), (String)"MODERATED");
    }

    public void testCreateInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteComments = "Please sir, let me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteId = null;
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"Grundge");
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)"");
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        inviteId = data.getString("inviteId");
        SiteServiceTest.assertEquals((String)"invitationType", (String)"MODERATED", (String)data.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"inviteeUserName is not set", (String)userName, (String)data.getString("inviteeUserName"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data.getString("resourceType"));
        SiteServiceTest.assertNotNull((String)"inviteId is null", (Object)inviteId);
        SiteServiceTest.assertTrue((String)"inviteId is too small", (inviteId.length() > 0 ? 1 : 0) != 0);
    }

    private String createNominatedInvitation(String siteName, String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, String inviteeRoleName, String serverPath, String acceptURL, String rejectURL, int expectedStatus) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"NOMINATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        if (inviteeUserName != null) {
            newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        } else {
            newInvitation.put("inviteeFirstName", (Object)inviteeFirstName);
            newInvitation.put("inviteeLastName", (Object)inviteeLastName);
            newInvitation.put("inviteeEmail", (Object)inviteeEmail);
        }
        newInvitation.put("serverPath", (Object)serverPath);
        newInvitation.put("acceptURL", (Object)acceptURL);
        newInvitation.put("rejectURL", (Object)rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), expectedStatus);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        return inviteId;
    }

    private String createModeratedInvitation(String siteName, String inviteeComments, String inviteeUserName, String inviteeRoleName) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        newInvitation.put("inviteeComments", (Object)inviteeComments);
        newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        return inviteId;
    }

    public void testGetMemberInfo() throws Exception {
        String testGroup = "SiteServiceTestGroupA";
        Object testGroupName = "GROUP_" + testGroup;
        if (!this.authorityService.authorityExists((String)testGroupName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            testGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, testGroup, testGroup, this.authorityService.getDefaultZones());
        }
        if (!this.authorityService.getContainedAuthorities(AuthorityType.USER, (String)testGroupName, true).contains(USER_TWO)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.authorityService.addAuthority((String)testGroupName, USER_TWO);
        }
        this.authenticationComponent.setCurrentUser(USER_ONE);
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject group = new JSONObject();
        group.put("fullName", testGroupName);
        membership.put("group", (Object)group);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject newMember = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((String)"role not correct", (String)"SiteConsumer", (String)newMember.getString("role"));
        JSONObject newGroup = newMember.getJSONObject("authority");
        SiteServiceTest.assertNotNull((Object)newGroup);
        SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)newGroup.getString("fullName"));
        SiteServiceTest.assertEquals((String)"authorityType not correct", (String)"GROUP", (String)newGroup.getString("authorityType"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/memberships?authorityType=USER"), 200);
        JSONArray listResult = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)listResult);
        SiteServiceTest.assertEquals((int)2, (int)listResult.length());
        for (int i = 0; i < listResult.length(); ++i) {
            JSONObject json = listResult.getJSONObject(i);
            if (USER_ONE.equals(json.getJSONObject("authority").get("fullName"))) {
                SiteServiceTest.assertEquals((String)"user one is Not member of any group", (Object)false, (Object)json.get("isMemberOfGroup"));
                continue;
            }
            SiteServiceTest.assertEquals((String)"full name not correct", (Object)USER_TWO, (Object)json.getJSONObject("authority").get("fullName"));
            SiteServiceTest.assertEquals((String)"user two is member of a SiteServiceTestGroupA group", (Object)true, (Object)json.get("isMemberOfGroup"));
        }
        if (this.authorityService.authorityExists((String)testGroupName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.authorityService.deleteAuthority((String)testGroupName);
        }
    }

    public void testChangeSiteVisibilityAsSiteAdmin() throws Exception {
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        SiteServiceTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)result.get("visibility"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        JSONObject changeVisibility = new JSONObject();
        changeVisibility.put("shortName", (Object)shortName);
        changeVisibility.put("visibility", (Object)"PRIVATE");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, changeVisibility.toString(), "application/json"), 500);
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        SiteServiceTest.assertEquals((String)"Site visibility should not have been changed.", (Object)SiteVisibility.PUBLIC, (Object)siteInfo.getVisibility());
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, changeVisibility.toString(), "application/json"), 200);
        JSONObject jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)jsonObj.get("visibility"));
        changeVisibility.put("visibility", (Object)"MODERATED");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, changeVisibility.toString(), "application/json"), 200);
        jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)SiteVisibility.MODERATED.toString(), (Object)jsonObj.get("visibility"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.authorityService.removeAuthority("GROUP_SITE_ADMINISTRATORS", USER_FOUR_AS_SITE_ADMIN);
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        changeVisibility.put("visibility", (Object)"PUBLIC");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, changeVisibility.toString(), "application/json"), 500);
        siteInfo = this.siteService.getSite(shortName);
        SiteServiceTest.assertEquals((String)"Site visibility should not have been changed.", (Object)SiteVisibility.MODERATED, (Object)siteInfo.getVisibility());
    }

    public void testChangeMembershipRoleAsSiteAdmin() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteConsumer", (Object)jsonObj.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)jsonObj.getJSONObject("authority").get("userName"));
        this.authenticationComponent.setCurrentUser(USER_THREE);
        membership.put("role", (Object)"SiteCollaborator");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 500);
        SiteServiceTest.assertEquals((String)"User's role should not have been changed.", (String)"SiteConsumer".toString(), (String)this.siteService.getMembersRole(shortName, USER_TWO));
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteCollaborator", (Object)jsonObj.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)jsonObj.getJSONObject("authority").get("userName"));
    }

    public void testDeleteMembershipAsSiteAdmin() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteConsumer", (Object)jsonObj.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)jsonObj.getJSONObject("authority").get("userName"));
        this.authenticationComponent.setCurrentUser(USER_THREE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 500);
        SiteServiceTest.assertTrue((String)"SiteTestThree doesn\u2019t have permission to delete users from the site", (boolean)this.siteService.isMember(shortName, USER_TWO));
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/memberships/SiteTestTwo"), 200);
        SiteServiceTest.assertFalse((boolean)this.siteService.isMember(shortName, USER_TWO));
    }

    public void testDeleteSiteAsSiteAdmin() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        this.authenticationComponent.setCurrentUser(USER_THREE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 500);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        JSONObject jsonObj = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)shortName, (Object)jsonObj.get("shortName"));
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 404);
    }

    public void testGetAllSitesAsSiteAdmin() throws Exception {
        String user1PublicSiteName = GUID.generate();
        String user1ModeratedSiteName = GUID.generate();
        String user1PrivateSiteName = GUID.generate();
        String user2PrivateSiteName = GUID.generate();
        JSONObject result = this.createSite("myPreset", user1PublicSiteName, "u1PublicSite", "myDescription", SiteVisibility.PUBLIC, 200);
        SiteServiceTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)result.get("visibility"));
        result = this.createSite("myPreset", user1ModeratedSiteName, "u1ModeratedSite", "myDescription", SiteVisibility.MODERATED, 200);
        SiteServiceTest.assertEquals((Object)SiteVisibility.MODERATED.toString(), (Object)result.get("visibility"));
        result = this.createSite("myPreset", user1PrivateSiteName, "u1PrivateSite", "myDescription", SiteVisibility.PRIVATE, 200);
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        result = this.createSite("myPreset", user2PrivateSiteName, "u2PrivateSite", "myDescription", SiteVisibility.PRIVATE, 200);
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
        this.authenticationComponent.setCurrentUser(USER_THREE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES_ADMIN), 404);
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES_ADMIN), 200);
        JSONObject jsonObject = new JSONObject(response.getContentAsString());
        JSONArray jsonArray = jsonObject.getJSONObject("list").getJSONArray("entries");
        int siteAdminGetSitesSize = jsonArray.length();
        SiteServiceTest.assertTrue((String)"result too small", (siteAdminGetSitesSize >= 4 ? 1 : 0) != 0);
        SiteServiceTest.assertTrue((String)"Site admin can access all the sites (PUBLIC | MODERATED | PRIVATE).", (boolean)this.canSeePrivateSites(jsonArray));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES_ADMIN), 200);
        jsonObject = new JSONObject(response.getContentAsString());
        jsonArray = jsonObject.getJSONObject("list").getJSONArray("entries");
        SiteServiceTest.assertEquals((String)"SiteAdmin must have access to the same sites as the super Admin.", (int)siteAdminGetSitesSize, (int)jsonArray.length());
    }

    public void testGetAllSitesPagedAsSiteAdmin() throws Exception {
        long siteNamePrefix = System.currentTimeMillis();
        String siteNameSuffix = GUID.generate();
        String user1PublicSiteName = siteNamePrefix + siteNameSuffix.substring(siteNameSuffix.lastIndexOf(45));
        this.createSite("myPreset", user1PublicSiteName, "u1PublicSite", "myDescription", SiteVisibility.PUBLIC, 200);
        for (int i = 1; i < 6; ++i) {
            this.createSite("myPreset", GUID.generate(), "u1PublicSite" + i, "myDescription" + i, SiteVisibility.PUBLIC, 200);
        }
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/admin-sites?maxItems=5&skipCount=0"), 200);
        JSONObject jsonObject = new JSONObject(response.getContentAsString());
        JSONObject paging = jsonObject.getJSONObject("list").getJSONObject("pagination");
        SiteServiceTest.assertEquals((String)"The skipCount must be 0", (int)0, (int)paging.getInt("skipCount"));
        SiteServiceTest.assertEquals((String)"The maxItems must be 5", (int)5, (int)paging.getInt("maxItems"));
        SiteServiceTest.assertTrue((String)"The totalItems must be 6", (paging.getInt("totalItems") >= 6 ? 1 : 0) != 0);
        SiteServiceTest.assertTrue((boolean)paging.getBoolean("hasMoreItems"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/admin-sites?nf=" + siteNamePrefix + "&maxItems=5&skipCount=0"), 200);
        jsonObject = new JSONObject(response.getContentAsString());
        paging = jsonObject.getJSONObject("list").getJSONObject("pagination");
        SiteServiceTest.assertEquals((String)"The count must be 1", (int)1, (int)paging.getInt("count"));
        SiteServiceTest.assertEquals((String)"The maxItems must be 5", (int)5, (int)paging.getInt("maxItems"));
        SiteServiceTest.assertEquals((String)"The totalItems must be 1", (int)1, (int)paging.getInt("totalItems"));
        SiteServiceTest.assertFalse((boolean)paging.getBoolean("hasMoreItems"));
    }

    private boolean canSeePrivateSites(JSONArray jsonArray) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String visibility = obj.getJSONObject("entry").getString("visibility");
            if (!SiteVisibility.PRIVATE.equals((Object)SiteVisibility.valueOf((String)visibility))) continue;
            return true;
        }
        return false;
    }

    public void testMultipleInviteRequests() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.MODERATED, 200);
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteComments = "Request to join";
        try {
            String moderatedInvitationId = this.createModeratedInvitation(shortName, inviteComments, userName, roleName);
            String newModeratedInvitationId = this.createModeratedInvitation(shortName, inviteComments, userName, roleName);
            SiteServiceTest.fail((String)"A request to join this site is already in pending");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testDeleteSiteAsAdministrator() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String shortName = GUID.generate();
        this.createSite("mySite", shortName, "myTitle", "myDescription", SiteVisibility.MODERATED, 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 500);
        this.authenticationComponent.setCurrentUser(USER_FOUR_AS_SITE_ADMIN);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 404);
    }
}

