/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.util.Map;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.quickshare.AbstractQuickShareContent;
import org.alfresco.repo.web.scripts.quickshare.QuickShareMetaDataGet;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class MetaDataGet
extends AbstractQuickShareContent {
    private static final Log logger = LogFactory.getLog(QuickShareMetaDataGet.class);

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        NodeRef nodeRef = WebScriptUtil.getNodeRef(params);
        if (nodeRef == null) {
            String msg = "A valid NodeRef must be specified!";
            throw new WebScriptException(400, msg);
        }
        try {
            Map model = this.quickShareService.getMetaData(nodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieved limited metadata: " + String.valueOf(nodeRef) + " [" + String.valueOf(model) + "]"));
            }
            return model;
        }
        catch (InvalidNodeRefException inre) {
            logger.error((Object)("Unable to find node: " + String.valueOf(inre.getNodeRef())));
            throw new WebScriptException(404, "Unable to find nodeRef: " + String.valueOf(inre.getNodeRef()));
        }
    }
}

