/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.processes;

import java.util.List;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.workflow.api.Processes;
import org.alfresco.rest.workflow.api.model.Variable;
import org.alfresco.rest.workflow.api.processes.ProcessesRestEntityResource;

@RelationshipResource(name="variables", entityResource=ProcessesRestEntityResource.class, title="Variables for the current process")
public class ProcessVariablesRelation
implements RelationshipResourceAction.Read<Variable>,
RelationshipResourceAction.Create<Variable>,
RelationshipResourceAction.Update<Variable>,
RelationshipResourceAction.Delete {
    protected Processes processes;

    public void setProcesses(Processes processes) {
        this.processes = processes;
    }

    @Override
    @WebApiDescription(title="Get Task Variables", description="Get a paged list of the task variables")
    public CollectionWithPagingInfo<Variable> readAll(String processId, Parameters parameters) {
        return this.processes.getVariables(processId, parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Create or Update Variables", description="Create or update multiple variable")
    public List<Variable> create(String processId, List<Variable> variables, Parameters parameters) {
        return this.processes.updateVariables(processId, variables);
    }

    @Override
    @WebApiDescription(title="Update Variable", description="Update a variable")
    public Variable update(String processId, Variable entity, Parameters parameters) {
        return this.processes.updateVariable(processId, entity);
    }

    @Override
    @WebApiDescription(title="Delete Variable", description="Delete a variable")
    public void delete(String processId, String id, Parameters parameters) {
        this.processes.deleteVariable(processId, id);
    }
}

