/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.HashSet;
import java.util.List;
import net.sf.acegisecurity.DisabledException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.ExternalUserAuthenticator;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.web.auth.AuthenticationListener;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.web.scripts.servlet.AuthenticationTimeoutException;
import org.alfresco.repo.web.scripts.servlet.BasicHttpAuthenticatorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class RemoteUserAuthenticatorFactory
extends BasicHttpAuthenticatorFactory {
    private static final Log LOGGER = LogFactory.getLog(RemoteUserAuthenticatorFactory.class);
    public static final long GET_REMOTE_USER_TIMEOUT_MILLISECONDS_DEFAULT = 10000L;
    protected RemoteUserMapper remoteUserMapper;
    protected AuthenticationComponent authenticationComponent;
    protected ExternalUserAuthenticator adminConsoleAuthenticator;
    protected ExternalUserAuthenticator webScriptsHomeAuthenticator;
    private boolean alwaysAllowBasicAuthForAdminConsole = true;
    private boolean alwaysAllowBasicAuthForWebScriptsHome = true;
    List<String> adminConsoleScriptFamilies;
    long getRemoteUserTimeoutMilliseconds = 10000L;

    public void setRemoteUserMapper(RemoteUserMapper remoteUserMapper) {
        this.remoteUserMapper = remoteUserMapper;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public boolean isAlwaysAllowBasicAuthForAdminConsole() {
        return this.alwaysAllowBasicAuthForAdminConsole;
    }

    public void setAlwaysAllowBasicAuthForAdminConsole(boolean alwaysAllowBasicAuthForAdminConsole) {
        this.alwaysAllowBasicAuthForAdminConsole = alwaysAllowBasicAuthForAdminConsole;
    }

    public boolean isAlwaysAllowBasicAuthForWebScriptsHome() {
        return this.alwaysAllowBasicAuthForWebScriptsHome;
    }

    public void setAlwaysAllowBasicAuthForWebScriptsHome(boolean alwaysAllowBasicAuthForWebScriptsHome) {
        this.alwaysAllowBasicAuthForWebScriptsHome = alwaysAllowBasicAuthForWebScriptsHome;
    }

    public List<String> getAdminConsoleScriptFamilies() {
        return this.adminConsoleScriptFamilies;
    }

    public void setAdminConsoleScriptFamilies(List<String> adminConsoleScriptFamilies) {
        this.adminConsoleScriptFamilies = adminConsoleScriptFamilies;
    }

    public long getGetRemoteUserTimeoutMilliseconds() {
        return this.getRemoteUserTimeoutMilliseconds;
    }

    public void setGetRemoteUserTimeoutMilliseconds(long getRemoteUserTimeoutMilliseconds) {
        this.getRemoteUserTimeoutMilliseconds = getRemoteUserTimeoutMilliseconds;
    }

    public void setAdminConsoleAuthenticator(ExternalUserAuthenticator adminConsoleAuthenticator) {
        this.adminConsoleAuthenticator = adminConsoleAuthenticator;
    }

    public void setWebScriptsHomeAuthenticator(ExternalUserAuthenticator webScriptsHomeAuthenticator) {
        this.webScriptsHomeAuthenticator = webScriptsHomeAuthenticator;
    }

    @Override
    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new RemoteUserAuthenticator(req, res, this.listener);
    }

    public class RemoteUserAuthenticator
    extends BasicHttpAuthenticatorFactory.BasicHttpAuthenticator {
        private static final String WEB_SCRIPTS_BASE_PATH = "org/springframework/extensions/webscripts";

        public RemoteUserAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res, AuthenticationListener listener) {
            super(req, res, listener);
        }

        @Override
        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authenticated;
            block32: {
                authenticated = false;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Authenticate level required: " + String.valueOf(required) + " is guest: " + isGuest));
                }
                String userId = null;
                if (this.isRemoteUserMapperActive()) {
                    if (this.servletReq.getServiceMatch() != null && this.isAdminConsole(this.servletReq.getServiceMatch().getWebScript()) && this.isAdminConsoleAuthenticatorActive()) {
                        userId = this.getAdminConsoleUser();
                    } else if (this.servletReq.getServiceMatch() != null && this.isWebScriptsHome(this.servletReq.getServiceMatch().getWebScript()) && this.isWebScriptsHomeAuthenticatorActive()) {
                        userId = this.getWebScriptsHomeUser();
                    }
                    if (userId == null) {
                        if (RemoteUserAuthenticatorFactory.this.isAlwaysAllowBasicAuthForAdminConsole()) {
                            shouldUseTimeout = this.shouldUseTimeoutForAdminAccessingAdminConsole(required, isGuest);
                            if (shouldUseTimeout && this.isBasicAuthHeaderPresentForAdmin()) {
                                return this.callBasicAuthForAdminConsoleOrWebScriptsHomeAccess(required, isGuest);
                            }
                            try {
                                userId = this.getRemoteUserWithTimeout(shouldUseTimeout);
                            }
                            catch (AuthenticationTimeoutException e) {
                                return false;
                            }
                        } else if (RemoteUserAuthenticatorFactory.this.isAlwaysAllowBasicAuthForWebScriptsHome()) {
                            shouldUseTimeout = this.shouldUseTimeoutForAdminAccessingWebScriptsHome(required, isGuest);
                            if (shouldUseTimeout && this.isBasicAuthHeaderPresentForAdmin()) {
                                return this.callBasicAuthForAdminConsoleOrWebScriptsHomeAccess(required, isGuest);
                            }
                            try {
                                userId = this.getRemoteUserWithTimeout(shouldUseTimeout);
                            }
                            catch (AuthenticationTimeoutException e) {
                                return false;
                            }
                        } else {
                            userId = this.getRemoteUser();
                        }
                    }
                }
                if (userId != null) {
                    try {
                        RemoteUserAuthenticatorFactory.this.authenticationComponent.setCurrentUser(userId);
                        this.listener.userAuthenticated(new TicketCredentials(RemoteUserAuthenticatorFactory.this.authenticationService.getCurrentTicket()));
                        authenticated = true;
                    }
                    catch (AuthenticationException authErr) {
                        Throwable disabledCause = ExceptionStackUtil.getCause((Throwable)authErr, (Class[])new Class[]{DisabledException.class});
                        if (disabledCause != null) {
                            this.listener.authenticationFailed(new WebCredentials(){});
                        }
                        throw authErr;
                    }
                } else {
                    HttpSession session = this.servletReq.getHttpServletRequest().getSession(false);
                    if (session != null) {
                        try {
                            SessionUser user = (SessionUser)session.getAttribute("_alfAuthTicket");
                            if (user != null) {
                                RemoteUserAuthenticatorFactory.this.authenticationService.validate(user.getTicket());
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)"Ticket is valid. Retaining cached user in session.");
                                }
                                this.listener.userAuthenticated(new TicketCredentials(user.getTicket()));
                                authenticated = true;
                                break block32;
                            }
                            authenticated = super.authenticate(required, isGuest);
                        }
                        catch (AuthenticationException authErr) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)"An Authentication error occur. Removing User session.", (Throwable)authErr);
                            }
                            session.removeAttribute("_alfAuthTicket");
                            session.invalidate();
                            this.listener.authenticationFailed(new WebCredentials(){});
                        }
                    } else {
                        authenticated = super.authenticate(required, isGuest);
                    }
                }
            }
            if (!authenticated && this.servletReq.getServiceMatch() != null) {
                WebScript webScript = this.servletReq.getServiceMatch().getWebScript();
                if (this.isAdminConsole(webScript) && this.isAdminConsoleAuthenticatorActive()) {
                    RemoteUserAuthenticatorFactory.this.adminConsoleAuthenticator.requestAuthentication(this.servletReq.getHttpServletRequest(), this.servletRes.getHttpServletResponse());
                } else if (this.isWebScriptsHome(webScript) && this.isWebScriptsHomeAuthenticatorActive()) {
                    RemoteUserAuthenticatorFactory.this.webScriptsHomeAuthenticator.requestAuthentication(this.servletReq.getHttpServletRequest(), this.servletRes.getHttpServletResponse());
                }
            }
            return authenticated;
        }

        private boolean callBasicAuthForAdminConsoleOrWebScriptsHomeAccess(Description.RequiredAuthentication required, boolean isGuest) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)"An Admin Console or WebScripts Home request has come in with Basic Auth headers present for an admin user.");
            }
            return super.authenticate(required, isGuest);
        }

        private boolean shouldUseTimeoutForAdminAccessingAdminConsole(Description.RequiredAuthentication required, boolean isGuest) {
            boolean adminConsoleTimeout;
            boolean bl = adminConsoleTimeout = Description.RequiredAuthentication.admin.equals((Object)required) && !isGuest && this.servletReq.getServiceMatch() != null && this.isAdminConsole(this.servletReq.getServiceMatch().getWebScript());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Should ensure that the admins can login with basic auth: " + adminConsoleTimeout));
            }
            return adminConsoleTimeout;
        }

        private boolean shouldUseTimeoutForAdminAccessingWebScriptsHome(Description.RequiredAuthentication required, boolean isGuest) {
            boolean adminWebScriptsHomeTimeout;
            boolean bl = adminWebScriptsHomeTimeout = Description.RequiredAuthentication.admin.equals((Object)required) && !isGuest && this.servletReq.getServiceMatch() != null && this.isWebScriptsHome(this.servletReq.getServiceMatch().getWebScript());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Should ensure that the admins can login with basic auth: " + adminWebScriptsHomeTimeout));
            }
            return adminWebScriptsHomeTimeout;
        }

        private boolean isRemoteUserMapperActive() {
            return RemoteUserAuthenticatorFactory.this.remoteUserMapper != null && (!(RemoteUserAuthenticatorFactory.this.remoteUserMapper instanceof ActivateableBean) || ((ActivateableBean)RemoteUserAuthenticatorFactory.this.remoteUserMapper).isActive());
        }

        private boolean isAdminConsoleAuthenticatorActive() {
            return RemoteUserAuthenticatorFactory.this.adminConsoleAuthenticator != null && (!(RemoteUserAuthenticatorFactory.this.adminConsoleAuthenticator instanceof ActivateableBean) || ((ActivateableBean)RemoteUserAuthenticatorFactory.this.adminConsoleAuthenticator).isActive());
        }

        private boolean isWebScriptsHomeAuthenticatorActive() {
            return RemoteUserAuthenticatorFactory.this.webScriptsHomeAuthenticator != null && (!(RemoteUserAuthenticatorFactory.this.webScriptsHomeAuthenticator instanceof ActivateableBean) || ((ActivateableBean)RemoteUserAuthenticatorFactory.this.webScriptsHomeAuthenticator).isActive());
        }

        protected boolean isAdminConsole(WebScript webScript) {
            boolean isAdminConsole;
            if (webScript == null || RemoteUserAuthenticatorFactory.this.adminConsoleScriptFamilies == null || webScript.getDescription() == null || webScript.getDescription().getFamilys() == null) {
                return false;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("WebScript: " + String.valueOf(webScript) + " has these families: " + String.valueOf(webScript.getDescription().getFamilys())));
            }
            HashSet families = new HashSet(webScript.getDescription().getFamilys());
            families.retainAll(RemoteUserAuthenticatorFactory.this.adminConsoleScriptFamilies);
            boolean bl = isAdminConsole = !families.isEmpty();
            if (LOGGER.isTraceEnabled() && isAdminConsole) {
                LOGGER.trace((Object)("Detected an Admin Console webscript: " + String.valueOf(webScript)));
            }
            return isAdminConsole;
        }

        protected boolean isWebScriptsHome(WebScript webScript) {
            if (webScript == null || webScript.toString() == null) {
                return false;
            }
            boolean isWebScriptsHome = webScript.toString().startsWith(WEB_SCRIPTS_BASE_PATH);
            if (LOGGER.isTraceEnabled() && isWebScriptsHome) {
                LOGGER.trace((Object)("Detected a WebScripts Home webscript: " + String.valueOf(webScript)));
            }
            return isWebScriptsHome;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getRemoteUserWithTimeout(boolean useTimeout) throws AuthenticationTimeoutException {
            if (!useTimeout) {
                return this.getRemoteUser();
            }
            String returnedRemoteUser = null;
            GetRemoteUserRunnable getRemoteUserRunnable = new GetRemoteUserRunnable();
            Thread workerGettingTheRemoteUser = new Thread(getRemoteUserRunnable);
            workerGettingTheRemoteUser.start();
            try {
                Thread thread = workerGettingTheRemoteUser;
                synchronized (thread) {
                    workerGettingTheRemoteUser.join(RemoteUserAuthenticatorFactory.this.getRemoteUserTimeoutMilliseconds);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Exception trying to get the remote user: " + e.getMessage()), (Throwable)e);
            }
            returnedRemoteUser = getRemoteUserRunnable.getReturnedRemoteUser();
            if (workerGettingTheRemoteUser.isAlive()) {
                this.cleanupThread(workerGettingTheRemoteUser);
                String message = "Could not get the remote user in a reasonable time: " + RemoteUserAuthenticatorFactory.this.getRemoteUserTimeoutMilliseconds + " milliseconds. Adjust the timeout property 'authentication.getRemoteUserTimeoutMilliseconds' if required.";
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Returning basic auth challenge for Admin Console. Cause: " + message));
                }
                HttpServletResponse res = this.servletRes.getHttpServletResponse();
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
                throw new AuthenticationTimeoutException(message);
            }
            return returnedRemoteUser;
        }

        private void cleanupThread(Thread workerGettingTheRemoteUser) {
            try {
                workerGettingTheRemoteUser.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected String getRemoteUser() {
            String userId = null;
            if (this.isRemoteUserMapperActive()) {
                userId = RemoteUserAuthenticatorFactory.this.remoteUserMapper.getRemoteUser(this.servletReq.getHttpServletRequest());
            }
            this.logRemoteUserID(userId);
            return userId;
        }

        private void logRemoteUserID(String userId) {
            if (LOGGER.isDebugEnabled()) {
                String message = userId == null ? "No external user ID in request." : "Extracted external user ID from request: " + AuthenticationUtil.maskUsername((String)userId);
                LOGGER.debug((Object)message);
            }
        }

        protected String getAdminConsoleUser() {
            String userId = null;
            if (this.isRemoteUserMapperActive()) {
                userId = RemoteUserAuthenticatorFactory.this.adminConsoleAuthenticator.getUserId(this.servletReq.getHttpServletRequest(), this.servletRes.getHttpServletResponse());
            }
            this.logRemoteUserID(userId);
            return userId;
        }

        protected String getWebScriptsHomeUser() {
            String userId = null;
            if (this.isRemoteUserMapperActive()) {
                userId = RemoteUserAuthenticatorFactory.this.webScriptsHomeAuthenticator.getUserId(this.servletReq.getHttpServletRequest(), this.servletRes.getHttpServletResponse());
            }
            this.logRemoteUserID(userId);
            return userId;
        }

        class GetRemoteUserRunnable
        implements Runnable {
            private volatile String returnedRemoteUser;

            GetRemoteUserRunnable() {
            }

            @Override
            public void run() {
                this.returnedRemoteUser = RemoteUserAuthenticator.this.getRemoteUser();
            }

            public String getReturnedRemoteUser() {
                return this.returnedRemoteUser;
            }
        }
    }
}

