/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.api.search.SerializerTestHelper;
import org.alfresco.rest.api.search.context.FacetFieldContext;
import org.alfresco.rest.api.search.context.FacetQueryContext;
import org.alfresco.rest.api.search.context.SearchContext;
import org.alfresco.rest.api.search.context.SpellCheckContext;
import org.alfresco.rest.api.search.model.Default;
import org.alfresco.rest.api.search.model.FacetField;
import org.alfresco.rest.api.search.model.FacetQuery;
import org.alfresco.rest.api.search.model.FilterQuery;
import org.alfresco.rest.api.search.model.Pivot;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalParameters;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SearchQuerySerializerTests {
    private static SerializerTestHelper helper;

    @BeforeClass
    public static void setupTests() throws Exception {
        helper = new SerializerTestHelper();
    }

    @Test
    public void testDeserializeQuery() throws IOException {
        SearchQuery searchQuery = helper.searchQueryFromJson();
        Assert.assertEquals(SearchQuery.class, searchQuery.getClass());
        Assert.assertEquals((Object)"afts", (Object)searchQuery.getQuery().getLanguage());
        Assert.assertEquals((Object)"g*", (Object)searchQuery.getQuery().getQuery());
        Assert.assertEquals((Object)"great", (Object)searchQuery.getQuery().getUserQuery());
        Assert.assertEquals((long)99L, (long)searchQuery.getPaging().getMaxItems());
        Assert.assertEquals((long)4L, (long)searchQuery.getPaging().getSkipCount());
        Assert.assertEquals((long)2L, (long)searchQuery.getInclude().size());
        Assert.assertTrue((boolean)searchQuery.getInclude().contains("aspectNames"));
        Assert.assertTrue((boolean)searchQuery.getInclude().contains("properties"));
        Assert.assertEquals((long)1L, (long)searchQuery.getSort().size());
        Assert.assertEquals((long)2L, (long)searchQuery.getTemplates().size());
        Default defaults = searchQuery.getDefaults();
        Assert.assertEquals((Object)"namesp", (Object)defaults.getNamespace());
        Assert.assertEquals((Object)"myfield", (Object)defaults.getDefaultFieldName());
        Assert.assertEquals((Object)"AND", (Object)defaults.getDefaultFTSOperator());
        Assert.assertEquals((long)2L, (long)defaults.getTextAttributes().size());
        Assert.assertTrue((boolean)defaults.getTextAttributes().contains("roy"));
        Assert.assertTrue((boolean)defaults.getTextAttributes().contains("king"));
        Assert.assertEquals((long)2L, (long)searchQuery.getFilterQueries().size());
        Assert.assertEquals((Object)"myquery", (Object)((FilterQuery)searchQuery.getFilterQueries().get(0)).getQuery());
        Assert.assertEquals((long)2L, (long)((FilterQuery)searchQuery.getFilterQueries().get(0)).getTags().size());
        Assert.assertEquals((Object)"myquery2", (Object)((FilterQuery)searchQuery.getFilterQueries().get(1)).getQuery());
        Assert.assertEquals((long)1L, (long)searchQuery.getFacetQueries().size());
        Assert.assertEquals((Object)"cm:created:bob", (Object)((FacetQuery)searchQuery.getFacetQueries().get(0)).getQuery());
        Assert.assertEquals((Object)"small", (Object)((FacetQuery)searchQuery.getFacetQueries().get(0)).getLabel());
        Assert.assertEquals((Object)"alfrezco", (Object)searchQuery.getSpellcheck().getQuery());
        Assert.assertEquals((long)1L, (long)searchQuery.getScope().getLocations().size());
        Assert.assertEquals((Object)"nodes", searchQuery.getScope().getLocations().get(0));
        Assert.assertEquals((long)3L, (long)searchQuery.getFacetFields().getFacets().size());
        FacetField ff = (FacetField)searchQuery.getFacetFields().getFacets().get(0);
        Assert.assertEquals((Object)"cm:creator", (Object)ff.getField());
        Assert.assertEquals((Object)"myquery2", (Object)ff.getPrefix());
        Assert.assertEquals((Object)"COUNT", (Object)ff.getSort());
        Assert.assertEquals((Object)false, (Object)ff.getMissing());
        ff = (FacetField)searchQuery.getFacetFields().getFacets().get(1);
        Assert.assertEquals((Object)"modifier", (Object)ff.getField());
        Assert.assertEquals((Object)"mylabel", (Object)ff.getLabel());
        Assert.assertEquals((Object)"FC", (Object)ff.getMethod());
        Assert.assertEquals((Object)5, (Object)ff.getMincount());
        Assert.assertEquals((long)2000L, (long)searchQuery.getLimits().getPermissionEvaluationCount().intValue());
        Assert.assertEquals((long)5000L, (long)searchQuery.getLimits().getPermissionEvaluationTime().intValue());
        Assert.assertEquals((long)2L, (long)searchQuery.getFields().size());
        Assert.assertTrue((boolean)searchQuery.getFields().contains("id"));
        Assert.assertTrue((boolean)searchQuery.getFields().contains("name"));
        Assert.assertEquals((Object)"]", (Object)searchQuery.getHighlight().getPostfix());
        Assert.assertEquals((Object)"[", (Object)searchQuery.getHighlight().getPrefix());
        Assert.assertEquals((long)20L, (long)searchQuery.getHighlight().getSnippetCount().intValue());
        Assert.assertEquals((long)10L, (long)searchQuery.getHighlight().getFragmentSize().intValue());
        Assert.assertEquals((Object)true, (Object)searchQuery.getHighlight().getMergeContiguous());
        Assert.assertEquals((long)40L, (long)searchQuery.getHighlight().getMaxAnalyzedChars().intValue());
        Assert.assertEquals((Object)true, (Object)searchQuery.getHighlight().getUsePhraseHighlighter());
        Assert.assertEquals((long)2L, (long)searchQuery.getHighlight().getFields().size());
        FieldHighlightParameters high1 = (FieldHighlightParameters)searchQuery.getHighlight().getFields().get(0);
        Assert.assertEquals((Object)"my", (Object)high1.getField());
        Assert.assertEquals((Object)"\u00a1", (Object)high1.getPostfix());
        Assert.assertEquals((Object)"?", (Object)high1.getPrefix());
        Assert.assertEquals((long)23L, (long)high1.getSnippetCount().intValue());
        Assert.assertEquals((long)5L, (long)high1.getFragmentSize().intValue());
        Assert.assertEquals((Object)true, (Object)high1.getMergeContiguous());
        FieldHighlightParameters high2 = (FieldHighlightParameters)searchQuery.getHighlight().getFields().get(1);
        Assert.assertEquals((Object)"your", (Object)high2.getField());
        Assert.assertEquals((Object)")", (Object)high2.getPostfix());
        Assert.assertEquals((Object)"(", (Object)high2.getPrefix());
        Assert.assertEquals((long)3L, (long)high2.getSnippetCount().intValue());
        Assert.assertEquals((long)15L, (long)high2.getFragmentSize().intValue());
        Assert.assertEquals((Object)false, (Object)high2.getMergeContiguous());
        IntervalParameters ip = searchQuery.getFacetIntervals();
        Assert.assertNotNull((Object)ip);
        Assert.assertEquals((long)1L, (long)ip.getSets().size());
        IntervalSet expected = new IntervalSet("1", "2", "king", Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertTrue((boolean)ip.getSets().contains(expected));
        Assert.assertEquals((long)2L, (long)ip.getIntervals().size());
        Interval interval = (Interval)ip.getIntervals().get(0);
        Assert.assertEquals((Object)"creator", (Object)interval.getLabel());
        Assert.assertEquals((Object)"cm:creator", (Object)interval.getField());
        expected = new IntervalSet("a", "b", "last", Boolean.valueOf(false), Boolean.valueOf(true));
        Assert.assertTrue((boolean)interval.getSets().contains(expected));
        Assert.assertEquals((long)1L, (long)searchQuery.getPivots().size());
        Assert.assertEquals((Object)"mylabel", (Object)((Pivot)searchQuery.getPivots().get(0)).getKey());
        Assert.assertEquals((long)1L, (long)searchQuery.getStats().size());
        Assert.assertEquals((Object)"cm:creator", (Object)((StatsRequestParameters)searchQuery.getStats().get(0)).getField());
        Assert.assertEquals((Object)"mylabel", (Object)((StatsRequestParameters)searchQuery.getStats().get(0)).getLabel());
        List ranges = searchQuery.getFacetRanges();
        Assert.assertNotNull((Object)ranges);
    }

    @Test
    public void testSerializeContext() throws IOException {
        ExecutionResult exec1 = new ExecutionResult((Object)new Farmer("180"), null);
        FacetFieldContext ffc = new FacetFieldContext("theLabel", Arrays.asList(new FacetFieldContext.Bucket("b1", "name:b1", 23, (Object)"displayText1"), new FacetFieldContext.Bucket("b2", null, 34, (Object)"displayText2"), new FacetFieldContext.Bucket("", null, 42, (Object)"displayText3")));
        SearchContext searchContext = new SearchContext(23L, null, Arrays.asList(new FacetQueryContext("f1", "creator:bob", 15), new FacetQueryContext("f2", null, 20)), Arrays.asList(ffc), new SpellCheckContext("aFlag", Arrays.asList("bish", "bash")), null);
        CollectionWithPagingInfo coll = CollectionWithPagingInfo.asPaged(null, Arrays.asList(exec1), (boolean)false, (Integer)2, null, (SearchContext)searchContext);
        String out = helper.writeResponse(coll);
        Assert.assertTrue((String)"There must 'context' json output", (boolean)out.contains("\"context\":{\"consistency\":{\"lastTxId\":23}"));
        Assert.assertTrue((String)"There must 'facetQueries' json output", (boolean)out.contains("\"facetQueries\":"));
        Assert.assertTrue((String)"There must 'facetQueries f1' json output", (boolean)out.contains("{\"label\":\"f1\",\"filterQuery\":\"creator:bob\",\"count\":15}"));
        Assert.assertTrue((String)"There must 'facetQueries f2' json output", (boolean)out.contains("{\"label\":\"f2\",\"count\":20}"));
        Assert.assertTrue((String)"There must 'spellCheck' json output", (boolean)out.contains("\"spellCheck\":{\"type\":\"aFlag\",\"suggestions\":[\"bish\",\"bash\"]}"));
        Assert.assertTrue((String)"There must 'facetsFields' json output", (boolean)out.contains("\"facetsFields\":[{\"label\":\"theLabel\",\"buckets\""));
        Assert.assertTrue((String)"There must 'bucket1' json output", (boolean)out.contains("{\"label\":\"b1\",\"filterQuery\":\"name:b1\",\"count\":23,\"display\":\"displayText1\"}"));
        Assert.assertTrue((String)"There must 'bucket2' json output", (boolean)out.contains("{\"label\":\"b2\",\"count\":34,\"display\":\"displayText2\"}"));
        Assert.assertTrue((String)"There must 'bucket3' json output", (boolean)out.contains("{\"label\":\"\",\"count\":42,\"display\":\"displayText3\"}"));
        searchContext = new SearchContext(-1L, null, null, null, null, null);
        coll = CollectionWithPagingInfo.asPaged(null, Arrays.asList(exec1), (boolean)false, (Integer)2, null, (SearchContext)searchContext);
        out = helper.writeResponse(coll);
        Assert.assertTrue((String)"There must NOT BE a 'context' json output", (boolean)out.contains("\"context\":{}"));
        Assert.assertFalse((String)"There must NOT BE a 'facetsFields' json output", (boolean)out.contains("\"facetsFields\":{}"));
    }
}

