/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.httpclient.HttpMethod;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AbstractHttp {
    public static final String JSON_DATA = "data";

    public JSONObject getDataFromResponse(HttpMethod method) {
        Object result = null;
        Object object = this.getObjectFromResponse(method);
        if ((object = object.get((Object)JSON_DATA)) instanceof JSONObject) {
            result = object;
        }
        return result;
    }

    public JSONArray getDataArrayFromResponse(HttpMethod method) {
        JSONArray result = null;
        Object object = this.getObjectFromResponse(method);
        if (object != null && (object = object.get((Object)JSON_DATA)) instanceof JSONArray) {
            result = (JSONArray)object;
        }
        return result;
    }

    public JSONObject getObjectFromResponse(HttpMethod method) {
        JSONObject result = null;
        try {
            Object object;
            InputStream response = method.getResponseBodyAsStream();
            if (response != null && (object = new JSONParser().parse((Reader)new InputStreamReader(response, Charset.forName("UTF-8")))) instanceof JSONObject) {
                return (JSONObject)object;
            }
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public String getString(JSONObject json, String key, String defaultValue) {
        Object value;
        String result = defaultValue;
        if (json != null && (value = json.get((Object)key)) instanceof String) {
            result = (String)value;
        }
        return result;
    }

    public JSONArray getArray(JSONObject json, String key) {
        Object object = json.get((Object)key);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONObject getObject(JSONObject json, String key) {
        Object object = json.get((Object)key);
        if (object instanceof JSONArray) {
            return (JSONObject)object;
        }
        return null;
    }
}

