/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApi;
import org.alfresco.rest.framework.WebApiDeleted;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.WebApiParameters;
import org.alfresco.rest.framework.core.OperationResourceMetaData;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceInspectorUtil;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.EmbeddedEntityResource;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.actions.interfaces.ResourceAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.ReflectionUtils;

public class ResourceInspector {
    private static Log logger = LogFactory.getLog(ResourceInspector.class);
    private static final Set<Class<? extends ResourceAction>> ALL_ENTITY_RESOURCE_INTERFACES = new HashSet<Class<? extends ResourceAction>>();
    private static final Set<Class<? extends ResourceAction>> ALL_RELATIONSHIP_RESOURCE_INTERFACES = new HashSet<Class<? extends ResourceAction>>();
    private static final Set<Class<? extends ResourceAction>> ALL_PROPERTY_RESOURCE_INTERFACES = new HashSet<Class<? extends ResourceAction>>();
    private static String READ_BY_ID_METHODNAME = "readById";

    private static List<ResourceMetadata> inspectEntity(EntityResource annot, Class<?> resource) {
        String urlPath = ResourceInspector.findEntityName(annot);
        logger.debug((Object)("Found EntityResource: " + urlPath));
        ArrayList<ResourceMetadata> metainfo = new ArrayList<ResourceMetadata>();
        Api api = ResourceInspector.inspectApi(resource);
        MetaHelper helper = new MetaHelper(resource);
        ResourceInspector.findOperation(EntityResourceAction.Create.class, HttpMethod.POST, helper);
        ResourceInspector.findOperation(EntityResourceAction.Read.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(EntityResourceAction.ReadById.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(EntityResourceAction.Update.class, HttpMethod.PUT, helper);
        ResourceInspector.findOperation(EntityResourceAction.Delete.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(EntityResourceAction.DeleteSet.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(EntityResourceAction.CreateWithResponse.class, HttpMethod.POST, helper);
        ResourceInspector.findOperation(EntityResourceAction.ReadWithResponse.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(EntityResourceAction.ReadByIdWithResponse.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(EntityResourceAction.UpdateWithResponse.class, HttpMethod.PUT, helper);
        ResourceInspector.findOperation(EntityResourceAction.DeleteWithResponse.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(EntityResourceAction.DeleteSetWithResponse.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(MultiPartResourceAction.Create.class, HttpMethod.POST, helper);
        boolean noAuth = resource.isAnnotationPresent(WebApiNoAuth.class);
        if (noAuth) {
            throw new IllegalArgumentException("@WebApiNoAuth should not be on all (entity resource class) - only on individual methods: " + urlPath);
        }
        Set<Class<? extends ResourceAction>> apiNoAuth = helper.apiNoAuth;
        if (resource.isAnnotationPresent(WebApiDeleted.class)) {
            metainfo.add(new ResourceMetadata(ResourceDictionary.resourceKey(urlPath, null), ResourceMetadata.RESOURCE_TYPE.ENTITY, null, api, ALL_ENTITY_RESOURCE_INTERFACES, apiNoAuth, null));
        } else if (!helper.apiDeleted.isEmpty() || !helper.operations.isEmpty()) {
            metainfo.add(new ResourceMetadata(ResourceDictionary.resourceKey(urlPath, null), ResourceMetadata.RESOURCE_TYPE.ENTITY, helper.operations, api, helper.apiDeleted, apiNoAuth, null));
        }
        ResourceInspector.inspectAddressedProperties(api, resource, urlPath, metainfo);
        ResourceInspector.inspectOperations(api, resource, urlPath, metainfo);
        return metainfo;
    }

    public static void inspectAddressedProperties(Api api, Class<?> resource, String entityPath, List<ResourceMetadata> metainfo) {
        HashMap<String, List<ResourceOperation>> operationGroupedByProperty = new HashMap<String, List<ResourceOperation>>();
        MetaHelperAddressable helperForAddressProps = new MetaHelperAddressable(resource, entityPath, operationGroupedByProperty);
        ResourceInspector.findOperation(BinaryResourceAction.Read.class, HttpMethod.GET, helperForAddressProps);
        ResourceInspector.findOperation(BinaryResourceAction.Delete.class, HttpMethod.DELETE, helperForAddressProps);
        ResourceInspector.findOperation(BinaryResourceAction.Update.class, HttpMethod.PUT, helperForAddressProps);
        ResourceInspector.findOperation(BinaryResourceAction.ReadWithResponse.class, HttpMethod.GET, helperForAddressProps);
        ResourceInspector.findOperation(BinaryResourceAction.DeleteWithResponse.class, HttpMethod.DELETE, helperForAddressProps);
        ResourceInspector.findOperation(BinaryResourceAction.UpdateWithResponse.class, HttpMethod.PUT, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.Read.class, HttpMethod.GET, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.Delete.class, HttpMethod.DELETE, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.Update.class, HttpMethod.PUT, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.ReadWithResponse.class, HttpMethod.GET, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.DeleteWithResponse.class, HttpMethod.DELETE, helperForAddressProps);
        ResourceInspector.findOperation(RelationshipResourceBinaryAction.UpdateWithResponse.class, HttpMethod.PUT, helperForAddressProps);
        boolean noAuth = resource.isAnnotationPresent(WebApiNoAuth.class);
        if (noAuth) {
            throw new IllegalArgumentException("@WebApiNoAuth should not be on all (address properties) - only on individual methods: " + entityPath);
        }
        Set<Class<? extends ResourceAction>> apiNoAuth = helperForAddressProps.apiNoAuth;
        if (resource.isAnnotationPresent(WebApiDeleted.class)) {
            metainfo.add(new ResourceMetadata(ResourceDictionary.propertyResourceKey(entityPath, "FIX_ME"), ResourceMetadata.RESOURCE_TYPE.PROPERTY, null, ResourceInspector.inspectApi(resource), ALL_PROPERTY_RESOURCE_INTERFACES, apiNoAuth, null));
        } else {
            for (Map.Entry groupedOps : operationGroupedByProperty.entrySet()) {
                metainfo.add(new ResourceMetadata((String)groupedOps.getKey(), ResourceMetadata.RESOURCE_TYPE.PROPERTY, (List)groupedOps.getValue(), api, null, apiNoAuth, null));
            }
        }
    }

    private static List<ResourceMetadata> inspectRelationship(RelationshipResource annot, Class<?> resource) {
        String entityPath;
        Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
        String urlPath = String.valueOf(annotAttribs.get("name"));
        Class entityResource = (Class)annotAttribs.get("entityResource");
        RelationshipResource relAnnot = (RelationshipResource)AnnotationUtils.findAnnotation((Class)entityResource, RelationshipResource.class);
        if (relAnnot != null) {
            Map relAnnotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)relAnnot);
            String relUrlPath = String.valueOf(relAnnotAttribs.get("name"));
            urlPath = ResourceDictionary.resourceKey(relUrlPath, urlPath);
            entityPath = ResourceInspector.findEntityNameByAnnotationAttributes(relAnnotAttribs);
        } else {
            entityPath = ResourceInspector.findEntityNameByAnnotationAttributes(annotAttribs);
        }
        String relationshipKey = ResourceDictionary.resourceKey(entityPath, urlPath);
        Api api = ResourceInspector.inspectApi(resource);
        ArrayList<ResourceMetadata> metainfo = new ArrayList<ResourceMetadata>();
        MetaHelper helper = new MetaHelper(resource);
        ResourceInspector.findOperation(RelationshipResourceAction.Create.class, HttpMethod.POST, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.Read.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.ReadById.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.Update.class, HttpMethod.PUT, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.Delete.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.DeleteSet.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.CreateWithResponse.class, HttpMethod.POST, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.ReadWithResponse.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.ReadByIdWithResponse.class, HttpMethod.GET, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.UpdateWithResponse.class, HttpMethod.PUT, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.DeleteWithResponse.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(RelationshipResourceAction.DeleteSetWithResponse.class, HttpMethod.DELETE, helper);
        ResourceInspector.findOperation(MultiPartRelationshipResourceAction.Create.class, HttpMethod.POST, helper);
        boolean noAuth = resource.isAnnotationPresent(WebApiNoAuth.class);
        if (noAuth) {
            throw new IllegalArgumentException("@WebApiNoAuth should not be on all (relationship resource class) - only on methods: " + urlPath);
        }
        Set<Class<? extends ResourceAction>> apiNoAuth = helper.apiNoAuth;
        if (resource.isAnnotationPresent(WebApiDeleted.class)) {
            metainfo.add(new ResourceMetadata(relationshipKey, ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP, null, ResourceInspector.inspectApi(resource), ALL_RELATIONSHIP_RESOURCE_INTERFACES, apiNoAuth, entityPath));
        } else {
            metainfo.add(new ResourceMetadata(relationshipKey, ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP, helper.operations, ResourceInspector.inspectApi(resource), helper.apiDeleted, apiNoAuth, entityPath));
        }
        ResourceInspector.inspectAddressedProperties(api, resource, relationshipKey, metainfo);
        ResourceInspector.inspectOperations(api, resource, relationshipKey, metainfo);
        return metainfo;
    }

    private static void findOperation(Class<? extends ResourceAction> resourceInterfaceWithOneMethod, HttpMethod httpMethod, MetaHelperCallback helper) {
        if (resourceInterfaceWithOneMethod.isAssignableFrom(helper.resource)) {
            Method aMethod = ResourceInspector.findMethod(resourceInterfaceWithOneMethod, helper.resource);
            ResourceOperation operation = ResourceInspector.inspectOperation(helper.resource, aMethod, httpMethod);
            if (ResourceInspector.isDeleted(aMethod)) {
                helper.whenOperationDeleted(resourceInterfaceWithOneMethod, aMethod);
            } else {
                helper.whenNewOperation(operation, aMethod);
            }
            if (ResourceInspector.isNoAuth(aMethod)) {
                if (!httpMethod.equals((Object)HttpMethod.GET) && !httpMethod.equals((Object)HttpMethod.POST)) {
                    throw new IllegalArgumentException("@WebApiNoAuth should only be on GET or POST methods: " + operation.getTitle());
                }
                helper.whenOperationNoAuth(resourceInterfaceWithOneMethod, aMethod);
            }
        }
    }

    public static ResourceOperation inspectOperation(Class<?> resource, Method aMethod, HttpMethod httpMethod) {
        Annotation annot = AnnotationUtils.findAnnotation((Method)aMethod, WebApiDescription.class);
        ArrayList<ResourceParameter> parameters = new ArrayList<ResourceParameter>();
        parameters.addAll(ResourceInspector.inspectParameters(resource, aMethod, httpMethod));
        if (annot != null) {
            Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
            String title = String.valueOf(annotAttribs.get("title"));
            String desc = String.valueOf(annotAttribs.get("description"));
            Integer success = (Integer)annotAttribs.get("successStatus");
            return new ResourceOperation(httpMethod, title, desc, parameters, ResourceInspector.validSuccessCode(httpMethod, success));
        }
        return new ResourceOperation(httpMethod, "Missing @WebApiDescription annotation", "This method should be annotated with @WebApiDescription", parameters, ResourceInspector.validSuccessCode(httpMethod, -1));
    }

    public static int validSuccessCode(HttpMethod httpMethod, int success) {
        if (-1 != success) {
            return success;
        }
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return 200;
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return 201;
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return 200;
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return 204;
        }
        return 200;
    }

    private static List<ResourceParameter> inspectParameters(Class<?> resource, Method aMethod, HttpMethod httpMethod) {
        ArrayList<ResourceParameter> params = new ArrayList<ResourceParameter>();
        Annotation annot = AnnotationUtils.findAnnotation((Method)aMethod, WebApiParameters.class);
        if (annot != null) {
            Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
            WebApiParam[] apiParams = (WebApiParam[])annotAttribs.get("value");
            for (int i = 0; i < apiParams.length; ++i) {
                params.add(ResourceInspector.findResourceParameter(apiParams[i], resource, aMethod));
            }
        } else {
            Annotation paramAnot = AnnotationUtils.findAnnotation((Method)aMethod, WebApiParam.class);
            if (paramAnot != null) {
                params.add(ResourceInspector.findResourceParameter(paramAnot, resource, aMethod));
            }
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            if (ResourceInspector.paramsCount(params, ResourceParameter.KIND.URL_PATH) == 0) {
                params.add(ResourceParameter.ENTITY_PARAM);
            }
            if (ResourceInspector.paramsCount(params, ResourceParameter.KIND.HTTP_BODY_OBJECT) == 0) {
                ResourceInspector.inspectBodyParamAndReturnType(resource, aMethod, params);
            }
            return params;
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            int urlPathForPut = ResourceInspector.paramsCount(params, ResourceParameter.KIND.URL_PATH);
            if (urlPathForPut == 0) {
                params.add(ResourceParameter.ENTITY_PARAM);
            }
            if (RelationshipResourceAction.Update.class.isAssignableFrom(resource) && urlPathForPut < 2) {
                params.add(ResourceParameter.RELATIONSHIP_PARAM);
            }
            if (ResourceInspector.paramsCount(params, ResourceParameter.KIND.HTTP_BODY_OBJECT) == 0) {
                ResourceInspector.inspectBodyParamAndReturnType(resource, aMethod, params);
            }
            return params;
        }
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            int urlPathForGet = ResourceInspector.paramsCount(params, ResourceParameter.KIND.URL_PATH);
            if (urlPathForGet == 0 && EntityResourceAction.ReadById.class.isAssignableFrom(resource) && READ_BY_ID_METHODNAME.equals(aMethod.getName())) {
                params.add(ResourceParameter.ENTITY_PARAM);
            } else if (RelationshipResourceAction.ReadById.class.isAssignableFrom(resource) || RelationshipResourceAction.Read.class.isAssignableFrom(resource)) {
                if (urlPathForGet == 0) {
                    params.add(ResourceParameter.ENTITY_PARAM);
                }
                if (READ_BY_ID_METHODNAME.equals(aMethod.getName()) && urlPathForGet < 2) {
                    params.add(ResourceParameter.RELATIONSHIP_PARAM);
                }
            }
            if (!READ_BY_ID_METHODNAME.equals(aMethod.getName())) {
                params.add(ResourceParameter.SKIP_PARAM);
                params.add(ResourceParameter.MAX_ITEMS_PARAM);
                params.add(ResourceParameter.PROPS_PARAM);
            }
            return params;
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            int urlPathForDelete = ResourceInspector.paramsCount(params, ResourceParameter.KIND.URL_PATH);
            if (urlPathForDelete == 0) {
                params.add(ResourceParameter.ENTITY_PARAM);
            }
            if (RelationshipResourceAction.Delete.class.isAssignableFrom(resource) && urlPathForDelete < 2) {
                params.add(ResourceParameter.RELATIONSHIP_PARAM);
            }
            return params;
        }
        return params;
    }

    private static void inspectBodyParamAndReturnType(Class<?> resource, Method aMethod, List<ResourceParameter> params) {
        Class dType = ResourceInspectorUtil.determineType(resource, aMethod);
        if (dType != null) {
            params.add(ResourceParameter.valueOf(dType.getSimpleName().toUpperCase(), "The entity", "Unique entity properties", true, ResourceParameter.KIND.HTTP_BODY_OBJECT, true, dType));
        }
    }

    private static int paramsCount(List<ResourceParameter> params, ResourceParameter.KIND kind) {
        int numParams = 0;
        for (ResourceParameter resourceParameter : params) {
            if (!kind.equals((Object)resourceParameter.getParamType())) continue;
            ++numParams;
        }
        return numParams;
    }

    private static ResourceParameter findResourceParameter(Annotation paramAnot, Class<?> resource, Method aMethod) {
        Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)paramAnot);
        ResourceParameter.KIND paramKind = (ResourceParameter.KIND)((Object)annotAttribs.get("kind"));
        Class dType = String.class;
        if (ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)paramKind)) {
            dType = ResourceInspectorUtil.determineType(resource, aMethod);
        }
        return ResourceParameter.valueOf(String.valueOf(annotAttribs.get("name")), String.valueOf(annotAttribs.get("title")), String.valueOf(annotAttribs.get("description")), (Boolean)annotAttribs.get("required"), paramKind, (Boolean)annotAttribs.get("allowMultiple"), dType);
    }

    public static boolean isDeleted(Method method) {
        WebApiDeleted deleted = (WebApiDeleted)AnnotationUtils.getAnnotation((Method)method, WebApiDeleted.class);
        return deleted != null;
    }

    public static boolean isNoAuth(Method method) {
        WebApiNoAuth noAuth = (WebApiNoAuth)AnnotationUtils.getAnnotation((Method)method, WebApiNoAuth.class);
        return noAuth != null;
    }

    public static Method findMethod(Class<? extends ResourceAction> resourceInterfaceWithOneMethod, Class<?> resource) {
        Method[] resourceMethods = resourceInterfaceWithOneMethod.getMethods();
        if (resourceMethods == null || resourceMethods.length != 1) {
            throw new IllegalArgumentException(String.valueOf(resourceInterfaceWithOneMethod) + " should be an interface with just one method.");
        }
        Method method = ReflectionUtils.findMethod(resource, (String)resourceMethods[0].getName(), null);
        return method;
    }

    protected static String findEntityNameByAnnotationAttributes(Map<String, Object> annotAttribs) {
        Class entityResourceRef = (Class)annotAttribs.get("entityResource");
        EntityResource entityAnnot = (EntityResource)AnnotationUtils.findAnnotation((Class)entityResourceRef, EntityResource.class);
        return ResourceInspector.findEntityName(entityAnnot);
    }

    protected static String findEntityName(EntityResource entityAnnot) {
        Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)entityAnnot);
        String urlPath = String.valueOf(annotAttribs.get("name"));
        return urlPath;
    }

    public static String findEntityCollectionNameName(ResourceMetadata meta) {
        String name = switch (meta.getType()) {
            case ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP -> meta.getParentResource();
            default -> meta.getUniqueId();
        };
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public static Map<String, Pair<String, Method>> findEmbeddedResources(Class<?> anyClass) {
        HashMap<String, Pair<String, Method>> embeds = new HashMap<String, Pair<String, Method>>();
        List<Method> annotatedMethods = ResourceInspectorUtil.findMethodsByAnnotation(anyClass, EmbeddedEntityResource.class);
        if (annotatedMethods != null && !annotatedMethods.isEmpty()) {
            for (Method annotatedMethod : annotatedMethods) {
                Annotation annot = AnnotationUtils.findAnnotation((Method)annotatedMethod, EmbeddedEntityResource.class);
                if (annot == null) continue;
                Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
                String entityPath = ResourceInspector.findEntityNameByAnnotationAttributes(annotAttribs);
                String key = String.valueOf(annotAttribs.get("propertyName"));
                embeds.put(key, (Pair<String, Method>)new Pair((Object)entityPath, (Object)annotatedMethod));
            }
        }
        return embeds;
    }

    public static void inspectOperations(Api api, Class<?> resource, String entityPath, List<ResourceMetadata> metainfo) {
        Map<String, Pair<ResourceOperation, Method>> operations = ResourceInspector.findOperations(entityPath, resource);
        if (operations != null && !operations.isEmpty()) {
            for (Map.Entry<String, Pair<ResourceOperation, Method>> opera : operations.entrySet()) {
                Method annotatedMethod = (Method)opera.getValue().getSecond();
                boolean isNoAuthRequired = ResourceInspector.isNoAuth(annotatedMethod);
                if (ResourceInspector.isDeleted(annotatedMethod)) {
                    metainfo.add(new OperationResourceMetaData(opera.getKey(), api, new HashSet<ResourceOperation>(Arrays.asList((ResourceOperation)opera.getValue().getFirst())), isNoAuthRequired));
                    continue;
                }
                metainfo.add(new OperationResourceMetaData(opera.getKey(), Arrays.asList((ResourceOperation)opera.getValue().getFirst()), api, annotatedMethod, isNoAuthRequired));
            }
        }
    }

    private static Map<String, Pair<ResourceOperation, Method>> findOperations(String entityPath, Class<?> anyClass) {
        HashMap<String, Pair<ResourceOperation, Method>> embeds = new HashMap<String, Pair<ResourceOperation, Method>>();
        List<Method> annotatedMethods = ResourceInspectorUtil.findMethodsByAnnotation(anyClass, Operation.class);
        if (annotatedMethods != null && !annotatedMethods.isEmpty()) {
            for (Method annotatedMethod : annotatedMethods) {
                Annotation annot = AnnotationUtils.findAnnotation((Method)annotatedMethod, Operation.class);
                if (annot == null) continue;
                Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
                String actionName = String.valueOf(annotAttribs.get("value"));
                String actionPath = ResourceDictionary.propertyResourceKey(entityPath, actionName);
                ResourceOperation ro = ResourceInspector.inspectOperation(anyClass, annotatedMethod, HttpMethod.POST);
                embeds.put(actionPath, (Pair<ResourceOperation, Method>)new Pair((Object)ro, (Object)annotatedMethod));
            }
        }
        return embeds;
    }

    public static Api inspectApi(Class<?> resource) {
        Package myPackage = resource.getPackage();
        WebApi annot = myPackage.getAnnotation(WebApi.class);
        if (annot != null) {
            Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
            String apiName = String.valueOf(annotAttribs.get("name"));
            String apiScope = String.valueOf(annotAttribs.get("scope"));
            String apiVersion = String.valueOf(annotAttribs.get("version"));
            return Api.valueOf(apiName, apiScope, apiVersion);
        }
        return null;
    }

    public static List<ResourceMetadata> inspect(Class resource) {
        EntityResource annot = (EntityResource)AnnotationUtils.findAnnotation((Class)resource, EntityResource.class);
        if (annot != null) {
            return ResourceInspector.inspectEntity(annot, resource);
        }
        RelationshipResource relAnnot = (RelationshipResource)AnnotationUtils.findAnnotation((Class)resource, RelationshipResource.class);
        if (relAnnot != null) {
            return ResourceInspector.inspectRelationship(relAnnot, resource);
        }
        throw new UnsupportedOperationException("Unable to inspect " + resource.getName());
    }

    public static String findUniqueId(Object obj) {
        Class<?> objClass = obj.getClass();
        Method annotatedMethod = ResourceInspector.findUniqueIdMethod(objClass);
        Object id = ResourceInspectorUtil.invokeMethod(annotatedMethod, obj);
        if (id != null) {
            if (id instanceof NodeRef) {
                return ((NodeRef)id).getId();
            }
            return String.valueOf(id);
        }
        return null;
    }

    public static Method findUniqueIdMethod(Class<?> objClass) throws IllegalArgumentException {
        List<Method> annotatedMethods = ResourceInspectorUtil.findMethodsByAnnotation(objClass, UniqueId.class);
        if (annotatedMethods != null && !annotatedMethods.isEmpty()) {
            if (annotatedMethods.size() != 1) {
                throw new IllegalArgumentException("There should only ever be one UniqueId annotation on a class but " + String.valueOf(objClass) + " has " + annotatedMethods.size());
            }
            return annotatedMethods.get(0);
        }
        return null;
    }

    public static String findUniqueIdName(Method uniqueIdMethod) {
        Annotation annot = AnnotationUtils.findAnnotation((Method)uniqueIdMethod, UniqueId.class);
        if (annot != null) {
            Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)annot);
            String uniqueIdName = String.valueOf(annotAttribs.get("name"));
            return uniqueIdName;
        }
        return "id";
    }

    static {
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.Create.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.Read.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.ReadById.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.Update.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.Delete.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.DeleteSet.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(BinaryResourceAction.Read.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.CreateWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.ReadWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.ReadByIdWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.UpdateWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.DeleteWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(EntityResourceAction.DeleteSetWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(BinaryResourceAction.ReadWithResponse.class);
        ALL_ENTITY_RESOURCE_INTERFACES.add(MultiPartResourceAction.Create.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.Create.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.Read.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.ReadById.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.Update.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.Delete.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.DeleteSet.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.CreateWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.ReadWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.ReadByIdWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.UpdateWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.DeleteWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(RelationshipResourceAction.DeleteSetWithResponse.class);
        ALL_RELATIONSHIP_RESOURCE_INTERFACES.add(MultiPartRelationshipResourceAction.Create.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.Read.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.Delete.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.Update.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.ReadWithResponse.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.DeleteWithResponse.class);
        ALL_PROPERTY_RESOURCE_INTERFACES.add(BinaryResourceAction.UpdateWithResponse.class);
    }

    private static class MetaHelper
    extends MetaHelperCallback {
        private List<ResourceOperation> operations = new ArrayList<ResourceOperation>();
        private Set<Class<? extends ResourceAction>> apiDeleted = new HashSet<Class<? extends ResourceAction>>();
        private Set<Class<? extends ResourceAction>> apiNoAuth = new HashSet<Class<? extends ResourceAction>>();

        public MetaHelper(Class<?> resource) {
            super(resource);
        }

        @Override
        public void whenNewOperation(ResourceOperation operation, Method aMethod) {
            this.operations.add(operation);
        }

        @Override
        public void whenOperationDeleted(Class<? extends ResourceAction> deleted, Method aMethod) {
            this.apiDeleted.add(deleted);
        }

        @Override
        public void whenOperationNoAuth(Class<? extends ResourceAction> noAuth, Method aMethod) {
            this.apiNoAuth.add(noAuth);
        }
    }

    private static abstract class MetaHelperCallback {
        final Class<?> resource;

        public MetaHelperCallback(Class<?> resource) {
            this.resource = resource;
        }

        public abstract void whenNewOperation(ResourceOperation var1, Method var2);

        public abstract void whenOperationDeleted(Class<? extends ResourceAction> var1, Method var2);

        public abstract void whenOperationNoAuth(Class<? extends ResourceAction> var1, Method var2);
    }

    private static class MetaHelperAddressable
    extends MetaHelperCallback {
        private Set<Class<? extends ResourceAction>> apiNoAuth = new HashSet<Class<? extends ResourceAction>>();
        private String entityPath;
        private Map<String, List<ResourceOperation>> operationGroupedByProperty;

        public MetaHelperAddressable(Class<?> resource, String entityPath, Map<String, List<ResourceOperation>> operationGroupedByProperty) {
            super(resource);
            this.entityPath = entityPath;
            this.operationGroupedByProperty = operationGroupedByProperty;
        }

        public MetaHelperAddressable(Class<?> resource) {
            super(resource);
        }

        @Override
        public void whenNewOperation(ResourceOperation operation, Method aMethod) {
            Annotation addressableProps = AnnotationUtils.findAnnotation((Method)aMethod, BinaryProperties.class);
            if (addressableProps != null) {
                String[] props;
                Map annotAttribs = AnnotationUtils.getAnnotationAttributes((Annotation)addressableProps);
                for (String property : props = (String[])annotAttribs.get("value")) {
                    String propKey = ResourceDictionary.propertyResourceKey(this.entityPath, property);
                    if (!this.operationGroupedByProperty.containsKey(propKey)) {
                        ArrayList ops = new ArrayList();
                        this.operationGroupedByProperty.put(propKey, ops);
                    }
                    List<ResourceOperation> operations = this.operationGroupedByProperty.get(propKey);
                    operations.add(operation);
                }
            } else {
                logger.warn((Object)("Resource " + this.resource.getCanonicalName() + " should declare a @BinaryProperties annotation."));
            }
        }

        @Override
        public void whenOperationDeleted(Class<? extends ResourceAction> deleted, Method aMethod) {
        }

        @Override
        public void whenOperationNoAuth(Class<? extends ResourceAction> noAuth, Method aMethod) {
            this.apiNoAuth.add(noAuth);
        }
    }
}

