/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionaryBuilder;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.alfresco.rest.framework.tests.api.mocks.GoatEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.GrassEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepBaaaahResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepBlackSheepResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepEntityResource;
import org.alfresco.rest.framework.tests.api.mocks3.FlockEntityResource;
import org.alfresco.rest.framework.tests.api.mocks3.FlocketEntityResource;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-rest-context.xml"})
public class ResourceLocatorTests {
    @Autowired
    ResourceLookupDictionary locator;
    @Autowired
    private ApplicationContext applicationContext;
    private static Api api = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");

    @Before
    public void setUp() throws Exception {
        Map entityResourceBeans = this.applicationContext.getBeansWithAnnotation(EntityResource.class);
        Map relationResourceBeans = this.applicationContext.getBeansWithAnnotation(RelationshipResource.class);
        this.locator.setDictionary(ResourceDictionaryBuilder.build(entityResourceBeans.values(), relationResourceBeans.values()));
    }

    @Test(expected=UnsupportedResourceOperationException.class)
    public void testLocateResourcesByType() {
        Api api1 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api1, "sheep", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        Assert.assertEquals(SheepEntityResource.class, entityResource.getResource().getClass());
        Assert.assertTrue((boolean)ResourceMetadata.RESOURCE_TYPE.ENTITY.equals((Object)entityResource.getMetaData().getType()));
        Api api2 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"2");
        this.locateByVersion(api1);
        this.locateByVersion(api2);
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api1, "sheep", "baah", HttpMethod.GET);
    }

    protected void locateByVersion(Api api) {
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        Assert.assertNotNull((Object)relationResource);
        Assert.assertEquals(SheepBaaaahResource.class, relationResource.getResource().getClass());
        Assert.assertTrue((boolean)ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP.equals((Object)relationResource.getMetaData().getType()));
        relationResource = this.locator.locateRelationResource(api, "sheep", "blacksheep", HttpMethod.GET);
        Assert.assertNotNull((Object)relationResource);
        Assert.assertEquals(SheepBlackSheepResource.class, relationResource.getResource().getClass());
        Assert.assertTrue((boolean)ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP.equals((Object)relationResource.getMetaData().getType()));
    }

    @Test(expected=UnsupportedResourceOperationException.class)
    public void testLocateResource() {
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "sheep");
        ResourceWithMetadata collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.POST);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.POST));
        templateVars.put("entityId", "farmersUniqueId");
        ResourceWithMetadata entityResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        Assert.assertNotNull((Object)entityResource.getMetaData().getOperation(HttpMethod.GET));
        entityResource = this.locator.locateResource(api, templateVars, HttpMethod.PUT);
        Assert.assertNotNull((Object)entityResource);
        Assert.assertNotNull((Object)entityResource.getMetaData().getOperation(HttpMethod.PUT));
        templateVars.clear();
        templateVars.put("collectionResource", "sheepnoaction");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
    }

    @Test
    public void testLocateActions() {
        HashMap<String, String> templateVars = new HashMap<String, String>();
        ResourceWithMetadata collResource = null;
        templateVars.put("collectionResource", "grass");
        templateVars.put("entityId", "grassId");
        templateVars.put("relationResource", "cut");
        try {
            collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.POST);
        Assert.assertEquals(GrassEntityResource.class, collResource.getResource().getClass());
        Assert.assertEquals((Object)ResourceMetadata.RESOURCE_TYPE.OPERATION, (Object)collResource.getMetaData().getType());
        templateVars = new HashMap();
        templateVars.put("collectionResource", "sheep");
        templateVars.put("entityId", "sheepId");
        templateVars.put("relationResource", "baaahh");
        templateVars.put("property", "chew");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.POST);
        Assert.assertEquals(SheepBaaaahResource.class, collResource.getResource().getClass());
        Assert.assertEquals((Object)ResourceMetadata.RESOURCE_TYPE.OPERATION, (Object)collResource.getMetaData().getType());
    }

    @Test
    public void testLocateProperties() {
        Api api3 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"3");
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "flock");
        templateVars.put("entityId", "flockId");
        templateVars.put("relationResource", "photo");
        ResourceWithMetadata collResource = this.locator.locateResource(api3, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        Assert.assertEquals(FlockEntityResource.class, collResource.getResource().getClass());
        templateVars.put("collectionResource", "flocket");
        templateVars.put("relationResource", "madeUpProp");
        try {
            collResource = this.locator.locateResource(api3, templateVars, HttpMethod.PUT);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
        try {
            collResource = this.locator.locateResource(api3, templateVars, HttpMethod.DELETE);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
        collResource = this.locator.locateResource(api3, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        Assert.assertEquals(FlocketEntityResource.class, collResource.getResource().getClass());
        templateVars.put("relationResource", "album");
        try {
            collResource = this.locator.locateResource(api3, templateVars, HttpMethod.DELETE);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
        collResource = this.locator.locateResource(api3, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        Assert.assertEquals(FlocketEntityResource.class, collResource.getResource().getClass());
        collResource = this.locator.locateResource(api3, templateVars, HttpMethod.PUT);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.PUT));
        Assert.assertEquals(FlocketEntityResource.class, collResource.getResource().getClass());
    }

    @Test
    public void testLocateRelationshipProperties() {
        ResourceWithMetadata collResource;
        Api api3 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"3");
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "goat");
        templateVars.put("entityId", "herdId");
        templateVars.put("relationResource", "herd");
        try {
            collResource = this.locator.locateResource(api3, templateVars, HttpMethod.PUT);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
        templateVars.put("property", "content");
        collResource = this.locator.locateResource(api3, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        templateVars = new HashMap();
        templateVars.put("collectionResource", "sheep");
        templateVars.put("entityId", "sheepId");
        templateVars.put("relationResource", "baaahh");
        templateVars.put("property", "content");
        try {
            collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
            Assert.fail((String)"Should throw an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        templateVars.put("property", "photo");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.PUT));
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.DELETE));
    }

    @Test
    public void testApiValues() {
        Api testApi;
        try {
            testApi = Api.valueOf(null, null, null);
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        try {
            testApi = Api.valueOf((String)"alfrescomock", (String)"public", (String)"0");
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        try {
            testApi = Api.valueOf((String)"AlfrescoMock", (String)"public", (String)"1");
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        try {
            testApi = Api.valueOf((String)"alfrescomock", (String)"nonsense", (String)"1");
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        testApi = Api.valueOf((String)"alfrescomock", (String)"Public", (String)"1");
        Assert.assertNotNull((Object)testApi);
    }

    @Test
    public void testInvalidApis() {
        ResourceWithMetadata entityResource = null;
        try {
            entityResource = this.locator.locateEntityResource(Api.valueOf((String)"alfrescomock", (String)"public", (String)"1"), "sheep", HttpMethod.GET);
            Assert.fail((String)"Should throw an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            entityResource = this.locator.locateEntityResource(Api.valueOf((String)"alfrescomock", (String)"public", (String)"999"), "sheep", HttpMethod.GET);
            Assert.fail((String)"Should throw an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        entityResource = this.locator.locateEntityResource(Api.valueOf((String)"alfrescomock", (String)"private", (String)"1"), "sheep", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
    }

    @Test
    public void testResourceVersions() {
        ResourceWithMetadata aResource = null;
        try {
            aResource = this.locator.locateEntityResource(api, "sheepnoaction", HttpMethod.GET);
            Assert.fail((String)"Should throw an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Api v2 = Api.valueOf((String)api.getName(), (String)api.getScope().toString(), (String)"2");
        aResource = this.locator.locateEntityResource(v2, "sheepnoaction", HttpMethod.GET);
        Assert.assertNotNull((Object)aResource);
        aResource = this.locator.locateEntityResource(v2, "sheep", HttpMethod.GET);
        Assert.assertNotNull((Object)aResource);
        try {
            aResource = this.locator.locateRelationResource(api, "sheepnoaction", "v3isaresource", HttpMethod.GET);
            Assert.fail((String)"Only available in v3");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            aResource = this.locator.locateRelationResource(v2, "sheepnoaction", "v3isaresource", HttpMethod.GET);
            Assert.fail((String)"Only available in v3");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Api v3 = Api.valueOf((String)api.getName(), (String)api.getScope().toString(), (String)"3");
        aResource = this.locator.locateRelationResource(v3, "sheepnoaction", "v3isaresource", HttpMethod.GET);
        Assert.assertNotNull((String)"This resource is only available in v3", (Object)aResource);
        aResource = this.locator.locateEntityResource(v3, "sheep", HttpMethod.GET);
        Assert.assertNotNull((String)"This resource should be available in v3", (Object)aResource);
    }

    @Test
    public void testGetEmbeddedResources() {
        Map embeddded = ResourceInspector.findEmbeddedResources(Farmer.class);
        Assert.assertNotNull((Object)embeddded);
        HashMap<String, ResourceWithMetadata> results = new HashMap<String, ResourceWithMetadata>(embeddded.size());
        for (Map.Entry embeddedEntry : embeddded.entrySet()) {
            ResourceWithMetadata res = this.locator.locateEntityResource(api, (String)((Pair)embeddedEntry.getValue()).getFirst(), HttpMethod.GET);
            results.put((String)embeddedEntry.getKey(), res);
        }
        Assert.assertNotNull(results);
        Assert.assertTrue((results.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)SheepEntityResource.class.equals(((ResourceWithMetadata)results.get("sheep")).getResource().getClass()));
        Object goatResource = ((ResourceWithMetadata)results.get("goat")).getResource();
        Assert.assertTrue((boolean)GoatEntityResource.class.equals(goatResource.getClass()));
    }

    @Test
    public void testFindEntityCollectionName() {
        ResourceWithMetadata collResource = this.locator.locateEntityResource(api, "sheep", HttpMethod.GET);
        String name = ResourceInspector.findEntityCollectionNameName((ResourceMetadata)collResource.getMetaData());
        Assert.assertEquals((Object)"sheep", (Object)name);
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        name = ResourceInspector.findEntityCollectionNameName((ResourceMetadata)relationResource.getMetaData());
        Assert.assertEquals((Object)"sheep", (Object)name);
        relationResource = this.locator.locateRelationResource(api, "sheep", "blacksheep", HttpMethod.GET);
        name = ResourceInspector.findEntityCollectionNameName((ResourceMetadata)relationResource.getMetaData());
        Assert.assertEquals((Object)"sheep", (Object)name);
        Api v2 = Api.valueOf((String)api.getName(), (String)api.getScope().toString(), (String)"2");
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "sheepnoaction");
        collResource = this.locator.locateResource(v2, templateVars, HttpMethod.GET);
        name = ResourceInspector.findEntityCollectionNameName((ResourceMetadata)collResource.getMetaData());
        Assert.assertEquals((Object)"sheepnoaction", (Object)name);
    }

    @Test(expected=NotFoundException.class)
    public void testLocateRelationResource() {
        List<String> relKeys = Arrays.asList("blacksheep", "baaahh");
        Map embeds = this.locator.locateRelationResource(api, "sheep", relKeys, HttpMethod.GET);
        Assert.assertNotNull((Object)embeds);
        relKeys = Arrays.asList("nonsense");
        embeds = this.locator.locateRelationResource(api, "sheep", relKeys, HttpMethod.GET);
        Assert.assertNotNull((Object)embeds);
    }
}

