/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;

public abstract class HierarchicalMethod
extends WebDAVMethod {
    protected String m_strDestinationPath;
    protected boolean m_overwrite = true;

    public final String getDestinationPath() {
        return this.m_strDestinationPath;
    }

    public final boolean hasOverWrite() {
        return this.m_overwrite;
    }

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        String destURL = this.m_request.getHeader("Destination");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing Destination header: " + destURL));
        }
        this.getDAVHelper().checkDestinationURL(this.m_request, destURL);
        this.m_strDestinationPath = this.getDAVHelper().getDestinationPath(this.getContextPath(), this.getServletPath(), destURL);
        if (this.m_strDestinationPath == null) {
            logger.warn((Object)("Failed to parse the Destination header: " + destURL));
            throw new WebDAVServerException(400);
        }
        String strOverwrite = this.m_request.getHeader("Overwrite");
        if (strOverwrite != null && strOverwrite.equals("F")) {
            this.m_overwrite = false;
        }
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }
}

