/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.quicksharelinks;

import java.util.List;
import org.alfresco.rest.api.QuickShareLinks;
import org.alfresco.rest.api.model.QuickShareLink;
import org.alfresco.rest.api.model.QuickShareLinkEmailRequest;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="shared-links", title="Shared Links")
public class QuickShareLinkEntityResource
implements EntityResourceAction.ReadById<QuickShareLink>,
BinaryResourceAction.Read,
EntityResourceAction.Delete,
EntityResourceAction.Create<QuickShareLink>,
EntityResourceAction.Read<QuickShareLink>,
InitializingBean {
    private QuickShareLinks quickShareLinks;

    public void setQuickShareLinks(QuickShareLinks quickShareLinks) {
        this.quickShareLinks = quickShareLinks;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"quickShareLinks", (Object)this.quickShareLinks);
    }

    @Override
    @WebApiDescription(title="Get shared link info", description="Return limited metadata for shared link")
    @WebApiNoAuth
    public QuickShareLink readById(String sharedId, Parameters parameters) {
        return this.quickShareLinks.readById(sharedId, parameters);
    }

    @Override
    @WebApiDescription(title="Download shared link content", description="Download content for shared link")
    @WebApiNoAuth
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String sharedId, Parameters parameters) throws EntityNotFoundException {
        return this.quickShareLinks.readProperty(sharedId, null, parameters);
    }

    @Override
    @WebApiDescription(title="Delete shared link", description="Delete the shared link")
    public void delete(String sharedId, Parameters parameters) {
        this.quickShareLinks.delete(sharedId, parameters);
    }

    @Override
    @WebApiDescription(title="Create shared link", description="Create a new unique system-generated shared (link) id")
    public List<QuickShareLink> create(List<QuickShareLink> nodeIds, Parameters parameters) {
        return this.quickShareLinks.create(nodeIds, parameters);
    }

    @Operation(value="email")
    @WebApiDescription(title="Email shared link", successStatus=202)
    public void email(String sharedId, QuickShareLinkEmailRequest emailRequest, Parameters parameters, WithResponse response) {
        this.quickShareLinks.emailSharedLink(sharedId, emailRequest, parameters);
    }

    @Override
    @WebApiDescription(title="Find shared links", description="Find ('search') & return result set of shared links")
    public CollectionWithPagingInfo<QuickShareLink> readAll(Parameters parameters) {
        return this.quickShareLinks.findLinks(parameters);
    }
}

